/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data.userfilter;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.data.userfilter.HasMailFilter;
import com.inet.helpdesk.data.userfilter.LocationFilter;
import com.inet.helpdesk.data.userfilter.PermissionFilter;
import com.inet.helpdesk.data.userfilter.ResourceFilter;
import com.inet.helpdesk.data.userfilter.SearchUserFilter;
import com.inet.helpdesk.data.userfilter.SupporterUserFilter;
import com.inet.helpdesk.data.userfilter.TicketRecipientFilter;
import com.inet.helpdesk.data.userfilter.UserFilter;
import com.inet.helpdesk.data.userfilter.UserGroupFilter;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.search.rpc.UserListFilterCondition;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class UserFilterCombined
implements UserFilter {
    private List<UserFilter> filterList = new ArrayList<UserFilter>();

    public UserFilterCombined(List<UserListFilterCondition> conditions) throws ServerDataException {
        if (conditions != null) {
            for (UserListFilterCondition condition : conditions) {
                switch (condition.getOperand1()) {
                    case SearchText: {
                        this.filterList.add(new SearchUserFilter(condition.getOperand2(), Field.USERDATA_FIRSTNAME, Field.USERDATA_LASTNAME, Field.USERDATA_EMAIL, Field.USERDATA_USERNAME));
                        break;
                    }
                    case EmailUser: {
                        this.filterList.add(new SearchUserFilter(condition.getOperand2(), Field.USERDATA_FIRSTNAME, Field.USERDATA_LASTNAME, Field.USERDATA_EMAIL));
                        break;
                    }
                    case EmailAddress: {
                        this.filterList.add(new HasMailFilter(condition.getOperand2()));
                        break;
                    }
                    case Location: {
                        this.filterList.add(new LocationFilter(condition.getFilterOperator(), condition.getOperand2()));
                        break;
                    }
                    case Resource: {
                        this.filterList.add(new ResourceFilter());
                        break;
                    }
                    case TouchedTicket: {
                        this.filterList.add(new TicketRecipientFilter(condition.getOperand2()));
                        break;
                    }
                    case Supporter: {
                        this.filterList.add(new SupporterUserFilter(condition.getOperand2()));
                        break;
                    }
                    case Permission: {
                        this.filterList.add(new PermissionFilter(condition.getOperand2()));
                        break;
                    }
                    case Group: {
                        this.filterList.add(new UserGroupFilter(condition.getFilterOperator(), condition.getOperand2()));
                        break;
                    }
                    case UserField: {
                        if (!"USERDATA_USERID".equals(condition.getOperand1FieldName())) break;
                        this.filterList.add(new SearchUserFilter(condition.getOperand2(), Field.USERDATA_USERID));
                        break;
                    }
                }
            }
        }
    }

    @Override
    public int score(UserAccount userAccount) {
        if (this.filterList.isEmpty()) {
            return 1;
        }
        int score = 0;
        for (UserFilter filter : this.filterList) {
            int subScore = filter.score(userAccount);
            if (subScore <= 0) {
                return 0;
            }
            score += subScore;
        }
        return score;
    }

    public String getBestSecondaryMatch() {
        for (UserFilter filter : this.filterList) {
            if (!(filter instanceof SearchUserFilter)) continue;
            return ((SearchUserFilter)filter).getBestMatch();
        }
        return null;
    }
}

