/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.helpdesk.core.model.general.Sorting;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationVO;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.shared.util.UtilityFunctions;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import java.sql.Timestamp;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;
import srv.controller.ticket.Auftrag;

public class AuftragsSorter {
    private Sorting.SortField sortField;
    private Sorting.SortType sortType = Sorting.SortType.ORIGINAL;
    private String clientLanguage = "de";
    private long groupByLastSync;

    private AuftragsSorter() {
    }

    public AuftragsSorter(Sorting.SortField sortField, Sorting.SortType sortType, String clientLanguage, long groupByLastSync) {
        this.sortField = sortField;
        this.sortType = sortType;
        this.clientLanguage = clientLanguage;
        this.groupByLastSync = groupByLastSync;
    }

    public Sorting.SortField getSortField() {
        return this.sortField;
    }

    public Sorting.SortType getSortType() {
        return this.sortType;
    }

    public String getClientLanguage() {
        return this.clientLanguage;
    }

    public long getGroupByLastSync() {
        return this.groupByLastSync;
    }

    public Comparator<Auftrag> getComparator() {
        return new SortingComparator(this.sortField, this.sortType, new Locale(this.clientLanguage, Locale.getDefault().getCountry()), this.groupByLastSync);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AuftragsSorter) {
            AuftragsSorter sorting = (AuftragsSorter)obj;
            boolean equals = true;
            equals &= this.clientLanguage == null ? sorting.clientLanguage == null : this.clientLanguage.equals(sorting.clientLanguage);
            equals &= this.sortField == null ? sorting.sortField == null : this.sortField.equals((Object)sorting.sortField);
            return equals &= this.sortType == null ? sorting.sortType == null : this.sortType.equals((Object)sorting.sortType);
        }
        return super.equals(obj);
    }

    private static class SortingComparator
    implements Comparator<Auftrag> {
        private final Sorting.SortField sortField;
        private final Sorting.SortType sortType;
        private final Locale locale;
        private long lastSync;

        public SortingComparator(Sorting.SortField sortField, Sorting.SortType sortType, Locale locale, long lastSync) {
            this.sortField = sortField;
            this.sortType = sortType;
            this.locale = locale;
            this.lastSync = lastSync;
        }

        @Override
        public int compare(Auftrag o1, Auftrag o2) {
            Comparable<?> comp2;
            if (this.lastSync > 0L) {
                Timestamp d1 = o1.getLastChanged();
                Timestamp d2 = o2.getLastChanged();
                if (d1 != null && d2 != null) {
                    if (d1.getTime() >= this.lastSync) {
                        if (d2.getTime() < this.lastSync) {
                            return -1;
                        }
                    } else if (d2.getTime() >= this.lastSync && d1.getTime() < this.lastSync) {
                        return 1;
                    }
                }
            }
            Comparable<?> comp1 = o1 != null ? this.getComparableField(o1) : null;
            Comparable<?> comparable = comp2 = o2 != null ? this.getComparableField(o2) : null;
            if (comp1 == null) {
                return comp2 == null ? 0 : (this.sortType == Sorting.SortType.ASCENDING ? -1 : 1);
            }
            if (comp2 == null) {
                return this.sortType == Sorting.SortType.ASCENDING ? 1 : -1;
            }
            int compareResult = 0;
            if (comp1 instanceof String && comp2 instanceof String) {
                RuleBasedCollator collator = UtilityFunctions.getRuleBasedCollator(this.locale);
                compareResult = this.sortType == Sorting.SortType.ASCENDING ? collator.compare((String)((Object)comp1), (String)((Object)comp2)) : collator.compare((String)((Object)comp2), (String)((Object)comp1));
            } else {
                int n = compareResult = this.sortType == Sorting.SortType.ASCENDING ? comp1.compareTo(comp2) : comp2.compareTo(comp1);
            }
            if (compareResult == 0) {
                return o2.getOrderID() - o1.getOrderID();
            }
            return compareResult;
        }

        private Comparable<?> getComparableField(Auftrag auf) {
            if (this.sortField == Sorting.SortField.TICKETID) {
                return auf.getOrderID();
            }
            if (this.sortField == Sorting.SortField.STATUSID) {
                return auf.getStatus();
            }
            if (this.sortField == Sorting.SortField.PRIOID) {
                return new Long(auf.getPriority().getId());
            }
            if (this.sortField == Sorting.SortField.SUBJECT) {
                return auf.getSubject();
            }
            if (this.sortField == Sorting.SortField.LASTMODIFIED) {
                return auf.getLastChanged();
            }
            if (this.sortField == Sorting.SortField.UNREAD) {
                return auf.getStatus() == 0 || auf.getStatus() == 100 || auf.getStatus() == 101;
            }
            if (this.sortField == Sorting.SortField.CATEGORY) {
                return auf.getCategory().getPath().toLowerCase();
            }
            if (this.sortField == Sorting.SortField.CLASSIFICATION) {
                ClassificationVO classification = auf.getClassification();
                return classification.getDisplayValue().toLowerCase();
            }
            if (this.sortField == Sorting.SortField.RESOURCE) {
                return auf.getResource().getDisplayValue().toLowerCase();
            }
            if (this.sortField == Sorting.SortField.TICKETFIELD1) {
                return auf.getAttribut(Auftrag.Field.PREDEFINED_TICKETFIELD1).getDisplayValue();
            }
            if (this.sortField == Sorting.SortField.TICKETFIELD2) {
                return auf.getAttribut(Auftrag.Field.PREDEFINED_TICKETFIELD2).getDisplayValue();
            }
            if (this.sortField == Sorting.SortField.TICKETFIELD3) {
                return auf.getAttribut(Auftrag.Field.PREDEFINED_TICKETFIELD3).getDisplayValue();
            }
            if (this.sortField == Sorting.SortField.TICKETFIELD4) {
                return auf.getAttribut(Auftrag.Field.PREDEFINED_TICKETFIELD4).getDisplayValue();
            }
            UserAccount owner = auf.getUser();
            if (this.sortField == Sorting.SortField.TICKETOWNER) {
                if (owner == null) {
                    return "";
                }
                String lastname = (String)owner.getValue((UserField)UsersAndGroups.FIELD_LASTNAME);
                if (lastname != null && lastname.length() > 0) {
                    return lastname;
                }
                return owner.getDisplayName();
            }
            if (this.sortField == Sorting.SortField.CONTACTNAME) {
                return null;
            }
            if (this.sortField == Sorting.SortField.LOCATION) {
                return owner != null ? ((LocationVO)LocationManager.getInstance().get((Integer)owner.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID))).getDisplayValue().toLowerCase() : "";
            }
            return null;
        }
    }
}

