/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.ui.model;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class FieldEditDefinition {
    public static String TEXTINPUT = "textinput";
    public static String SELECT = "select";
    public static String SELECT_MULTI = "selectmulti";
    public static String SELECT_EDITABLE = "selecteditable";
    public static String DATEVALUE = "datevalue";
    public static String OWNER = "ticketowner";

    public abstract String getFieldKey();

    public abstract String getDisplayName();

    public abstract String getDisplayType();

    public abstract void updateTicketData(MutableTicketData var1, @Nonnull Map<String, String> var2);

    public abstract void updateCurrentValue(@Nullable TicketVO var1, @Nullable GUID var2, @Nonnull Map<String, String> var3);

    public boolean isAvailable(List<TicketVO> tickets) {
        boolean supporter = HDUsersAndGroups.isSupporter(UserManager.getInstance().getCurrentUserAccount());
        if (supporter && tickets != null) {
            ActionVO action = (ActionVO)ActionManager.getInstance().get(-29);
            for (TicketVO ticket : tickets) {
                if (TicketManager.getTicketActionChecker().checkAction(action, ticket, TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket)) == null) continue;
                return false;
            }
        }
        return supporter;
    }
}

