/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.helpdesk.core.data.LocalizationBundle;
import com.inet.helpdesk.core.data.TranslationTextConnector;
import com.inet.helpdesk.core.model.general.Localization;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.NoTokenTokenizer;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.usersandgroups.api.BasicFieldValidation;
import java.util.Locale;

public class TicketFieldCustomField
extends TicketField<String> {
    public static final String KEY_ONE = "custom1";
    public static final String KEY_TWO = "custom2";
    public static final String KEY_THREE = "custom3";
    public static final String KEY_FOUR = "custom4";
    public static final String KEY_FIVE = "custom5";
    public static final String KEY_SIX = "custom6";
    public static final String KEY_SEVEN = "custom7";
    private static LocalizationBundle localizationBundle;
    private static TranslationTextConnector translationTextConnector;
    private final int maxLength;

    public static TicketFieldCustomField createFirst() {
        return new TicketFieldCustomField(KEY_ONE, 500, 255);
    }

    public static TicketFieldCustomField createSecond() {
        return new TicketFieldCustomField(KEY_TWO, 490, 255);
    }

    public static TicketFieldCustomField createThird() {
        return new TicketFieldCustomField(KEY_THREE, 480, 255);
    }

    public static TicketFieldCustomField createFourth() {
        return new TicketFieldCustomField(KEY_FOUR, 470, 255);
    }

    public static TicketFieldCustomField createFifth() {
        return new TicketFieldCustomField(KEY_FIVE, 460, Integer.MAX_VALUE);
    }

    public static TicketFieldCustomField createSixth() {
        return new TicketFieldCustomField(KEY_SIX, 450, 100);
    }

    public static TicketFieldCustomField createSeventh() {
        return new TicketFieldCustomField(KEY_SEVEN, 440, 100);
    }

    private TicketFieldCustomField(String key, int priority, int maxLength) {
        super(TicketFieldCustomField.createSearchTag(key, priority), "");
        this.maxLength = maxLength;
    }

    private static SearchTag createSearchTag(final String key, int priority) {
        return new SearchTag(key, (SearchTokenizer)new NoTokenTokenizer(), priority, key, true){

            public String getDisplayName() {
                if (localizationBundle == null || translationTextConnector == null) {
                    ServerPluginManager spm = ServerPluginManager.getInstance();
                    localizationBundle = (LocalizationBundle)spm.getSingleInstance(LocalizationBundle.class);
                    translationTextConnector = (TranslationTextConnector)spm.getSingleInstance(TranslationTextConnector.class);
                }
                Localization localization = localizationBundle.getInstance(ClientLocale.getThreadLocale(), translationTextConnector);
                return localization.getTranslation("helpdesk", "TF_" + key);
            }
        };
    }

    public String getValidOrDefaultValue(String value, GUID entryID) {
        if (value == null) {
            return "";
        }
        return (String)super.getValidOrDefaultValue((Object)value, entryID);
    }

    public void validate(String value) {
        super.validate((Object)value);
        if (value != null) {
            BasicFieldValidation.throwIfLengthExceedsLimit((String)value, (int)this.maxLength);
        }
    }

    @Override
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(TicketVOSingle master, TicketVOSingle slave) {
        return slave;
    }

    @Override
    public String valueToString(String fieldValue) {
        return fieldValue;
    }

    @Override
    public String getFieldDisplayName(Locale locale) {
        return HDFieldDisplayNameProvider.getDisplayNameForCustomField(this, locale);
    }
}

