/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.usersandgroups.api.BasicFieldValidation;
import java.util.Map;

public class TicketFieldClassificationId
extends TicketField<Integer> {
    public static final String KEY = "classificationid";
    public static final Integer DEFAULT_ID = 0;

    public TicketFieldClassificationId() {
        super(TicketFieldClassificationId.createSearchTag(), DEFAULT_ID);
    }

    private static SearchTag createSearchTag() {
        return new SearchTag(KEY, SearchDataType.IntegerMap, false, 100, KEY, true){

            public String getDisplayName() {
                return HDFieldDisplayNameProvider.getDisplayNameForCustomField(Tickets.FIELD_CLASSIFICATION_ID);
            }

            public Map<Integer, String> getMapData() {
                return ClassificationManager.getInstance().getAllAttributeDisplayNames(false);
            }
        };
    }

    public void validate(Integer value) {
        super.validate((Object)value);
        BasicFieldValidation.throwIfNull((Object)value);
        BasicFieldValidation.throwIfNegative((int)value);
    }

    @Override
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(TicketVOSingle master, TicketVOSingle slave) {
        return master;
    }

    @Override
    public String valueToString(Integer fieldValue) {
        Object oldCategoryVO = ClassificationManager.getInstance().get(fieldValue);
        if (oldCategoryVO != null) {
            return ((FieldVO)oldCategoryVO).getDisplayValue();
        }
        return null;
    }

    @Override
    protected int getFieldChangeReaStepActionId() {
        return -28;
    }
}

