/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.id.GUID;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.search.tokenizers.TextSearchTokenizer;
import com.inet.usersandgroups.api.BasicFieldValidation;

public class TicketFieldAnnotation
extends TicketField<String> {
    public static final String KEY = "annotation";
    public static final String DEFAULT_EMPTY_ANNOTATION = "";

    public TicketFieldAnnotation() {
        super(TicketFieldAnnotation.createSearchTag(), DEFAULT_EMPTY_ANNOTATION);
    }

    private static SearchTag createSearchTag() {
        return new SearchTag(KEY, (SearchTokenizer)TextSearchTokenizer.DEFAULT, 100, KEY, true){

            public String getDisplayName() {
                return Tickets.getFieldDisplayName(TicketFieldAnnotation.KEY);
            }
        };
    }

    @Override
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(TicketVOSingle master, TicketVOSingle slave) {
        return slave;
    }

    public String getValidOrDefaultValue(String value, GUID entryID) {
        if (value == null) {
            return DEFAULT_EMPTY_ANNOTATION;
        }
        return (String)super.getValidOrDefaultValue((Object)value, entryID);
    }

    public void validate(String value) {
        super.validate((Object)value);
        BasicFieldValidation.throwIfNull((Object)value);
        BasicFieldValidation.throwIfLengthExceedsLimit((String)value, (int)2500);
    }

    @Override
    public String valueToString(String fieldValue) {
        return fieldValue;
    }

    @Override
    public OperationNewReaStep createStringFieldChangeReaStep(String oldFieldValue, String newFieldValue, OperationChangedTicket ticket) {
        MutableReaStepData data = new MutableReaStepData();
        data.put(ReaStepVO.FIELD_DESC, Tickets.MSG.getMsg("field.annotation.changed", new Object[0]));
        data.put(ReaStepVO.FIELD_PROCESSING_TIME, ProcessingTime.of(ticket.getAttributeValue(Tickets.ATTRIBUTE_LAST_CHANGED)));
        return ticket.addReaStep(-29, data, MutableReaStepText.empty());
    }
}

