/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.tickets.StorageLocationInfo;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.search.SearchTag;
import com.inet.usersandgroups.api.Field;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class TicketField<VALUE>
extends Field<VALUE> {
    public static final int DEFAULT_FIELD_PRIORITY = 100;
    private static final AtomicInteger DEFAULT_SORT_COUNTER = new AtomicInteger(100);
    private int defaultSort = DEFAULT_SORT_COUNTER.getAndIncrement();

    public TicketField(String key) {
        this(key, null);
    }

    public TicketField(String key, VALUE defaultValue) {
        super(key, defaultValue);
    }

    public TicketField(SearchTag searchTag) {
        this(searchTag, null);
    }

    public TicketField(SearchTag searchTag, VALUE defaultValue) {
        super(searchTag, defaultValue);
    }

    public int getSortPrio() {
        return this.defaultSort;
    }

    @Nullable
    public StorageLocationInfo<VALUE> getStorageLocationInfo() {
        return null;
    }

    @Nonnull
    public abstract TicketVOSingle getValueSourceForSlaveTicketForEnduser(@Nonnull TicketVOSingle var1, @Nonnull TicketVOSingle var2);

    public OperationNewReaStep createStringFieldChangeReaStep(VALUE oldFieldValue, VALUE newFieldValue, OperationChangedTicket ticket) {
        MutableReaStepData data = new MutableReaStepData();
        data.put(ReaStepVO.FIELD_DESC, this.constructReaStepDescriptionForFieldChange(oldFieldValue, newFieldValue));
        data.put(ReaStepVO.FIELD_PROCESSING_TIME, ProcessingTime.of(ticket.getAttributeValue(Tickets.ATTRIBUTE_LAST_CHANGED)));
        return ticket.addReaStep(this.getFieldChangeReaStepActionId(), data, MutableReaStepText.empty());
    }

    protected String constructReaStepDescriptionForFieldChange(@Nullable VALUE oldFieldValue, @Nullable VALUE newFieldValue) {
        Object oldValue = oldFieldValue == null ? "" : this.valueToString(oldFieldValue);
        Object newValue = newFieldValue == null ? "" : this.valueToString(newFieldValue);
        Object prefix = this.getFieldChangeReaStepPrefix();
        prefix = prefix != null && !((String)prefix).isEmpty() ? (String)prefix + ": " : "";
        int max = (245 - ((String)prefix).length()) / 2;
        if (((String)oldValue).length() > max) {
            oldValue = ((String)oldValue).substring(0, max - 1) + "...";
        }
        if (((String)newValue).length() > max) {
            newValue = ((String)newValue).substring(0, max - 1) + "...";
        }
        return (String)prefix + (String)oldValue + " -> " + (String)newValue;
    }

    protected String getFieldChangeReaStepPrefix() {
        if (this.getFieldChangeReaStepActionId() == -29) {
            return this.getFieldDisplayName(Tickets.serverLocale());
        }
        return null;
    }

    protected int getFieldChangeReaStepActionId() {
        return -29;
    }

    public abstract String valueToString(@Nonnull VALUE var1);

    public String getFieldDisplayName(Locale locale) {
        return HDFieldDisplayNameProvider.getDisplayNameForCustomField(this, locale);
    }
}

