/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigValue;
import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.TicketIdDefList;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionAppointment;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionBundleImage;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionCategoryId;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionClassificationId;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionCustom1;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionCustom2;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionCustom3;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionCustom4;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionCustom5;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionCustom6;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionCustom7;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionDeadline;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionEscalation;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionIdentifier;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionInquiryDate;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionItilId;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionItilLinkCount;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionLastChanged;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionLastChangedById;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionLastEditorId;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionOwnerId;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionPriorityId;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionResourceId;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionResubmission;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionStatusId;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionSubject;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionSumTime;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTargetTime;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketId;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketOwnerComputerName;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketOwnerCostCentre;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketOwnerCustom1;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketOwnerCustom2;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketOwnerCustom3;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketOwnerCustom4;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketOwnerCustom5;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketOwnerCustom6;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketOwnerDepartment;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketOwnerFirstName;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketOwnerGroupId;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketOwnerLanguage;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketOwnerLastName;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketOwnerLocationId;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketOwnerLocationInfo;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketOwnerRoom;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketOwnerTelephone;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionWorkflowImage;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeAutoEscalated;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeBundleId;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeClosedDate;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeDispatchingReaStepId;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeEmailEingang;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeEscalationLight;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeEscalationTime;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeHasAttachments;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeIdDummy;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeInitialReaStepId;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeInquiryDate;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeItilCount;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeLastChanged;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeLastChangedByGuid;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeLastEditorGuid;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeStatusId;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeSumTime;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeWorkflowId;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeWorkflowStartDate;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldAnnotation;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldCategoryId;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldClassificationId;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldCustomField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldDeadline;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldIdentifier;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldItilId;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldOwnerGuid;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldPriorityId;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldResourceGuid;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldSubject;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldTargetTime;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldTerminVereinbarung;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldWiedervorlageDate;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.http.servlet.ClientLocale;
import com.inet.plugin.ServerPluginManager;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class Tickets {
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.core.ticketmanager.i18n.LanguageResources", Tickets.class);
    public static final String KEY_TICKET_ID = "ticketid";
    public static final TicketAttributeIdDummy ATTRIBUTE_TICKET_ID = new TicketAttributeIdDummy();
    public static final TicketAttributeInitialReaStepId ATTRIBUTE_INITIAL_REA_STEP_ID = new TicketAttributeInitialReaStepId();
    public static final TicketAttributeDispatchingReaStepId ATTRIBUTE_DISPATCHING_REA_STEP_ID = new TicketAttributeDispatchingReaStepId();
    public static final TicketAttributeStatusId ATTRIBUTE_STATUS_ID = new TicketAttributeStatusId();
    public static final TicketAttributeInquiryDate ATTRIBUTE_INQUIRY_DATE = new TicketAttributeInquiryDate();
    public static final String DEFAULT_TICKET_ID_STRING = "TicketID";
    public static final TicketAttributeLastEditorGuid ATTRIBUTE_LAST_EDITOR_GUID = new TicketAttributeLastEditorGuid();
    public static final TicketAttributeLastChanged ATTRIBUTE_LAST_CHANGED = new TicketAttributeLastChanged();
    public static final TicketAttributeEmailEingang ATTRIBUTE_EMAIL_EINGANG = new TicketAttributeEmailEingang();
    public static final TicketAttributeSumTime ATTRIBUTE_SUM_TIME = new TicketAttributeSumTime();
    public static final TicketAttributeBundleId ATTRIBUTE_BUNDLE_ID = new TicketAttributeBundleId();
    public static final TicketAttributeWorkflowId ATTRIBUTE_WORKFLOW_ID = new TicketAttributeWorkflowId();
    public static final TicketAttributeWorkflowStartDate ATTRIBUTE_WORKFLOW_START_DATE = new TicketAttributeWorkflowStartDate();
    public static final TicketAttributeHasAttachments ATTRIBUTE_ATTACHMENTS = new TicketAttributeHasAttachments();
    public static final TicketAttributeAutoEscalated ATTRIBUTE_AUTOESCALATED = new TicketAttributeAutoEscalated();
    public static final TicketAttributeLastChangedByGuid ATTRIBUTE_LAST_CHANGED_BY_GUID = new TicketAttributeLastChangedByGuid();
    public static final TicketAttributeClosedDate ATTRIBUTE_CLOSE_DATE = new TicketAttributeClosedDate();
    public static final TicketAttributeEscalationLight ATTRIBUTE_ESCALATION_LIGHT = new TicketAttributeEscalationLight();
    public static final TicketAttributeEscalationTime ATTRIBUTE_ESCALATION_TIME = new TicketAttributeEscalationTime();
    public static final TicketAttributeItilCount ATTRIBUTE_ITIL_COUNT = new TicketAttributeItilCount();
    public static final TicketFieldDeadline FIELD_DEADLINE = new TicketFieldDeadline();
    public static final TicketFieldResourceGuid FIELD_RESOURCE_GUID = new TicketFieldResourceGuid();
    public static final TicketFieldTargetTime FIELD_TARGET_TIME = new TicketFieldTargetTime();
    public static final TicketFieldItilId FIELD_ITIL_ID = new TicketFieldItilId();
    public static final TicketFieldClassificationId FIELD_CLASSIFICATION_ID = new TicketFieldClassificationId();
    public static final TicketFieldPriorityId FIELD_PRIORITY_ID = new TicketFieldPriorityId();
    public static final TicketFieldSubject FIELD_SUBJECT = new TicketFieldSubject();
    public static final TicketFieldAnnotation FIELD_ANNOTATION = new TicketFieldAnnotation();
    public static final TicketFieldIdentifier FIELD_IDENTIFIER = new TicketFieldIdentifier();
    public static final TicketFieldCategoryId FIELD_CATEGORY_ID = new TicketFieldCategoryId();
    public static final TicketFieldOwnerGuid FIELD_OWNER_GUID = new TicketFieldOwnerGuid();
    public static final TicketFieldWiedervorlageDate FIELD_WIEDERVORLAGEDATE = new TicketFieldWiedervorlageDate();
    public static final TicketFieldTerminVereinbarung FIELD_TERMINVEREINBARUNG = new TicketFieldTerminVereinbarung();
    public static final TicketFieldCustomField FIELD_CUSTOM_1 = TicketFieldCustomField.createFirst();
    public static final TicketFieldCustomField FIELD_CUSTOM_2 = TicketFieldCustomField.createSecond();
    public static final TicketFieldCustomField FIELD_CUSTOM_3 = TicketFieldCustomField.createThird();
    public static final TicketFieldCustomField FIELD_CUSTOM_4 = TicketFieldCustomField.createFourth();
    public static final TicketFieldCustomField FIELD_CUSTOM_5 = TicketFieldCustomField.createFifth();
    public static final TicketFieldCustomField FIELD_CUSTOM_6 = TicketFieldCustomField.createSixth();
    public static final TicketFieldCustomField FIELD_CUSTOM_7 = TicketFieldCustomField.createSeventh();
    public static final String KEY_TICKETDETAILS = "ticketdetails";
    public static final String KEY_READETAILS = "reastepdetails";
    private static final ConfigValue<TicketIdDefList> TICKET_ID_DEF_LIST = new ConfigValue(HDConfigKeys.TICKET_ID_DEF_LIST);
    private static final ConfigValue<String> TICKET_ID_PREFIX = new ConfigValue(HDConfigKeys.TICKET_ID_PREFIX);
    private static final ConfigValue<String> TICKET_ID_SUFFIX = new ConfigValue(HDConfigKeys.TICKET_ID_SUFFIX);
    private static final ConfigValue<String> TICKET_ID_UID = new ConfigValue(HDConfigKeys.TICKET_ID_SERVER_UID);
    private static final ConfigValue<List<String>> CLIENT_ENDUSER_VISIBLE_TICKET_FIELDS = new ConfigValue(HDConfigKeys.CLIENT_ENDUSER_VISIBLE_TICKET_FIELDS);

    @Nonnull
    public static List<TicketAttribute<?>> getAttributesForRegistration() {
        ArrayList attributes = new ArrayList();
        attributes.add(ATTRIBUTE_STATUS_ID);
        attributes.add(ATTRIBUTE_INITIAL_REA_STEP_ID);
        attributes.add(ATTRIBUTE_DISPATCHING_REA_STEP_ID);
        attributes.add(ATTRIBUTE_INQUIRY_DATE);
        attributes.add(ATTRIBUTE_LAST_EDITOR_GUID);
        attributes.add(ATTRIBUTE_LAST_CHANGED);
        attributes.add(ATTRIBUTE_EMAIL_EINGANG);
        attributes.add(ATTRIBUTE_SUM_TIME);
        attributes.add(ATTRIBUTE_BUNDLE_ID);
        attributes.add(ATTRIBUTE_WORKFLOW_ID);
        attributes.add(ATTRIBUTE_WORKFLOW_START_DATE);
        attributes.add(ATTRIBUTE_ATTACHMENTS);
        attributes.add(ATTRIBUTE_LAST_CHANGED_BY_GUID);
        attributes.add(ATTRIBUTE_AUTOESCALATED);
        attributes.add(ATTRIBUTE_CLOSE_DATE);
        attributes.add(ATTRIBUTE_ESCALATION_LIGHT);
        attributes.add(ATTRIBUTE_ESCALATION_TIME);
        attributes.add(ATTRIBUTE_ITIL_COUNT);
        return attributes;
    }

    @Nonnull
    public static List<TicketField<?>> getFieldsForRegistration() {
        return Tickets.getFieldsWithValuesInTblAufOrTblBun();
    }

    @Nonnull
    public static List<TicketField<?>> getFieldsWithValuesInTblAufOrTblBun() {
        ArrayList fields = new ArrayList();
        fields.add(FIELD_DEADLINE);
        fields.add(FIELD_RESOURCE_GUID);
        fields.add(FIELD_TARGET_TIME);
        fields.add(FIELD_ITIL_ID);
        fields.add(FIELD_CLASSIFICATION_ID);
        fields.add(FIELD_PRIORITY_ID);
        fields.add(FIELD_SUBJECT);
        fields.add(FIELD_IDENTIFIER);
        fields.add(FIELD_CATEGORY_ID);
        fields.add(FIELD_OWNER_GUID);
        fields.add(FIELD_WIEDERVORLAGEDATE);
        fields.add(FIELD_TERMINVEREINBARUNG);
        fields.add(FIELD_CUSTOM_1);
        fields.add(FIELD_CUSTOM_2);
        fields.add(FIELD_CUSTOM_3);
        fields.add(FIELD_CUSTOM_4);
        fields.add(FIELD_CUSTOM_5);
        fields.add(FIELD_CUSTOM_6);
        fields.add(FIELD_CUSTOM_7);
        fields.add(FIELD_ANNOTATION);
        return fields;
    }

    @Nonnull
    public static List<TicketFieldDefinition> getFieldDefinitionsForRegistration() {
        ArrayList<TicketFieldDefinition> fieldDefinitions = new ArrayList<TicketFieldDefinition>();
        fieldDefinitions.add(new TicketFieldDefinitionTicketId());
        fieldDefinitions.add(new TicketFieldDefinitionStatusId());
        fieldDefinitions.add(new TicketFieldDefinitionInquiryDate());
        fieldDefinitions.add(new TicketFieldDefinitionLastChanged());
        fieldDefinitions.add(new TicketFieldDefinitionSumTime());
        fieldDefinitions.add(new TicketFieldDefinitionCategoryId());
        fieldDefinitions.add(new TicketFieldDefinitionClassificationId());
        fieldDefinitions.add(new TicketFieldDefinitionCustom1());
        fieldDefinitions.add(new TicketFieldDefinitionCustom2());
        fieldDefinitions.add(new TicketFieldDefinitionCustom3());
        fieldDefinitions.add(new TicketFieldDefinitionCustom4());
        fieldDefinitions.add(new TicketFieldDefinitionCustom5());
        fieldDefinitions.add(new TicketFieldDefinitionCustom6());
        fieldDefinitions.add(new TicketFieldDefinitionCustom7());
        fieldDefinitions.add(new TicketFieldDefinitionDeadline());
        fieldDefinitions.add(new TicketFieldDefinitionEscalation());
        fieldDefinitions.add(new TicketFieldDefinitionIdentifier());
        fieldDefinitions.add(new TicketFieldDefinitionItilId());
        fieldDefinitions.add(new TicketFieldDefinitionOwnerId());
        fieldDefinitions.add(new TicketFieldDefinitionLastEditorId());
        fieldDefinitions.add(new TicketFieldDefinitionLastChangedById());
        fieldDefinitions.add(new TicketFieldDefinitionPriorityId());
        fieldDefinitions.add(new TicketFieldDefinitionResourceId());
        fieldDefinitions.add(new TicketFieldDefinitionSubject());
        fieldDefinitions.add(new TicketFieldDefinitionTargetTime());
        fieldDefinitions.add(new TicketFieldDefinitionResubmission());
        fieldDefinitions.add(new TicketFieldDefinitionAppointment());
        fieldDefinitions.add(new TicketFieldDefinitionBundleImage());
        fieldDefinitions.add(new TicketFieldDefinitionWorkflowImage());
        fieldDefinitions.add(new TicketFieldDefinitionItilLinkCount());
        fieldDefinitions.add(new TicketFieldDefinitionTicketOwnerLastName());
        fieldDefinitions.add(new TicketFieldDefinitionTicketOwnerFirstName());
        fieldDefinitions.add(new TicketFieldDefinitionTicketOwnerGroupId());
        fieldDefinitions.add(new TicketFieldDefinitionTicketOwnerTelephone());
        fieldDefinitions.add(new TicketFieldDefinitionTicketOwnerLocationId());
        fieldDefinitions.add(new TicketFieldDefinitionTicketOwnerDepartment());
        fieldDefinitions.add(new TicketFieldDefinitionTicketOwnerCostCentre());
        fieldDefinitions.add(new TicketFieldDefinitionTicketOwnerRoom());
        fieldDefinitions.add(new TicketFieldDefinitionTicketOwnerLanguage());
        fieldDefinitions.add(new TicketFieldDefinitionTicketOwnerCustom1());
        fieldDefinitions.add(new TicketFieldDefinitionTicketOwnerCustom2());
        fieldDefinitions.add(new TicketFieldDefinitionTicketOwnerCustom3());
        fieldDefinitions.add(new TicketFieldDefinitionTicketOwnerCustom4());
        fieldDefinitions.add(new TicketFieldDefinitionTicketOwnerCustom5());
        fieldDefinitions.add(new TicketFieldDefinitionTicketOwnerCustom6());
        fieldDefinitions.add(new TicketFieldDefinitionTicketOwnerComputerName());
        fieldDefinitions.add(new TicketFieldDefinitionTicketOwnerLocationInfo());
        return fieldDefinitions;
    }

    public static String getFieldDisplayName(String fieldKey) {
        return Tickets.getFieldDisplayName(fieldKey, ClientLocale.getThreadLocale());
    }

    public static String getFieldDisplayName(String fieldKey, Locale locale) {
        String msgKey = "field." + fieldKey;
        return MSG.getMsg(locale, msgKey, new Object[0]);
    }

    public static String getTicketIDForEmailSubject(int ticketID) {
        TicketIdDefList idList = (TicketIdDefList)TICKET_ID_DEF_LIST.get();
        String ticketIdDef = idList.size() == 0 ? DEFAULT_TICKET_ID_STRING : (String)idList.get(0);
        String ticketIDstr = Tickets.normaliseTicketIdString(ticketIdDef);
        return (String)TICKET_ID_PREFIX.get() + ticketIDstr + " " + Tickets.encodeTicketId(ticketID) + (String)TICKET_ID_SUFFIX.get() + (String)TICKET_ID_UID.get();
    }

    public static String encodeTicketId(int ticketID) {
        byte[] values = String.valueOf(ticketID).getBytes(StandardCharsets.UTF_8);
        byte[] key = Arrays.copyOf(values, values.length * 2);
        for (int i = 0; i < values.length; ++i) {
            if (i == 0) {
                key[values.length] = (byte)(values[i] + 26);
                continue;
            }
            key[values.length + i] = (byte)(values[i - 1] - values[i] + 74);
        }
        return new String(key);
    }

    public static int decodeTicketID(@Nullable String str, boolean requiresChecksum) {
        Function<String, Integer> simpleNumberReturn = string -> -1;
        if (!requiresChecksum) {
            simpleNumberReturn = string -> Tickets.parseIntWithThousandsDelimiter(string);
        }
        if (str == null) {
            return -1;
        }
        int length = str.length();
        if (length < 1) {
            return -1;
        }
        char ch0 = str.charAt(0);
        if (ch0 < '1' || ch0 > '9') {
            return -1;
        }
        int startkey = length;
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            startkey = i;
            break;
        }
        if (startkey == length) {
            return requiresChecksum ? -1 : Integer.parseInt(str);
        }
        if (startkey * 2 != length) {
            return simpleNumberReturn.apply(str);
        }
        for (int i = 0; i < startkey; ++i) {
            char ch1 = str.charAt(i);
            char chKey = Character.toUpperCase(str.charAt(i + startkey));
            if (i == 0) {
                if (ch0 + 26 == chKey) continue;
                return simpleNumberReturn.apply(str);
            }
            if (ch0 - ch1 + 74 != chKey) {
                return simpleNumberReturn.apply(str);
            }
            ch0 = ch1;
        }
        return Integer.parseInt(str.substring(0, startkey));
    }

    private static int parseIntWithThousandsDelimiter(String str) {
        ParsePosition pos = new ParsePosition(0);
        Number val = NumberFormat.getIntegerInstance(ClientLocale.getThreadLocale()).parse(str, pos);
        if (pos.getIndex() == str.length()) {
            return val.intValue();
        }
        return -1;
    }

    public static String normaliseTicketIdString(String input) {
        StringBuffer result = new StringBuffer();
        for (int x = 0; x < input.length(); ++x) {
            if (input.charAt(x) != '\u00a0' && input.charAt(x) != '_' && input.charAt(x) > ' ') {
                result.append(input.charAt(x));
                continue;
            }
            result.append('-');
        }
        return result.toString();
    }

    public static List<TicketFieldDefinition> getFieldsVisibleForEnduser() {
        List fromJson = (List)CLIENT_ENDUSER_VISIBLE_TICKET_FIELDS.get();
        List allTicketDefs = ServerPluginManager.getInstance().get(TicketFieldDefinition.class);
        List<TicketFieldDefinition> fields = fromJson.stream().map(str -> {
            Optional<TicketFieldDefinition> def = allTicketDefs.stream().filter(tdef -> tdef.getKey().equals(str)).findFirst();
            return def.orElse(null);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return fields;
    }

    public static List<String> getFieldIdsVisibleForEnduser() {
        return Collections.unmodifiableList((List)CLIENT_ENDUSER_VISIBLE_TICKET_FIELDS.get());
    }

    public static Locale serverLocale() {
        return new Locale(ConfigurationManager.getInstance().getCurrent().get("vm.user.language", Locale.getDefault().getLanguage()));
    }

    public static <T> TicketField<T> getFieldByKey(String key) {
        for (TicketField f : ServerPluginManager.getInstance().get(TicketField.class)) {
            if (!f.getKey().equals(key)) continue;
            return f;
        }
        return null;
    }

    public static <T> TicketAttribute<T> getAttributeByKey(String key) {
        for (TicketAttribute f : ServerPluginManager.getInstance().get(TicketAttribute.class)) {
            if (!f.getKey().equals(key)) continue;
            return f;
        }
        return null;
    }
}

