/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model;

import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.usersandgroups.api.user.UserManager;

public class TicketPermissionContext {
    private static final TicketPermissionContext ARTIFICAL_SUPPORTER = new TicketPermissionContext(false, SupporterPermission.READWRITE);
    private static final TicketPermissionContext ARTIFICAL_DISPATCHER = new TicketPermissionContext(false, SupporterPermission.NONE, true, true);
    private static final TicketPermissionContext ARTIFICAL_TICKET_OWNER = new TicketPermissionContext(true, SupporterPermission.NONE, false, false);
    private boolean ticketOwner;
    private boolean isInquiry = false;
    private boolean isDispatcher;
    private SupporterPermission supporterPermissions;

    public TicketPermissionContext(boolean ticketOwner, SupporterPermission supporterPermissions) {
        this(ticketOwner, supporterPermissions, false);
    }

    public TicketPermissionContext(boolean ticketOwner, SupporterPermission supporterPermissions, boolean isInquiry) {
        this(ticketOwner, supporterPermissions, isInquiry, HDUsersAndGroups.isDispatcher(UserManager.getInstance().getCurrentUserAccount()));
    }

    public TicketPermissionContext(boolean ticketOwner, SupporterPermission supporterPermissions, boolean isInquiry, boolean isDispatcher) {
        if (isInquiry && supporterPermissions != SupporterPermission.NONE) {
            throw new IllegalArgumentException("If a ticket is inquiry, noone can have supporter-access (bearbeitung) to a ticket!");
        }
        this.ticketOwner = ticketOwner;
        this.supporterPermissions = supporterPermissions;
        this.isInquiry = isInquiry;
        this.isDispatcher = isDispatcher;
    }

    public boolean isTicketOwner() {
        return this.ticketOwner;
    }

    public boolean isDispatcher() {
        return this.isDispatcher;
    }

    public SupporterPermission getSupporterPermissions() {
        return this.supporterPermissions;
    }

    public boolean hasAnyAccessToTicket() {
        return this.isTicketOwner() || this.hasSupporterAccessToTicket() || this.hasDispatcherAccessToTicket();
    }

    public boolean hasEnduserAccessToTicket() {
        return this.isTicketOwner() && !this.hasSupporterAccessToTicket() && !this.hasDispatcherAccessToTicket();
    }

    public boolean hasSupporterAccessToTicket() {
        return this.getSupporterPermissions() != SupporterPermission.NONE;
    }

    public boolean hasDispatcherAccessToTicket() {
        return this.isInquiry && this.isDispatcher();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isDispatcher ? 1231 : 1237);
        result = 31 * result + (this.isInquiry ? 1231 : 1237);
        result = 31 * result + (this.supporterPermissions == null ? 0 : this.supporterPermissions.hashCode());
        result = 31 * result + (this.ticketOwner ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TicketPermissionContext other = (TicketPermissionContext)obj;
        if (this.isDispatcher != other.isDispatcher) {
            return false;
        }
        if (this.isInquiry != other.isInquiry) {
            return false;
        }
        if (this.supporterPermissions != other.supporterPermissions) {
            return false;
        }
        return this.ticketOwner == other.ticketOwner;
    }

    public static TicketPermissionContext artificialFullAccess(boolean ticketIsInquiry) {
        return ticketIsInquiry ? TicketPermissionContext.artificialDispatcherForInquiry() : TicketPermissionContext.artificialSupporterForDispatchedTicket();
    }

    public static TicketPermissionContext artificialSupporterForDispatchedTicket() {
        return ARTIFICAL_SUPPORTER;
    }

    public static TicketPermissionContext artificialDispatcherForInquiry() {
        return ARTIFICAL_DISPATCHER;
    }

    public static TicketPermissionContext artificialTicketOwner() {
        return ARTIFICAL_TICKET_OWNER;
    }

    public static enum SupporterPermission {
        NONE,
        READ,
        READWRITE;

    }
}

