/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fields.usergroup;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.GenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserGroupVO;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class UserGroupVOManager
extends GenericFieldsManager<UserGroupVO> {
    private static final String LIST_SUPERVISORS = "SELECT UsrID, BgrID, ImpName FROM tblBGSuperUser";
    private static final String REMOVE_SUPERVISOR_FROM_LIST = "DELETE FROM tblBGSuperUser WHERE UsrID = ? AND BgrID = ?";
    private static final String UPDATE_SUPERVISOR_SOURCE = "UPDATE tblBGSuperUser SET ImpName = ? WHERE UsrID = ? AND BgrID = ?";
    private static final String INSERT_SUPERVISOR = "INSERT INTO tblBGSuperUser(UsrID,BgrID,ImpName) VALUES(?, ?, ?)";
    private static final UserGroupVOManager manager = new UserGroupVOManager();
    private Map<Integer, List<SupervisorMemberShip>> supervisorToGroup = new HashMap<Integer, List<SupervisorMemberShip>>();

    UserGroupVOManager() {
        super(UserGroupVO.class, "tblBenutzerGruppe");
    }

    public static UserGroupVOManager getInstance() {
        return manager;
    }

    @Override
    protected void addDefaultData(Map<Integer, UserGroupVO> map) {
        super.addDefaultData(map);
        HashMap<Integer, List<SupervisorMemberShip>> newSupervisorToGroup = new HashMap<Integer, List<SupervisorMemberShip>>();
        ConnectionFactory factory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        try (Connection con = factory.getConnection();
             Statement stm = con.createStatement();
             ResultSet rs = stm.executeQuery(LIST_SUPERVISORS);){
            while (rs.next()) {
                int userID = rs.getInt(1);
                int groupID = rs.getInt(2);
                String importName = rs.getString(3);
                ArrayList<SupervisorMemberShip> groups = (ArrayList<SupervisorMemberShip>)newSupervisorToGroup.get(userID);
                if (groups == null) {
                    groups = new ArrayList<SupervisorMemberShip>();
                    newSupervisorToGroup.put(userID, groups);
                }
                groups.add(new SupervisorMemberShip(userID, groupID, importName));
            }
        }
        catch (SQLException e1) {
            throw new IllegalStateException(e1);
        }
        this.supervisorToGroup = newSupervisorToGroup;
    }

    @Nonnull
    public List<UserGroupVO> getGroupsWhereUserIsSupervisor(GUID userID) {
        return this.getGroupsWhereUserIsSupervisor(HDUsersAndGroups.getUserID(userID));
    }

    @Nonnull
    public List<UserGroupVO> getGroupsWhereUserIsSupervisor(int userID) {
        this.checkInitialization();
        List<SupervisorMemberShip> groupMemberShips = this.supervisorToGroup.get(userID);
        if (groupMemberShips == null) {
            return new ArrayList<UserGroupVO>(0);
        }
        return groupMemberShips.stream().map(gms -> (UserGroupVO)this.get(gms.getGroupID())).filter(g -> g != null && !g.isDeleted()).collect(Collectors.toList());
    }

    @Override
    public URL getIcon(int id, int size) {
        UserGroupVO userGroup = (UserGroupVO)this.get(id);
        if (userGroup == null || userGroup.isDeleted()) {
            return this.resolveImageURL("delete_16.gif", size);
        }
        return this.resolveImageURL("benutzergr_16.gif", size);
    }

    public List<SupervisorMemberShip> getAllSupervisorMemberShips() {
        ArrayList<SupervisorMemberShip> supervisorGroupMemberShips = new ArrayList<SupervisorMemberShip>();
        for (Map.Entry<Integer, List<SupervisorMemberShip>> userMemberShips : this.supervisorToGroup.entrySet()) {
            supervisorGroupMemberShips.addAll((Collection<SupervisorMemberShip>)userMemberShips.getValue());
        }
        return supervisorGroupMemberShips;
    }

    public void addOrUpdateSupervisorMemberShip(int userID, int groupID, String source) {
        List<SupervisorMemberShip> userSupervisorMemberShips = this.supervisorToGroup.get(userID);
        if (userSupervisorMemberShips == null) {
            userSupervisorMemberShips = new ArrayList<SupervisorMemberShip>();
            this.supervisorToGroup.put(userID, userSupervisorMemberShips);
        }
        for (SupervisorMemberShip sms : userSupervisorMemberShips) {
            if (sms.getGroupID() != groupID || sms.getUserID() != userID) continue;
            if (!UserGroupVOManager.empty(source) && source.equals(sms.getSource()) || UserGroupVOManager.empty(source) && UserGroupVOManager.empty(sms.getSource())) {
                HDLogger.warn("Supervisor Mebership already defined " + userID + " from group " + groupID + " source " + source);
            } else {
                ConnectionFactory factory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
                try (Connection con = factory.getConnection();
                     PreparedStatement pst = con.prepareStatement(UPDATE_SUPERVISOR_SOURCE);){
                    pst.setString(1, source);
                    pst.setInt(2, userID);
                    pst.setInt(3, groupID);
                    pst.execute();
                    sms.source = source;
                }
                catch (SQLException e1) {
                    throw new IllegalStateException(e1);
                }
            }
            return;
        }
        ConnectionFactory factory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        try (Connection con = factory.getConnection();
             PreparedStatement pst = con.prepareStatement(INSERT_SUPERVISOR);){
            pst.setInt(1, userID);
            pst.setInt(2, groupID);
            pst.setString(3, source);
            pst.execute();
            userSupervisorMemberShips.add(new SupervisorMemberShip(userID, groupID, source));
        }
        catch (SQLException e1) {
            throw new IllegalStateException(e1);
        }
    }

    public void removeSupervisorMemberShip(int userID, int groupID) {
        List<SupervisorMemberShip> userSupervisorMemberShips = this.supervisorToGroup.get(userID);
        if (userSupervisorMemberShips != null) {
            for (SupervisorMemberShip sms : userSupervisorMemberShips) {
                if (sms.getGroupID() != groupID) continue;
                ConnectionFactory factory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
                try (Connection con = factory.getConnection();
                     PreparedStatement pst = con.prepareStatement(REMOVE_SUPERVISOR_FROM_LIST);){
                    pst.setInt(1, userID);
                    pst.setInt(2, groupID);
                    pst.execute();
                    userSupervisorMemberShips.remove(sms);
                }
                catch (SQLException e1) {
                    throw new IllegalStateException(e1);
                }
                return;
            }
        }
        HDLogger.error("Could not remove Supervisor " + userID + " from group " + groupID);
    }

    private static boolean empty(String value) {
        return value == null || value.length() == 0;
    }

    public class SupervisorMemberShip {
        private int userID;
        private int groupID;
        private String source;

        private SupervisorMemberShip(int userID, int groupID, String source) {
            this.userID = userID;
            this.groupID = groupID;
            this.source = source;
        }

        public int getUserID() {
            return this.userID;
        }

        public int getGroupID() {
            return this.groupID;
        }

        public String getSource() {
            return this.source;
        }
    }
}

