/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fields;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.Deletable;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.utils.TicketValuesImageResolver;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.image.ImageScaler;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

public abstract class GenericFieldsManager<T extends FieldVO> {
    private Class<T> modelClass;
    private Map<Integer, T> cacheMap;
    private ConnectionFactory factory;
    private String tableName;
    private String idColumnName;
    private boolean isAutoID;
    private List<Field> modelFields = new ArrayList<Field>();
    private boolean initialized = false;
    private final Object cacheMonitor = new Object();
    private List<DataChangeListener> listeners = new ArrayList<DataChangeListener>();
    private boolean reloading = false;

    public GenericFieldsManager(Class<T> modelClass, String tableName) {
        this.modelClass = modelClass;
        if (modelClass.getAnnotation(JsonData.class) == null) {
            throw new IllegalArgumentException("The model class " + modelClass + " must be annotated as JsonData");
        }
        this.tableName = tableName;
        this.cacheMap = new HashMap<Integer, T>();
    }

    /*
     * Exception decompiling
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="does not take user input")
    private void updateCacheValues() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private T createModelInstance() throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<T> c0 = this.modelClass.getDeclaredConstructor(new Class[0]);
        c0.setAccessible(true);
        FieldVO instance = (FieldVO)c0.newInstance(new Object[0]);
        return (T)instance;
    }

    protected void setDataFromResult(ResultSet rs, T instance) throws SQLException, IllegalAccessException {
        ((FieldVO)instance).setId(rs.getInt(1));
        for (int i = 0; i < this.modelFields.size(); ++i) {
            int columnIndex = i + 2;
            Object value = rs.getObject(columnIndex);
            Field field = this.modelFields.get(i);
            Class<?> fieldType = field.getType();
            if ((Number.class.isAssignableFrom(fieldType) || Double.TYPE.isAssignableFrom(fieldType)) && value instanceof BigDecimal && !BigDecimal.class.isAssignableFrom(fieldType)) {
                BigDecimal bigValue = (BigDecimal)value;
                field.set(instance, bigValue.doubleValue());
                continue;
            }
            if (value == null) {
                if (Double.TYPE.isAssignableFrom(fieldType)) {
                    field.set(instance, 0.0);
                    continue;
                }
                if (Long.TYPE.isAssignableFrom(fieldType)) {
                    field.set(instance, 0L);
                    continue;
                }
                if (Integer.TYPE.isAssignableFrom(fieldType)) {
                    field.set(instance, 0);
                    continue;
                }
                if (Boolean.TYPE.isAssignableFrom(fieldType)) {
                    field.set(instance, Boolean.FALSE);
                    continue;
                }
                this.updateModelValueFromResultSet(instance, rs, columnIndex, field);
                continue;
            }
            if (value instanceof Number) {
                Number number = (Number)value;
                if (Double.TYPE.isAssignableFrom(fieldType)) {
                    field.set(instance, number.doubleValue());
                    continue;
                }
                if (Long.TYPE.isAssignableFrom(fieldType)) {
                    field.set(instance, number.longValue());
                    continue;
                }
                if (Integer.TYPE.isAssignableFrom(fieldType)) {
                    field.set(instance, number.intValue());
                    continue;
                }
                if (fieldType == Boolean.TYPE) {
                    field.set(instance, number.longValue() != 0L);
                    continue;
                }
                if (value.getClass() != fieldType) {
                    if (Integer.class.isAssignableFrom(fieldType)) {
                        field.set(instance, number.intValue());
                        continue;
                    }
                    if (Long.class.isAssignableFrom(fieldType)) {
                        field.set(instance, number.longValue());
                        continue;
                    }
                    if (Double.class.isAssignableFrom(fieldType)) {
                        field.set(instance, number.doubleValue());
                        continue;
                    }
                    if (Float.class.isAssignableFrom(fieldType)) {
                        field.set(instance, Float.valueOf(number.longValue()));
                        continue;
                    }
                    this.updateModelValueFromResultSet(instance, rs, columnIndex, field);
                    continue;
                }
                this.updateModelValueFromResultSet(instance, rs, columnIndex, field);
                continue;
            }
            this.updateModelValueFromResultSet(instance, rs, columnIndex, field);
        }
    }

    protected void updateModelValueFromResultSet(T vo, ResultSet rs, int columnIndex, Field field) throws IllegalAccessException, SQLException {
        Object value = rs.getObject(columnIndex);
        field.set(vo, value);
    }

    private String getJoinedFieldNames() {
        String fieldList = this.modelFields.stream().map(f -> f.getName()).collect(Collectors.joining(", "));
        return this.idColumnName + ", " + fieldList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int id) {
        this.checkInitialization();
        Object object = this.cacheMonitor;
        synchronized (object) {
            return (T)((FieldVO)this.cacheMap.get(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="does not take user input")
    protected void checkInitialization() {
        if (this.initialized) {
            return;
        }
        Object object = this.cacheMonitor;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            this.factory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
            Map fieldMap = Arrays.stream(this.modelClass.getDeclaredFields()).filter(f -> !Modifier.isTransient(f.getModifiers()) && !Modifier.isFinal(f.getModifiers()) && !Modifier.isStatic(f.getModifiers())).collect(Collectors.toMap(f -> {
                f.setAccessible(true);
                return f.getName().toLowerCase();
            }, Function.identity()));
            try (Connection con = this.factory.getConnection();
                 Statement stm = con.createStatement();
                 ResultSet rs = stm.executeQuery("SELECT * FROM " + this.tableName);){
                ResultSetMetaData meta = rs.getMetaData();
                ArrayList<String> missingColumns = new ArrayList<String>();
                for (int i = 1; i <= meta.getColumnCount(); ++i) {
                    String name = meta.getColumnName(i).toLowerCase();
                    Field field = (Field)fieldMap.remove(name);
                    if (field != null) {
                        this.modelFields.add(field);
                        continue;
                    }
                    if (i == 1) {
                        this.isAutoID = meta.isAutoIncrement(i);
                        this.idColumnName = meta.getColumnName(i);
                        continue;
                    }
                    missingColumns.add(name);
                }
                if (missingColumns.size() > 0) {
                    LogManager.getApplicationLogger().warn((Object)("Missing model fields for database columns: " + missingColumns + " of table '" + this.tableName + "'. This may have no visible effect if there are defaults defined for these columns in the database"));
                }
                if (fieldMap.size() > 0) {
                    throw new IllegalStateException("Missing database columns for model fields: " + Arrays.toString(fieldMap.keySet().toArray()) + " in database table '" + this.tableName + "'");
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot create cache instance for table '" + this.tableName + "'", e);
            }
            this.updateCacheValues();
            this.addDefaultData(this.cacheMap);
            this.initialized = true;
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void reloadFromDatabase() {
        if (this.reloading) {
            return;
        }
        Object object = this.cacheMonitor;
        synchronized (object) {
            this.reloading = true;
            try {
                this.checkInitialization();
                this.updateCacheValues();
                this.addDefaultData(this.cacheMap);
                this.initialized = true;
                this.notifyListeners();
            }
            finally {
                this.reloading = false;
            }
        }
    }

    protected void addDefaultData(Map<Integer, T> map) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getAll(boolean validOnly) {
        List<T> result;
        try {
            this.checkInitialization();
        }
        catch (IllegalStateException exc) {
            HDLogger.error("initialization of fields manager " + this.modelClass + " failed");
            HDLogger.error(exc);
            return new ArrayList();
        }
        Object object = this.cacheMonitor;
        synchronized (object) {
            result = new ArrayList<T>(this.cacheMap.values());
        }
        if (validOnly) {
            result = result.stream().filter(e -> !(e instanceof Deletable) || !((Deletable)((Object)e)).isDeleted()).collect(Collectors.toList());
        }
        return result;
    }

    public int add(T vo) throws SQLException {
        this.addOrUpdate(vo, false, false);
        return ((FieldVO)vo).getId();
    }

    public int addPredefined(T vo) throws SQLException {
        this.addOrUpdate(vo, false, true);
        return ((FieldVO)vo).getId();
    }

    public void update(T vo) throws SQLException {
        this.addOrUpdate(vo, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="does not take user input")
    private void addOrUpdate(T vo, boolean update, boolean addIdentity) throws SQLException {
        if (vo == null) {
            throw new IllegalArgumentException("Cannot update a null-Object");
        }
        this.checkInitialization();
        Object object = this.cacheMonitor;
        synchronized (object) {
            Integer idObject = ((FieldVO)vo).getId();
            FieldVO current = (FieldVO)this.cacheMap.get(idObject);
            if (update && current == null) {
                throw new IllegalArgumentException("Cannot update entry ID " + ((FieldVO)vo).getId() + " since there is no such entry in the database");
            }
            if (!update && current != null) {
                throw new IllegalArgumentException("Cannot add ID=" + ((FieldVO)vo).getId() + " since there already is such entry, call update() to update the dataset");
            }
            if (current != null && ((FieldVO)vo).equals(current)) {
                return;
            }
            StringBuilder insert = new StringBuilder("SELECT ");
            insert.append(this.getJoinedFieldNames());
            insert.append(" FROM ");
            insert.append(this.tableName);
            insert.append(" WHERE ");
            insert.append(this.idColumnName);
            insert.append("=");
            insert.append(((FieldVO)vo).getId());
            String query = insert.toString();
            try (Connection con = this.factory.getConnection();
                 Statement stm = con.createStatement(1005, 1008);
                 ResultSet rs = stm.executeQuery(query);){
                if (!rs.next()) {
                    if (update) {
                        throw new IllegalArgumentException("There is no dataset for ID=" + ((FieldVO)vo).getId() + " to be updated");
                    }
                    rs.moveToInsertRow();
                    current = this.createModelInstance();
                } else if (!update) {
                    throw new IllegalArgumentException("Cannot add ID=" + ((FieldVO)vo).getId() + " since there already is such entry, call update() to update the dataset");
                }
                if (!this.isAutoID || addIdentity) {
                    rs.updateObject(1, (Object)((FieldVO)vo).getId());
                }
                for (int i = 0; i < this.modelFields.size(); ++i) {
                    this.updateResultSetValueFromModelValue(vo, this.modelFields.get(i), rs, i + 2);
                }
                this.beforeUpdateOrInsertRow(rs, vo, con, update);
                if (update) {
                    rs.updateRow();
                } else {
                    rs.insertRow();
                    rs.last();
                }
                if (addIdentity && rs.getInt(1) != ((FieldVO)vo).getId()) {
                    rs.updateObject(1, (Object)((FieldVO)vo).getId());
                    rs.updateRow();
                }
                this.setDataFromResult(rs, current);
                if (!update) {
                    this.cacheMap.put(current.getId(), current);
                }
                this.setDataFromResult(rs, vo);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException("Unable to store field value to database", e);
            }
        }
        this.notifyListeners();
    }

    protected void updateResultSetValueFromModelValue(T vo, Field field, ResultSet rs, int columnIndex) throws IllegalAccessException, SQLException {
        rs.updateObject(columnIndex, field.get(vo));
    }

    protected void beforeUpdateOrInsertRow(ResultSet mainResultSet, T vo, Connection con, boolean update) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="does not take user input")
    public T remove(int id) throws SQLException {
        FieldVO result;
        this.checkInitialization();
        Object object = this.cacheMonitor;
        synchronized (object) {
            try (Connection con = this.factory.getConnection();
                 Statement stm = con.createStatement();){
                stm.execute("DELETE FROM " + this.tableName + " WHERE " + this.idColumnName + "=" + id);
            }
            result = (FieldVO)this.cacheMap.remove(id);
        }
        this.notifyListeners();
        return (T)result;
    }

    public void addDataChangeListener(@Nonnull DataChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeDataChangeListener(@Nonnull DataChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        this.listeners.forEach(l -> {
            try {
                l.cacheUpdated();
            }
            catch (Throwable th) {
                LogManager.getApplicationLogger().error((Object)th);
            }
        });
    }

    public abstract URL getIcon(int var1, int var2);

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Further up, we already make sure the relativePath is relative and contains no traversals.")
    protected URL resolveImageURL(String relativePath, int size) {
        URL urlToServe;
        block20: {
            URL uRL;
            block21: {
                PersistenceEntry file;
                if (StringFunctions.isEmpty((String)relativePath)) {
                    return null;
                }
                urlToServe = null;
                urlToServe = TicketValuesImageResolver.getInstance().resolveDataImage(relativePath, size);
                if (urlToServe != null) break block20;
                try {
                    file = AppDataLocation.getImageDirectory().resolve(relativePath + "/" + size + ".png");
                    if (!file.exists()) {
                        file = AppDataLocation.getClientImageDirectory().resolve(relativePath);
                    }
                    if (!file.exists()) {
                        file = AppDataLocation.getBaseLocation().resolve(relativePath);
                    }
                }
                catch (Exception exc) {
                    file = null;
                }
                if (file != null && file.exists()) {
                    urlToServe = file.toURL();
                } else {
                    String resPath = "com/inet/helpdesk/images/" + relativePath;
                    urlToServe = this.getClass().getClassLoader().getResource(resPath);
                    if (urlToServe != null && urlToServe.toString().endsWith("/")) {
                        urlToServe = null;
                    }
                    if (urlToServe == null) {
                        urlToServe = new URL(relativePath);
                    }
                }
                if (size == 16) break block20;
                InputStream inputStream = urlToServe.openStream();
                try {
                    ImageScaler.ImageScalerResult result = ImageScaler.scale((InputStream)inputStream, (int)size);
                    uRL = new URL("data:image/png;base64," + Base64.getEncoder().encodeToString(result.getImageData()) + (result.isScaled() ? "#scaled" : ""));
                    if (inputStream == null) break block21;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable t) {
                            HDLogger.error(t);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                inputStream.close();
            }
            return uRL;
        }
        return urlToServe;
    }

    public Map<Integer, String> getAllAttributeDisplayNames(boolean onlyActiveEntries) {
        List<T> all = this.getAll(onlyActiveEntries);
        Stream stream = all.stream();
        return stream.collect(Collectors.toMap(c -> c.getId(), c -> c.getDisplayValue() == null ? "" : c.getDisplayValue()));
    }

    public T getByDisplayName(String displayName, boolean validOnly) {
        return (T)((FieldVO)this.getAll(validOnly).stream().filter(f -> f.getDisplayValue().equalsIgnoreCase(displayName)).findFirst().orElse(null));
    }

    private /* synthetic */ void lambda$updateCacheValues$0(Integer key) {
        this.cacheMap.remove(key);
    }

    public static interface DataChangeListener {
        public void cacheUpdated();
    }
}

