/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.helpdesk.core.data.LocalizationBundle;
import com.inet.helpdesk.core.model.general.Localization;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithField;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.ByFirstLetterSortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class TicketFieldDefinitionSubject
extends AbstractTicketFieldDefinitionWithField<String> {
    public TicketFieldDefinitionSubject() {
        super(Tickets.FIELD_SUBJECT, true, false);
    }

    @Override
    public String getDisplayValue(TicketVO ticket) {
        String displayValue = ticket.getSubject();
        TicketPermissionContext permissionContext = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket.getID());
        if (ticket.getWorkflowID() != null && permissionContext.hasSupporterAccessToTicket()) {
            ServerPluginManager spm = ServerPluginManager.getInstance();
            LocalizationBundle localizationBundle = (LocalizationBundle)spm.getSingleInstance(LocalizationBundle.class);
            Localization localization = localizationBundle.getInstance(ClientLocale.getThreadLocale());
            displayValue = ticket.isSubTicketInWorkflow() ? localization.getTranslation("WFNr", new Object[]{ticket.getWorkflowID(), displayValue}, null) : localization.getTranslation("WFHaupt", new Object[]{null, displayValue}, null);
        }
        return displayValue;
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        return new FieldEditDefinition(){

            @Override
            public boolean isAvailable(List<TicketVO> tickets) {
                if (tickets != null) {
                    ActionVO action = (ActionVO)ActionManager.getInstance().get(-31);
                    for (TicketVO ticket : tickets) {
                        if (TicketManager.getTicketActionChecker().checkAction(action, ticket, TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket)) == null) continue;
                        return false;
                    }
                }
                return true;
            }

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                String subject = values.get(this.getFieldKey());
                if (subject != null) {
                    ticketData.put(Tickets.FIELD_SUBJECT, subject);
                }
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                if (ticket != null) {
                    String subject = ticket.getSubject();
                    values.put(this.getFieldKey(), String.valueOf(subject));
                } else {
                    values.put(this.getFieldKey(), "");
                }
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionSubject.this.getKey();
            }

            @Override
            public String getDisplayType() {
                return TEXTINPUT;
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionSubject.this.getDisplayName();
            }
        };
    }

    @Override
    public SortGroupInformation getSortGroupInformation() {
        return new ByFirstLetterSortGroupInformation(this);
    }

    @Override
    public Comparator<TicketVO> getComparator() {
        Comparator comp = String.CASE_INSENSITIVE_ORDER;
        Comparator nullsFirst = Comparator.nullsFirst(comp);
        return (a, b) -> nullsFirst.compare(this.getDisplayValue((TicketVO)a), this.getDisplayValue((TicketVO)b));
    }
}

