/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithUser;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldSortedIteratorDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectOption;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.List;
import java.util.Map;

public class TicketFieldDefinitionOwnerId
extends AbstractTicketFieldDefinitionWithUser {
    public TicketFieldDefinitionOwnerId() {
        super(Tickets.FIELD_OWNER_GUID);
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        return new FieldEditDefinition(){

            @Override
            public boolean isAvailable(List<TicketVO> tickets) {
                if (!HDUsersAndGroups.isSupporter(UserManager.getInstance().getCurrentUserAccount())) {
                    return false;
                }
                if (tickets != null) {
                    ActionVO action = (ActionVO)ActionManager.getInstance().get(-10);
                    for (TicketVO ticket : tickets) {
                        if (TicketManager.getTicketActionChecker().checkAction(action, ticket, TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket)) == null) continue;
                        return false;
                    }
                }
                return tickets != null && !tickets.isEmpty();
            }

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                String value = values.get(this.getFieldKey());
                if (!StringFunctions.isEmpty((String)value)) {
                    SelectOption selectOption = (SelectOption)new Json().fromJson(value, SelectOption.class);
                    String valueString = selectOption.getValue();
                    if (!StringFunctions.isEmpty((String)valueString)) {
                        GUID ticketOwnerID = GUID.valueOf((String)valueString);
                        if (ticketOwnerID != null) {
                            ticketData.put(Tickets.FIELD_OWNER_GUID, ticketOwnerID);
                        }
                    } else {
                        ticketData.put(Tickets.FIELD_OWNER_GUID, null);
                    }
                }
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                UserAccount userAccount;
                GUID ticketOwnerID = null;
                if (ticket != null) {
                    ticketOwnerID = ticket.getOwnerID();
                }
                SelectOption option = new SelectOption(null, "");
                if (ticketOwnerID != null && (userAccount = UserManager.getInstance().getUserAccount(ticketOwnerID)) != null) {
                    option = new SelectOption(ticketOwnerID.toString(), userAccount.getDisplayName(), ticketOwnerID.toString());
                }
                values.put(this.getFieldKey(), new Json().toJson((Object)option));
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionOwnerId.this.getKey();
            }

            @Override
            public String getDisplayType() {
                return OWNER;
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionOwnerId.this.getDisplayName();
            }
        };
    }

    @Override
    public FieldSortedIteratorDefinition getSortedDefinition() {
        return new FieldSortedIteratorDefinition("ownerid", (IndexSearchEngine<GUID>)UserManager.getInstance().getSearchEngine(), "useraccountdisplayname");
    }
}

