/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.http.servlet.ClientLocale;
import java.util.Comparator;

public class TicketFieldDefinitionItilLinkCount
extends TicketFieldDefinition {
    public TicketFieldDefinitionItilLinkCount() {
        super(TicketFieldDefinition.FIELD_GROUPING.TICKET, "itillinkcount", true, false);
    }

    @Override
    public String getDisplayName() {
        String itilDisplayName = HDFieldDisplayNameProvider.getDisplayNameForCustomField(Tickets.FIELD_ITIL_ID);
        String msgKey = "field." + this.getKey();
        return Tickets.MSG.getMsg(ClientLocale.getThreadLocale(), msgKey, new Object[]{itilDisplayName});
    }

    @Override
    public String getDisplayValue(TicketVO ticket) {
        return String.valueOf(ticket.getAttribute(Tickets.ATTRIBUTE_ITIL_COUNT));
    }

    @Override
    public Comparator<TicketVO> getComparator() {
        return (t1, t2) -> Integer.compare(t1.getAttribute(Tickets.ATTRIBUTE_ITIL_COUNT), t2.getAttribute(Tickets.ATTRIBUTE_ITIL_COUNT));
    }
}

