/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithDate;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.shared.model.Status;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldWorkingHours;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;

public class TicketFieldDefinitionDeadline
extends AbstractTicketFieldDefinitionWithDate {
    private static final ConfigValue<Double> YELLOW_DEADLINE_THRESHOLD = new ConfigValue(HDConfigKeys.TICKET_WARNING_YELLOW_DEADLINE_THRESHOLD);
    private static final ConfigValue<Double> RED_DEADLINE_THRESHOLD = new ConfigValue(HDConfigKeys.TICKET_WARNING_RED_DEADLINE_THRESHOLD);

    public TicketFieldDefinitionDeadline() {
        super(Tickets.FIELD_DEADLINE, true, false);
    }

    @Override
    public URL getColumnIcon(Integer iconSize) {
        if (iconSize <= 16) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_deadline_16.png");
        }
        if (iconSize <= 32) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_deadline_16@2x.png");
        }
        return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_deadline_16@3x.png");
    }

    private long getWorkingTime(LocalTime startTime, LocalTime endTime, LocalDateTime dateTime, LocalDateTime limitDateTime) {
        LocalDateTime workingHoursStartDateTime;
        LocalDateTime workingHoursEndDateTime = LocalDateTime.of(dateTime.toLocalDate(), endTime);
        if (dateTime.toLocalDate().isEqual(limitDateTime.toLocalDate())) {
            LocalTime localTime = startTime = limitDateTime.toLocalTime().isAfter(startTime) ? limitDateTime.toLocalTime() : startTime;
        }
        if (dateTime.isBefore(workingHoursStartDateTime = LocalDateTime.of(dateTime.toLocalDate(), startTime)) || workingHoursEndDateTime.isBefore(workingHoursStartDateTime)) {
            return 0L;
        }
        if (dateTime.isAfter(workingHoursEndDateTime)) {
            return Duration.between(startTime, endTime).toMillis();
        }
        return Duration.between(startTime, dateTime).toMillis();
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        return new FieldEditDefinition(){

            @Override
            public boolean isAvailable(List<TicketVO> tickets) {
                if (!HDUsersAndGroups.isSupporter(UserManager.getInstance().getCurrentUserAccount())) {
                    return false;
                }
                if (tickets != null) {
                    ActionVO action = (ActionVO)ActionManager.getInstance().get(-17);
                    for (TicketVO ticket : tickets) {
                        if (TicketManager.getTicketActionChecker().checkAction(action, ticket, TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket)) == null) continue;
                        return false;
                    }
                }
                return true;
            }

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                String deadlineVal = values.get(this.getFieldKey());
                if (deadlineVal != null) {
                    if (StringFunctions.isEmpty((String)deadlineVal)) {
                        ticketData.put(Tickets.FIELD_DEADLINE, null);
                    } else {
                        ticketData.put(Tickets.FIELD_DEADLINE, Long.valueOf(deadlineVal));
                    }
                }
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                if (ticket != null) {
                    Long deadline = ticket.getDeadline();
                    if (deadline == null) {
                        values.put(this.getFieldKey(), "");
                    } else {
                        values.put(this.getFieldKey(), String.valueOf(deadline));
                    }
                } else {
                    values.put(this.getFieldKey(), "");
                }
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionDeadline.this.getKey();
            }

            @Override
            public String getDisplayType() {
                return DATEVALUE;
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionDeadline.this.getDisplayName();
            }
        };
    }

    @Override
    public String getValueAsStringForIcon(TicketVO ticket) {
        Instant instantDeadline;
        LocalDateTime dateTimeDeadline;
        Instant instantTime;
        LocalDateTime dateTime;
        if (ticket.getDeadline() == null) {
            return null;
        }
        long time = System.currentTimeMillis();
        boolean active = Status.isOpenStatus(ticket.getStatusID());
        if (!active) {
            time = 0L;
            for (ReaStepVO reaStepVO : TicketManager.getReader().getReaStepsForTicket(ticket.getID(), BundleStepsFilter.WITH_BUNDLE_STEPS)) {
                if (!Status.isClosedOrDeletedStatus(((ActionVO)ActionManager.getInstance().get(reaStepVO.getActionID())).getStatusID())) continue;
                time = Math.max(time, reaStepVO.getEndDate());
            }
        }
        if ((dateTime = (instantTime = Instant.ofEpochMilli(time)).atZone(ZoneId.systemDefault()).toLocalDateTime()).isAfter(dateTimeDeadline = (instantDeadline = Instant.ofEpochMilli(ticket.getDeadline())).atZone(ZoneId.systemDefault()).toLocalDateTime())) {
            return "overdue";
        }
        GUID resId = ticket.getResourceID();
        if (resId == null) {
            return "green";
        }
        UserGroupInfo resource = UserGroupManager.getInstance().getGroup(resId);
        if (resource == null) {
            return "green";
        }
        ResourceFieldWorkingHours.WorkingHours workingHours = (ResourceFieldWorkingHours.WorkingHours)resource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_WORKING_HOURS);
        if (workingHours == null && (workingHours = (ResourceFieldWorkingHours.WorkingHours)HDUsersAndGroups.RES_FIELD_WORKING_HOURS.getDefaultValue()) == null) {
            return "green";
        }
        long yellowThreshold = (long)((Double)YELLOW_DEADLINE_THRESHOLD.get() * 60.0 * 60.0 * 1000.0);
        long redThreshold = (long)((Double)RED_DEADLINE_THRESHOLD.get() * 60.0 * 60.0 * 1000.0);
        long timeLeftToDeadline = 0L;
        while (true) {
            ResourceFieldWorkingHours.HourRange range = workingHours.getHourRange(dateTimeDeadline.getDayOfWeek());
            long workingTime = 0L;
            if (range != null) {
                workingTime = this.getWorkingTime(range.getStart(), range.getEnd(), dateTimeDeadline, dateTime);
                timeLeftToDeadline += workingTime;
            }
            if (timeLeftToDeadline > yellowThreshold) {
                return "green";
            }
            if (dateTime.toLocalDate().isEqual(dateTimeDeadline.toLocalDate())) {
                if (timeLeftToDeadline <= yellowThreshold && timeLeftToDeadline > redThreshold) {
                    return "yellow";
                }
                if (timeLeftToDeadline <= redThreshold) {
                    return "red";
                }
                return "green";
            }
            dateTimeDeadline = LocalDateTime.of(dateTimeDeadline.toLocalDate(), LocalTime.MAX);
            dateTimeDeadline = dateTimeDeadline.minusDays(1L);
        }
    }

    @Override
    public URL getIconForValue(String valueAsString, int size) {
        if (StringFunctions.isEmpty((String)valueAsString)) {
            return null;
        }
        if ("green".equals(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/deadline_gruen_16.gif");
        }
        if ("yellow".equals(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/deadline_yellow_16.gif");
        }
        if ("red".equals(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/deadline_red_16.gif");
        }
        if ("overdue".equals(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/deadline_bomb_16.gif");
        }
        return null;
    }
}

