/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.extension;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.plugin.ServerPluginManager;

public class UpdateReaStepTextExtensionFactory
implements TicketActionExtensionFactory {
    @Override
    public TicketActionExtension createIfApplicable(OperationChangedTicket ticket, int actionID, ExtensionArguments arguments, MutableReaStepData reaStepData) {
        if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
            return null;
        }
        if (actionID == -22) {
            return new UpdateReaStepTextExtension(arguments);
        }
        return null;
    }

    public static class UpdateReaStepTextExtension
    implements TicketActionExtension {
        protected final int stepId;
        protected final MutableReaStepText newText;

        public UpdateReaStepTextExtension(ExtensionArguments arguments) {
            ExtensionArguments.EditReastepTextActionExtensionData editReastepTextActionExtensionData = arguments.get(ExtensionArguments.EXTARG_CHANGED_REA_STEP);
            if (editReastepTextActionExtensionData == null) {
                throw new IllegalArgumentException("When editing a reaStep, the extension argument ExtensionArguments.EXTARG_CHANGED_REA_STEP must be specified.");
            }
            this.stepId = editReastepTextActionExtensionData.getChangedReaStepID();
            this.newText = MutableReaStepText.of(editReastepTextActionExtensionData.getChangeReaStepContent());
        }

        @Override
        public void extendTicketAction(ActionVO action, OperationChangedTicket ticket, OperationNewReaStep reaStep, TicketSubOperations operations) {
            ticket.changeReaStep(this.stepId, this.newText);
        }
    }
}

