/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.model.resource;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.model.general.AbstractData;
import com.inet.helpdesk.shared.model.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

@JsonData
public class Resource
extends AbstractData {
    private static final long serialVersionUID = 1L;
    private int numberOfTickets;
    private int unreadCount;
    private int version = -1;
    private ArrayList<Resource> children = new ArrayList();

    public Resource() {
    }

    public Resource(int typeId, int keyId, String displayName, int totalCount, int unreadCount) {
        super(typeId, keyId, displayName);
        this.numberOfTickets = totalCount;
        this.unreadCount = unreadCount;
    }

    public void addChild(Resource child) {
        if (child != null) {
            this.children.add(child);
        }
    }

    public ArrayList<Resource> getChildren() {
        return this.children;
    }

    public int getTotalCount() {
        return this.numberOfTickets;
    }

    public int getUnreadCount() {
        return this.unreadCount;
    }

    @Override
    public void updateTreeData(Boolean parentWritable, final String userDisplayName) {
        Collections.sort(this.children, new Comparator<Resource>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public int compare(Resource o1, Resource o2) {
                block7: {
                    if (o1.getTypeId() != o2.getTypeId()) {
                        if (o1.getTypeId() != Resource.this.getTypeId()) return -1;
                        return 1;
                    }
                    if (o1.getTypeId() == 7) {
                        Boolean type2 = (Boolean)o2.getData(Field.RESOURCE_ITILMASTERTYPE, Boolean.FALSE);
                        Boolean type1 = (Boolean)o1.getData(Field.RESOURCE_ITILMASTERTYPE, Boolean.FALSE);
                        if (type2.booleanValue() == type1.booleanValue()) {
                            if (o1.getId() == o2.getId()) {
                                return 0;
                            }
                            break block7;
                        } else {
                            if (type2 == false) return 1;
                            return -1;
                        }
                    }
                    if (o1.getTypeId() == 2) {
                        return o2.getId() - o1.getId();
                    }
                }
                String o1Display = o1.getDisplayName() == null ? "" : o1.getDisplayName();
                String o2Display = o2.getDisplayName() == null ? "" : o2.getDisplayName();
                if (o1.getTypeId() != 9) return o1Display.compareToIgnoreCase(o2Display);
                if (o1Display.equals(userDisplayName)) {
                    return -1;
                }
                if (!o2Display.equals(userDisplayName)) return o1Display.compareToIgnoreCase(o2Display);
                return 1;
            }
        });
        Boolean ownValue = (Boolean)this.getData(Field.RESOURCE_WRITABLE, null);
        if (parentWritable != null && ownValue == null && !parentWritable.booleanValue()) {
            this.setWriteable(false);
            ownValue = parentWritable;
        }
        if (this.children.size() > 0) {
            if (ownValue == null) {
                boolean anyChildWritable = false;
                for (Resource child : this.children) {
                    child.updateTreeData(ownValue, userDisplayName);
                    anyChildWritable |= child.isWriteable();
                    this.numberOfTickets += child.getTotalCount();
                    this.unreadCount += child.getUnreadCount();
                }
                if (!anyChildWritable) {
                    this.setWriteable(false);
                }
            } else {
                for (Resource child : this.children) {
                    child.updateTreeData(ownValue, userDisplayName);
                    this.numberOfTickets += child.getTotalCount();
                    this.unreadCount += child.getUnreadCount();
                }
            }
        }
    }

    public Resource getChildByID(int id) {
        for (Resource child : this.children) {
            if (child.getId() != id) continue;
            return child;
        }
        return null;
    }

    @Override
    public String toString() {
        return "Resource: type=" + this.getTypeId() + ", id=" + this.getId() + ", name=" + this.getDisplayName();
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }
}

