/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.model.general;

import com.inet.annotations.JsonData;
import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.model.general.ActionType;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.model.general.ContextType;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.ArrayList;
import java.util.List;

@JsonData
public class FieldSetting {
    private int id;
    private List<String> description;
    private int setting;
    private boolean mandatoryInquiry;
    private boolean mandatoryEdit;
    private static final ConfigValue<Integer> CONFIG_MANDANTEN = new ConfigValue(HDConfigKeys.USER_ACCESS_FILTER);

    public FieldSetting(int id, String description, int setting, int required) {
        this.id = id;
        if (description != null) {
            this.description = new ArrayList<String>();
            for (String part : description.split("\\n")) {
                if (!part.startsWith("*") && !part.startsWith("#")) continue;
                this.description.add(part.trim());
            }
        }
        this.setting = setting;
        this.mandatoryInquiry = (required & 1) == 1;
        this.mandatoryEdit = (required & 2) == 2;
    }

    public int getOptionValue(ActionType action, ContextType context, UserAccount account) {
        if (this.id == 16) {
            int option = SystemPermissionChecker.hasAnyPermission((UserAccount)account, (Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER}) ? 0 : ((Integer)CONFIG_MANDANTEN.get() == 2 ? 4 : (HDUsersAndGroups.isResourceMember(account) || SystemPermissionChecker.hasAnyPermission((UserAccount)account, (Permission[])new Permission[]{HdPermissions.DISPATCHER}) ? (this.setting >= 1 ? 0 : 4) : (this.setting >= 2 ? 0 : 4)));
            return option;
        }
        if (this.id == 1 && (Integer)CONFIG_MANDANTEN.get() == 1) {
            if (SystemPermissionChecker.hasAnyPermission((UserAccount)account, (Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER})) {
                return 0;
            }
            if (context == ContextType.supporter) {
                return 4;
            }
            if (this.setting == 2) {
                return 32;
            }
            return 4;
        }
        switch (context) {
            case enduser: {
                if (this.id <= 7) {
                    switch (this.setting) {
                        case 0: {
                            return 0;
                        }
                        case 1: {
                            return 4;
                        }
                        case 2: {
                            return 32;
                        }
                    }
                }
                if (this.id == 14) {
                    switch (this.setting) {
                        case 0: {
                            return 0;
                        }
                        case 1: {
                            return 32;
                        }
                    }
                }
                if (this.id == 15) {
                    switch (this.setting) {
                        case 0: {
                            return 0;
                        }
                        case 1: {
                            return 3;
                        }
                        case 2: {
                            return 32;
                        }
                    }
                }
                if (this.id > 16 && this.id <= 20 || this.id == 25) {
                    switch (this.setting) {
                        case 0: {
                            return 32;
                        }
                        case 1: {
                            return 0;
                        }
                        case 2: {
                            return 3;
                        }
                    }
                }
                return 0;
            }
            case supporter: {
                if (action == ActionType.createInquiry || action == ActionType.editInquiry) {
                    if (this.id == Field.TICKETDATA_PRIORITYID.getLanguageSetID() || this.id == Field.TICKETDATA_ITILID.getLanguageSetID()) {
                        return this.mandatoryInquiry ? 9 : 0;
                    }
                    return this.mandatoryInquiry ? 3 : 0;
                }
                if (this.id == Field.TICKETDATA_PRIORITYID.getLanguageSetID() || this.id == Field.TICKETDATA_ITILID.getLanguageSetID()) {
                    return this.mandatoryEdit ? 9 : 0;
                }
                return this.mandatoryEdit ? 3 : 0;
            }
        }
        return 0;
    }

    public int getSetting() {
        return this.setting;
    }

    public List<String> getDescription() {
        return this.description;
    }

    public boolean isMandatoryInquiry() {
        return this.mandatoryInquiry;
    }

    public boolean isMandatoryEdit() {
        return this.mandatoryEdit;
    }
}

