/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.model.general;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.model.general.ContextType;
import java.util.Arrays;
import java.util.List;

@JsonData
public enum ActionType {
    editTicket,
    editInquiry,
    editUser,
    createInquiry,
    editUserLumpSum,
    editHdGroup,
    editPermissionGroup;


    public List<Field> getFields(ContextType type) {
        switch (this) {
            case editUser: {
                switch (type) {
                    case supporter: {
                        return Arrays.asList(Field.USERDATA_USERNAME, Field.USERDATA_LASTNAME, Field.USERDATA_FIRSTNAME, Field.USERDATA_LOCATION, Field.USERDATA_GROUP, Field.USERDATA_TELEPHONE, Field.USERDATA_ROOM, Field.USERDATA_DEPARTMENT, Field.USERDATA_EMAIL, Field.USERDATA_LANGUAGE, Field.USERDATA_COMPUTERNAME, Field.USERDATA_COSTCENTRE, Field.USERDATA_USERFIELD1, Field.USERDATA_USERFIELD2, Field.USERDATA_USERFIELD3, Field.USERDATA_USERFIELD4, Field.USERDATA_USERFIELD5, Field.USERDATA_USERFIELD6);
                    }
                    case enduser: {
                        return Arrays.asList(Field.USERDATA_USERNAME, Field.USERDATA_LASTNAME, Field.USERDATA_FIRSTNAME, Field.USERDATA_LOCATION, Field.USERDATA_GROUP, Field.USERDATA_TELEPHONE, Field.USERDATA_ROOM, Field.USERDATA_DEPARTMENT, Field.USERDATA_EMAIL, Field.USERDATA_LANGUAGE, Field.USERDATA_COMPUTERNAME, Field.USERDATA_COSTCENTRE, Field.USERDATA_USERFIELD1, Field.USERDATA_USERFIELD2, Field.USERDATA_USERFIELD3, Field.USERDATA_USERFIELD4, Field.USERDATA_USERFIELD5, Field.USERDATA_USERFIELD6);
                    }
                }
                break;
            }
            case editTicket: {
                switch (type) {
                    case supporter: {
                        return Arrays.asList(Field.TICKETDATA_OWNER, Field.TICKETDATA_TICKETID, Field.TICKETDATA_RESOURCEID, Field.TICKETDATA_PRIORITYID, Field.TICKETDATA_CATEGORYID, Field.TICKETDATA_DEADLINE, Field.TICKETDATA_SPECIALFIELD, Field.TICKETDATA_CLASSIFICATIONID, Field.TICKETDATA_TICKETFIELD1, Field.TICKETDATA_TICKETFIELD2, Field.TICKETDATA_TICKETFIELD3, Field.TICKETDATA_TICKETFIELD4, Field.TICKETDATA_ITILID, Field.TICKETDATA_DUETIME, Field.TICKETDATA_SUBJECT);
                    }
                    case enduser: {
                        return null;
                    }
                }
                break;
            }
            case editInquiry: {
                switch (type) {
                    case supporter: {
                        return Arrays.asList(Field.TICKETDATA_OWNER, Field.TICKETDATA_TICKETID, Field.TICKETDATA_RESOURCEID, Field.TICKETDATA_PRIORITYID, Field.TICKETDATA_CATEGORYID, Field.TICKETDATA_DEADLINE, Field.TICKETDATA_SPECIALFIELD, Field.TICKETDATA_CLASSIFICATIONID, Field.TICKETDATA_TICKETFIELD1, Field.TICKETDATA_TICKETFIELD2, Field.TICKETDATA_TICKETFIELD3, Field.TICKETDATA_TICKETFIELD4, Field.TICKETDATA_ITILID, Field.TICKETDATA_AUTOMAILING, Field.TICKETDATA_DUETIME, Field.TICKETDATA_SUBJECT, Field.TICKETDATA_PREVIEW);
                    }
                    case enduser: {
                        return null;
                    }
                }
                break;
            }
            case createInquiry: {
                switch (type) {
                    case enduser: {
                        return Arrays.asList(Field.TICKETDATA_PRIORITYID, Field.TICKETDATA_CATEGORYID, Field.TICKETDATA_CLASSIFICATIONID, Field.TICKETDATA_TICKETFIELD1, Field.TICKETDATA_TICKETFIELD2, Field.TICKETDATA_TICKETFIELD3, Field.TICKETDATA_TICKETFIELD4, Field.TICKETDATA_SUBJECT, Field.TICKETDATA_PREVIEW);
                    }
                    case supporter: {
                        return Arrays.asList(Field.TICKETDATA_OWNER, Field.TICKETDATA_RESOURCEID, Field.TICKETDATA_PRIORITYID, Field.TICKETDATA_DEADLINE, Field.TICKETDATA_CATEGORYID, Field.TICKETDATA_SPECIALFIELD, Field.TICKETDATA_CLASSIFICATIONID, Field.TICKETDATA_TICKETFIELD1, Field.TICKETDATA_TICKETFIELD2, Field.TICKETDATA_TICKETFIELD3, Field.TICKETDATA_TICKETFIELD4, Field.TICKETDATA_ITILID, Field.TICKETDATA_AUTOMAILING, Field.TICKETDATA_DUETIME, Field.TICKETDATA_SUBJECT, Field.TICKETDATA_PREVIEW);
                    }
                }
                break;
            }
            case editUserLumpSum: {
                switch (type) {
                    case supporter: {
                        return Arrays.asList(Field.USERDATA_LUMPSUM1, Field.USERDATA_LUMPSUM2, Field.USERDATA_LUMPSUM3);
                    }
                    case enduser: {
                        return null;
                    }
                }
                break;
            }
            case editHdGroup: {
                switch (type) {
                    case supporter: {
                        return Arrays.asList(Field.HDGROUP_NAME);
                    }
                    case enduser: {
                        return null;
                    }
                }
                break;
            }
            case editPermissionGroup: {
                switch (type) {
                    case supporter: {
                        return Arrays.asList(Field.PERMISSIONGROUP_NAME);
                    }
                    case enduser: {
                        return null;
                    }
                }
            }
        }
        return null;
    }
}

