/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.mail;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.data.FileContainer;
import com.inet.mail.api.MailDataSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class MailAttachment
implements MailDataSource {
    private boolean inLineDeklaration;
    private FileContainer file;

    public MailAttachment(FileContainer file, boolean inLineDeklaration) {
        this.file = file;
        this.inLineDeklaration = inLineDeklaration;
    }

    public void setInLineDeklaration(boolean inLineDeklaration) {
        this.inLineDeklaration = inLineDeklaration;
    }

    public String getFileName() {
        return this.file.getName();
    }

    public String getPath() {
        return this.file.getPath();
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="ist nur ein probecontenttype, au\u00dferdem wird weiter oben schon auf path traversal gecheckt")
    public String getContentType() {
        try {
            String probeContentType = Files.probeContentType(new File(this.file.getName()).toPath());
            return probeContentType == null ? "application/octet-stream" : probeContentType;
        }
        catch (IOException e) {
            return "application/octet-stream";
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.file.getInputStream();
    }

    public String getName() {
        return this.file.getName();
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("You cannot write the file which is to be send by Email!");
    }

    public String getContentId() {
        if (this.inLineDeklaration) {
            return this.file.getName();
        }
        return null;
    }

    public boolean isInlined() {
        return this.getContentId() != null;
    }
}

