/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.data.valueprovider;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.model.general.Entry;
import com.inet.helpdesk.shared.model.general.ContextType;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.ArrayList;

public class CategoryByIDValueProvider
implements ServerValuesConnector.ValueProvider {
    private String categoryField;
    private int yourId;

    public CategoryByIDValueProvider(String categoryField) {
        this.categoryField = categoryField;
    }

    @Override
    public String getFieldKey() {
        return this.categoryField;
    }

    @Override
    public void notifyRegisteredId(int yourId) {
        this.yourId = yourId;
    }

    @Override
    public ArrayList<Entry> getData(UserAccount account, boolean emptyValue) throws ServerDataException {
        ServerValuesConnector svc = (ServerValuesConnector)ServerPluginManager.getInstance().getSingleInstance(ServerValuesConnector.class);
        ArrayList<Entry> data = svc.getData(ContextType.supporter, account, 4, false);
        this.updateTypeAndKey(data);
        return data;
    }

    private void updateTypeAndKey(ArrayList<Entry> data) {
        if (data != null) {
            for (Entry e : data) {
                e.setTypeId(this.yourId);
                e.setStringKey(null);
                this.updateTypeAndKey(e.getChildren());
            }
        }
    }

    @Override
    public boolean hasData(UserAccount account) throws ServerDataException {
        return true;
    }

    @Override
    public boolean allowCustomValues() {
        return false;
    }

    @Override
    public boolean allowMultipleValues() {
        return false;
    }

    @Override
    public Entry getDefaultValue(UserAccount account) throws ServerDataException {
        return new Entry(this.yourId, EMPYT_VALUE_ID, "", "");
    }
}

