/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.data;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.model.general.Entry;
import com.inet.helpdesk.core.model.ticket.Ticket;
import com.inet.helpdesk.shared.model.user.User;
import com.inet.id.GUID;
import com.inet.search.index.IndexerStatus;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Nonnull;

public interface MaintenanceConnector {
    public void triggerIndexer();

    public IndexerStatus getIndexerStatus();

    public TicketsToDelete findAllTicketsMarkedAsDeleted() throws ServerDataException;

    public void deleteAllTicketsMarkedAsDeleted() throws ServerDataException;

    public TicketsToDelete findTicketsByDate(Date var1) throws ServerDataException;

    public void deleteTicketsByDate(Date var1) throws ServerDataException;

    public TicketsToDelete findTicketsById(int var1, int var2) throws ServerDataException;

    public void deleteTicketsById(int var1, int var2) throws ServerDataException;

    public EntriesToDelete<UnrelatedUser> findUnrelatedUsers() throws ServerDataException;

    public void deleteUnrelatedUsers() throws ServerDataException;

    public EntriesToDelete<UnrelatedUser> findUnrelatedUsers(String var1) throws ServerDataException;

    public void deleteUnrelatedUsers(String var1) throws ServerDataException;

    public EntriesToDelete<Entry> findUnrelatedLocations() throws ServerDataException;

    public void deleteUnrelatedLocations(ArrayList<String> var1) throws ServerDataException;

    public static class TicketsToDelete {
        private int foundTicketsCount = 0;
        private int foundBundledTicketsCount = 0;
        private ArrayList<Ticket> exemplaryTickets = new ArrayList();

        public TicketsToDelete(int foundTicketsCount, int foundBundledTicketsCount, ArrayList<Ticket> exemplaryTickets) {
            this.foundTicketsCount = foundTicketsCount;
            this.foundBundledTicketsCount = foundBundledTicketsCount;
            this.exemplaryTickets = exemplaryTickets;
        }

        public int getFoundTicketsCount() {
            return this.foundTicketsCount;
        }

        public int getFoundBundledTicketsCount() {
            return this.foundBundledTicketsCount;
        }

        public ArrayList<Ticket> getExemplaryTickets() {
            return this.exemplaryTickets;
        }
    }

    public static class EntriesToDelete<JSONIZABLE> {
        private int foundEntriesCount = 0;
        private boolean foundMore;
        private ArrayList<JSONIZABLE> exemplaryEntries = new ArrayList();

        public EntriesToDelete(int foundEntriesCount, ArrayList<JSONIZABLE> exemplaryEntries) {
            this.foundEntriesCount = foundEntriesCount;
            this.exemplaryEntries = exemplaryEntries;
        }

        public EntriesToDelete(int foundEntriesCount, boolean foundMore, ArrayList<JSONIZABLE> exemplaryEntries) {
            this.foundEntriesCount = foundEntriesCount;
            this.foundMore = foundMore;
            this.exemplaryEntries = exemplaryEntries;
        }

        public int getFoundEntriesCount() {
            return this.foundEntriesCount;
        }

        public ArrayList<JSONIZABLE> getExemplaryEntries() {
            return this.exemplaryEntries;
        }

        public boolean isFoundMore() {
            return this.foundMore;
        }
    }

    @JsonData
    public static class UnrelatedUser
    extends User {
        private GUID userAccountID;

        private UnrelatedUser() {
        }

        public UnrelatedUser(@Nonnull GUID userAccountID) {
            this.userAccountID = userAccountID;
        }

        public GUID getUserAccountID() {
            return this.userAccountID;
        }
    }
}

