/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.model.dataimport.DataImportSchedule;
import java.util.Arrays;
import java.util.List;

@JsonData
public class UserImportConfigInfo {
    private String uid;
    private DataImportSchedule schedule = new DataImportSchedule();
    private boolean alle;
    private boolean reaktivieren;
    private boolean loeschen;
    private boolean supporterLoeschen;
    private boolean useUserSyntax;
    private String userSyntax;
    private String tabelle;
    private String selectionColumns = "";
    private String defaultSnColumn = "";
    private String supervisorColumn = "";
    private String ldapAndSyntax = "";
    private String name;
    private String connectionName = "";
    private boolean ldap;

    public DataImportSchedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(DataImportSchedule schedule) {
        this.schedule = schedule;
    }

    public boolean isAlle() {
        return this.alle;
    }

    public void setAlle(boolean alle) {
        this.alle = alle;
    }

    public boolean isReaktivieren() {
        return this.reaktivieren;
    }

    public void setReaktivieren(boolean reaktivieren) {
        this.reaktivieren = reaktivieren;
    }

    public boolean isLoeschen() {
        return this.loeschen;
    }

    public void setLoeschen(boolean loeschen) {
        this.loeschen = loeschen;
    }

    public boolean isSupporterLoeschen() {
        return this.supporterLoeschen;
    }

    public void setSupporterLoeschen(boolean supporterLoeschen) {
        this.supporterLoeschen = supporterLoeschen;
    }

    public boolean isUseUserSyntax() {
        return this.useUserSyntax;
    }

    public void setUseUserSyntax(boolean useUserSyntax) {
        this.useUserSyntax = useUserSyntax;
    }

    public String getUserSyntax() {
        return this.userSyntax;
    }

    public void setUserSyntax(String userSyntax) {
        this.userSyntax = userSyntax;
    }

    public String getTable() {
        return this.tabelle;
    }

    public void setTable(String table) {
        this.tabelle = table;
    }

    public String getSelektionList() {
        return this.selectionColumns;
    }

    public void setSelektionList(String selektionList) {
        this.selectionColumns = selektionList;
    }

    public List<String> getSelectionColumns() {
        if (this.selectionColumns == null) {
            return null;
        }
        String[] parts = this.selectionColumns.split("<>");
        return Arrays.asList(parts);
    }

    public void setSelectionColumns(List<String> columns) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < columns.size(); ++i) {
            String col = columns.get(i);
            if (i > 0) {
                b.append("<>");
            }
            b.append(col);
        }
        this.selectionColumns = b.toString();
    }

    public String getDefaultSnColumn() {
        return this.defaultSnColumn;
    }

    public void setDefaultSnColumn(String defaultSnColumn) {
        this.defaultSnColumn = defaultSnColumn;
    }

    public String getSupervisorColumn() {
        return this.supervisorColumn;
    }

    public void setSupervisorColumn(String supervisorColumn) {
        this.supervisorColumn = supervisorColumn;
    }

    @Deprecated
    public String getLdapAndSyntax() {
        return this.ldapAndSyntax;
    }

    @Deprecated
    public void setLdapAndSyntax(String ldapAndSyntax) {
        this.ldapAndSyntax = ldapAndSyntax;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isLdap() {
        return this.ldap;
    }

    public void setLdap(boolean ldap) {
        this.ldap = ldap;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getUid() {
        return this.uid;
    }

    public DataImportSchedule mapOldSchedule(String timeOption) {
        DataImportSchedule schedule = new DataImportSchedule();
        if (timeOption.length() == 0) {
            schedule.setMainImportTimeOption(DataImportSchedule.MainTimeOption.MANUAL);
            return schedule;
        }
        int mainTimeOption = Integer.parseInt(timeOption.substring(0, 1));
        int subTimeOption = Integer.parseInt(timeOption.substring(2));
        switch (mainTimeOption) {
            case 1: {
                schedule.setMainImportTimeOption(DataImportSchedule.MainTimeOption.HALFHOUR);
                break;
            }
            case 2: {
                schedule.setMainImportTimeOption(DataImportSchedule.MainTimeOption.HOURLY);
                break;
            }
            case 3: {
                schedule.setMainImportTimeOption(DataImportSchedule.MainTimeOption.DAILY);
                schedule.setHourOfDay(subTimeOption);
                break;
            }
            case 4: {
                schedule.setMainImportTimeOption(DataImportSchedule.MainTimeOption.WEEKLY);
                switch (subTimeOption) {
                    case 1: {
                        schedule.setSubImportTimeOption(DataImportSchedule.SubTimeOption.TUESDAY);
                        break;
                    }
                    case 2: {
                        schedule.setSubImportTimeOption(DataImportSchedule.SubTimeOption.WEDNESDAY);
                        break;
                    }
                    case 3: {
                        schedule.setSubImportTimeOption(DataImportSchedule.SubTimeOption.THURSDAY);
                        break;
                    }
                    case 4: {
                        schedule.setSubImportTimeOption(DataImportSchedule.SubTimeOption.FRIDAY);
                        break;
                    }
                    case 5: {
                        schedule.setSubImportTimeOption(DataImportSchedule.SubTimeOption.SATURDAY);
                        break;
                    }
                    case 6: {
                        schedule.setSubImportTimeOption(DataImportSchedule.SubTimeOption.SUNDAY);
                        break;
                    }
                    default: {
                        schedule.setSubImportTimeOption(DataImportSchedule.SubTimeOption.MONDAY);
                    }
                }
                schedule.setHourOfDay(3);
                break;
            }
            default: {
                schedule.setMainImportTimeOption(DataImportSchedule.MainTimeOption.MANUAL);
                schedule.setSubImportTimeOption(null);
                schedule.setHourOfDay(3);
            }
        }
        return schedule;
    }
}

