/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.Translator;
import com.inet.helpdesk.core.HDLogger;
import com.inet.lib.json.Json;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import srv.ServerUtilities;

@JsonData
public class DatabaseConfigInfoListConfigProperty
extends ItemListConfigProperty {
    private static final String ACTION_TEST_DB_NEW = "helpdesk.db.testdb.new";

    public DatabaseConfigInfoListConfigProperty(ConfigStructureSettings settings, Translator translator) {
        super(0, HDConfigKeys.DB_CONFIGS.getKey(), "DB_CONFIGS", DatabaseConfigInfoListConfigProperty.getObjectListValue(settings), translator.translate("dbconfigs.add.new"), new ConfigRowAction[]{DatabaseConfigInfoListConfigProperty.getRowAction(settings, translator)});
    }

    static Object getObjectListValue(ConfigStructureSettings settings) {
        HashMap[] changedValue = (HashMap[])settings.getChangedValue(HDConfigKeys.DB_CONFIGS, HashMap[].class);
        if (changedValue != null) {
            ArrayList<Thread> checkingThreads = new ArrayList<Thread>();
            int index = 0;
            for (HashMap account : changedValue) {
                String driver = (String)account.get("driver");
                if (!"other".equals(driver)) {
                    account.remove("url");
                }
                DatabaseConfigInfoListConfigProperty.setPortForDatabase(account);
                DatabaseConfigInfo hds = DatabaseConfigInfoListConfigProperty.convertToEntry(account);
                account.put("status", DatabaseConfigInfo.Status.Invalid.name());
                Thread checkingThread = new Thread(() -> {
                    if (ServerUtilities.testDB(hds.getUrl(), hds.getDecodedPassword(), hds.getUser(), hds.getDriverClassName(), null, false) == null) {
                        account.put("status", DatabaseConfigInfo.Status.Valid.name());
                    } else {
                        account.put("status", DatabaseConfigInfo.Status.Invalid.name());
                    }
                }, "connectionChecker" + ++index);
                checkingThread.setDaemon(true);
                checkingThread.start();
                checkingThreads.add(checkingThread);
            }
            long restZeit = 10000L;
            long startingToWaitTime = System.currentTimeMillis();
            for (Thread t : checkingThreads) {
                if ((restZeit -= System.currentTimeMillis() - startingToWaitTime) <= 0L) {
                    t.interrupt();
                    continue;
                }
                try {
                    t.join(restZeit);
                    if (!t.isAlive()) continue;
                    t.interrupt();
                }
                catch (InterruptedException e) {
                    HDLogger.error(e);
                }
            }
            return changedValue;
        }
        String valueStr = settings.getValue(HDConfigKeys.DB_CONFIGS);
        DatabaseConfigInfoList dbConfigInfoList = (DatabaseConfigInfoList)new Json().fromJson(valueStr, DatabaseConfigInfoList.class);
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        for (DatabaseConfigInfo dbc : dbConfigInfoList) {
            if ("HDS".equals(dbc.getDbName())) continue;
            HashMap<String, String> entry = DatabaseConfigInfoListConfigProperty.convertToHashmap(dbc);
            result.add(entry);
        }
        return result;
    }

    private static void setPortForDatabase(HashMap<String, String> account) {
        String portString;
        String protocol;
        String portField;
        if (account.get("driver") != null && (portField = DatabaseConfigInfoListConfigProperty.portFieldForDatabase(protocol = account.get("driver"))) != null && account.get(portField) != null && !"null".equals((portString = account.get(portField)).trim())) {
            account.put("port", portString);
        }
    }

    private static String portFieldForDatabase(String protocol) {
        String portField = null;
        switch (protocol) {
            case "inetora": {
                portField = "portoracle";
                break;
            }
            case "inetdae7": {
                portField = "portmssql";
                break;
            }
            case "mysql": {
                portField = "portmysql";
                break;
            }
        }
        return portField;
    }

    public static HashMap<String, String> convertToHashmap(DatabaseConfigInfo dbc) {
        HashMap<String, String> entry = new HashMap<String, String>();
        entry.put("catalog", dbc.getCatalog());
        entry.put("odbcsource", dbc.getCatalog());
        entry.put("dbName", dbc.getDbName());
        entry.put("password", dbc.getDecodedPassword());
        entry.put("driver", dbc.getDriver().name());
        entry.put("host", dbc.getHost());
        entry.put("hostmssql", dbc.getHost());
        entry.put("port", dbc.getPort());
        entry.put("status", dbc.getStatus().name());
        entry.put("portoracle", "");
        entry.put("portmysql", "");
        entry.put("portmssql", "");
        String portField = DatabaseConfigInfoListConfigProperty.portFieldForDatabase((String)entry.get("driver"));
        if (portField != null) {
            entry.put(portField, (String)entry.get("port"));
        }
        entry.put("sid", dbc.getSid());
        entry.put("url", dbc.getUrl());
        entry.put("user", dbc.getUser());
        entry.put("isNewlyCreated", "false");
        return entry;
    }

    public static DatabaseConfigInfoList convertToList(String value) {
        HashMap[] result = (HashMap[])new Json().fromJson(value, HashMap[].class);
        return DatabaseConfigInfoListConfigProperty.convertToList(result);
    }

    public static DatabaseConfigInfoList convertToList(HashMap<String, String>[] result) {
        DatabaseConfigInfoList list = new DatabaseConfigInfoList();
        for (HashMap<String, String> entry : result) {
            DatabaseConfigInfo dbc = DatabaseConfigInfoListConfigProperty.convertToEntry(entry);
            list.add(dbc);
        }
        return list;
    }

    private static DatabaseConfigInfo convertToEntry(HashMap<String, String> entry) {
        DatabaseConfigInfo dbc = new DatabaseConfigInfo();
        dbc.setCatalog(entry.get("catalog"));
        dbc.setDbName(entry.get("dbName"));
        dbc.setDecodedPassword(entry.get("password").toCharArray());
        DatabaseConfigInfo.DatabaseType driver = DatabaseConfigInfo.DatabaseType.inetdae7;
        try {
            driver = DatabaseConfigInfo.DatabaseType.valueOf(entry.get("driver"));
        }
        catch (Exception e) {
            HDLogger.error(e.getMessage());
        }
        dbc.setDriver(driver);
        if ("odbc".equals(entry.get("driver"))) {
            dbc.setCatalog(entry.get("odbcsource"));
        }
        if ("inetdae7".equals(entry.get("driver"))) {
            dbc.setHost(entry.get("hostmssql"));
        } else {
            dbc.setHost(entry.get("host"));
        }
        entry.put("host", dbc.getHost());
        String portString = entry.get("port");
        dbc.setPort(portString);
        DatabaseConfigInfoListConfigProperty.setPortForDatabase(entry);
        entry.put("portoracle", "");
        entry.put("portmysql", "");
        entry.put("portmssql", "");
        if (portString != null && portString.trim().length() > 0) {
            entry.put("port", dbc.getPort());
            entry.put(DatabaseConfigInfoListConfigProperty.portFieldForDatabase(entry.get("driver")), dbc.getPort());
        }
        dbc.setStatus(DatabaseConfigInfo.Status.valueOf(entry.get("status") == null ? "Unknown" : entry.get("status")));
        dbc.setSid(entry.get("sid"));
        dbc.setCustomUrl(entry.get("url"));
        dbc.setUser(entry.get("user"));
        return dbc;
    }

    private static ConfigRowAction getRowAction(ConfigStructureSettings settings, final Translator translator) {
        ConfigAction action = new ConfigAction("dbconfig.new", translator.translate("AddDatabaseConnection"));
        ConfigCategory category = new ConfigCategory(0, "dbconfig.new", translator.translate("Datenbankverbindung"), "system.database.new-dbconfig");
        ArrayList<ConfigPropertyGroup> propertyGroups = new ArrayList<ConfigPropertyGroup>();
        propertyGroups.add(new ConfigPropertyGroup(0, "dbconfig.new.group", "", new ConfigAction(ACTION_TEST_DB_NEW, translator.translate(ACTION_TEST_DB_NEW))));
        HashMap properties = new HashMap();
        ArrayList<Object> propertyList = new ArrayList<Object>();
        properties.put("dbconfig.new.group", propertyList);
        ArrayList<ConfigConditionAction> conditions = new ArrayList<ConfigConditionAction>();
        ConditionGenerator g = new ConditionGenerator();
        ConfigCondition isOracle = g.createCondition().property("driver").equals().value((Object)"inetora");
        ConfigCondition isMssql = g.createCondition().property("driver").equals().value((Object)"inetdae7");
        ConfigCondition isMysql = g.createCondition().property("driver").equals().value((Object)"mysql");
        ConfigCondition isOther = g.createCondition().property("driver").equals().value((Object)"other");
        ConfigCondition isODBC = g.createCondition().property("driver").equals().value((Object)"odbc");
        ConfigCondition isOtherOrODBCOrMssql = g.createCondition().or(new ConfigCondition[]{isOther, isODBC, isMssql});
        conditions.add(g.visibleActionFor(g.createCondition().not(isOtherOrODBCOrMssql), "host"));
        conditions.add(g.visibleActionFor(isMssql, "hostmssql"));
        conditions.add(g.visibleActionFor(isMssql, "portmssql"));
        conditions.add(g.visibleActionFor(isMysql, "portmysql"));
        conditions.add(g.visibleActionFor(isOracle, "portoracle"));
        conditions.add(g.visibleActionFor(g.createCondition().not(g.createCondition().or(new ConfigCondition[]{isODBC, isOracle, isOther})), "catalog"));
        conditions.add(g.visibleActionFor(isODBC, "odbcsource"));
        conditions.add(g.visibleActionFor(g.createCondition().not(isODBC), "user"));
        conditions.add(g.visibleActionFor(g.createCondition().not(isODBC), "password"));
        conditions.add(g.visibleActionFor(isOracle, "sid"));
        conditions.add(g.visibleActionFor(isOther, "url"));
        conditions.add(g.enableActionFor(g.createCondition().property("isNewlyCreated").equals().value((Object)"true"), "dbName"));
        ConfigRowAction rowAction = new ConfigRowAction(action, null, category, propertyGroups, properties, conditions);
        propertyList.add(DatabaseConfigInfoListConfigProperty.propWith("SimpleText", translator.translate("DBName"), "dbName", "DB1"));
        propertyList.add(new SelectConfigProperty(123, "driver", "SimpleText", translator.translate("Treiber"), (Object)"", null, (List)new ArrayList<LocalizedKey>(){
            {
                this.add(new LocalizedKey("inetdae7", "MS SQL Server"));
                this.add(new LocalizedKey("mysql", "MySQL"));
                this.add(new LocalizedKey("inetora", "Oracle"));
                this.add(new LocalizedKey("odbc", "ODBC"));
                this.add(new LocalizedKey("other", translator.translate("Other")));
            }
        }));
        propertyList.add(DatabaseConfigInfoListConfigProperty.propWith("SelectEdit", translator.translate("DatabaseHost"), "hostmssql", ""));
        propertyList.add(DatabaseConfigInfoListConfigProperty.propWith("SimpleText", translator.translate("DatabaseHost"), "host", ""));
        propertyList.add(DatabaseConfigInfoListConfigProperty.propWith("SimpleText", translator.translate("Port_oder_Instanz"), "portmssql", settings.getValue("portmssql"), "1433"));
        propertyList.add(DatabaseConfigInfoListConfigProperty.propWith("SimpleText", translator.translate("Port"), "portmysql", settings.getValue("portmysql"), "3306"));
        propertyList.add(DatabaseConfigInfoListConfigProperty.propWith("SimpleText", translator.translate("Port"), "portoracle", settings.getValue("portoracle"), "1521"));
        propertyList.add(DatabaseConfigInfoListConfigProperty.propWith("SimpleText", translator.translate("ODBCSource"), "odbcsource", ""));
        propertyList.add(DatabaseConfigInfoListConfigProperty.propWith("SimpleText", translator.translate("Catalog"), "catalog", ""));
        propertyList.add(DatabaseConfigInfoListConfigProperty.propWith("SimpleText", translator.translate("SID"), "sid", ""));
        propertyList.add(DatabaseConfigInfoListConfigProperty.propWith("SimpleText", translator.translate("URL"), "url", ""));
        propertyList.add(DatabaseConfigInfoListConfigProperty.propWith("SimpleText", translator.translate("Benutzername"), "user", ""));
        propertyList.add(DatabaseConfigInfoListConfigProperty.propWith("Password", translator.translate("Passwort"), "password", ""));
        propertyList.add(DatabaseConfigInfoListConfigProperty.propWith("Hidden", "isNewlyCreated", "isNewlyCreated", "true"));
        return rowAction;
    }

    private static ConfigProperty propWith(String type, String label, String keyName, String value) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, null);
    }

    private static ConfigProperty propWith(String type, String label, String keyName, String value, String placeholder) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, placeholder);
    }
}

