/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.modules;

import com.inet.dbupdater.databases.DatabaseInfoFactory;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.model.ISchemaNode;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.dbupdater.model.NodeWithContent;
import com.inet.dbupdater.modules.IPatcherModul;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Segment;

public class ScriptSchemaPatcher
implements IPatcherModul {
    private static final Logger logger = LogManager.getLogger((String)"DB Updater");
    private SearchNode tree = new SearchNode();
    private int shortestKey = Integer.MAX_VALUE;
    private static final HashMap<NodeFactory.TAG, Set<NodeFactory.TAG>> ALLOWED_CONTEXTS = new HashMap();

    private static void addContext(NodeFactory.TAG context, NodeFactory.TAG ... allowed) {
        HashSet<NodeFactory.TAG> set = new HashSet<NodeFactory.TAG>();
        for (NodeFactory.TAG tag : allowed) {
            set.add(tag);
        }
        ALLOWED_CONTEXTS.put(context, set);
    }

    private static boolean isInContext(NodeFactory.TAG tag, NodeFactory.TAG context) {
        if (tag == null || context == null || tag == context) {
            return true;
        }
        Set<NodeFactory.TAG> set = ALLOWED_CONTEXTS.get((Object)context);
        return set == null || set.contains((Object)tag);
    }

    @Override
    public Node patchNode(Node node, IDatabaseInfos dbReference) {
        String refTable;
        NodeFactory.TAG nodeTag = node.getName();
        if (nodeTag == NodeFactory.TAG.database && this.tree.letter == '\u0000') {
            String name = node.getParameter(IDatabaseInfos.DATABASE_PARAM.productname.name());
            int type = dbReference.getTypeID();
            if (name != null && name.length() > 0 && DatabaseInfoFactory.getDatabaseType(name) != type) {
                return node;
            }
            for (Node node2 : node.getAllChildren()) {
                if (!(node2 instanceof ISchemaNode)) continue;
                ISchemaNode sNode = (ISchemaNode)((Object)node2);
                this.addKeyWord(sNode.getName(dbReference), sNode.getSourceName(dbReference), node2.getName());
            }
        }
        if (nodeTag == NodeFactory.TAG.trigger && (refTable = node.getParameter(IDatabaseInfos.TRIGGER_PARAM.table.name())) != null && refTable.length() > 0) {
            String newTable = this.findUntaggedNames(refTable, NodeFactory.TAG.trigger);
            node.readParameter(IDatabaseInfos.TRIGGER_PARAM.table.name(), newTable);
        }
        if (nodeTag == NodeFactory.TAG.condition || nodeTag == NodeFactory.TAG.sql || nodeTag == NodeFactory.TAG.data || nodeTag == NodeFactory.TAG.view || nodeTag == NodeFactory.TAG.trigger) {
            String content = node.getContent();
            content = this.findUntaggedNames(content, nodeTag);
            content = this.replaceTags(content);
            ((NodeWithContent)node).clearContent();
            ((NodeWithContent)node).readString(content);
        }
        return node;
    }

    private String findUntaggedNames(String content, NodeFactory.TAG context) {
        int next;
        Segment s = new Segment(content.toCharArray(), 0, content.length());
        SQLIterator iterator = new SQLIterator();
        ((BreakIterator)iterator).setText(s);
        StringBuilder b = new StringBuilder();
        int start = ((BreakIterator)iterator).first();
        int lastEnd = 0;
        while ((next = ((BreakIterator)iterator).next()) != -1) {
            String replace = this.getReplacement(s.array, start, next, context);
            if (replace != null) {
                boolean doReplace = true;
                int replaceStart = next - replace.length();
                if (replaceStart >= 0) {
                    boolean equal = true;
                    for (int i = replaceStart; i < next; ++i) {
                        if (s.array[i] == replace.charAt(i - replaceStart)) continue;
                        equal = false;
                        break;
                    }
                    boolean bl = doReplace = !equal;
                }
                if (doReplace) {
                    b.append(content.substring(lastEnd, start));
                    b.append(replace);
                    lastEnd = next;
                }
            }
            start = next;
        }
        if (lastEnd == 0) {
            return content;
        }
        if (lastEnd < content.length()) {
            b.append(content.substring(lastEnd));
        }
        return b.toString();
    }

    private String getReplacement(char[] content, int start, int end, NodeFactory.TAG context) {
        if (end - start < this.shortestKey) {
            return null;
        }
        SearchNode node = this.tree;
        int index = start;
        while (index < end) {
            char c = (char)(content[index++] | 0x20);
            while (c != node.letter) {
                if (node.nextEntry != null) {
                    node = node.nextEntry;
                    continue;
                }
                return null;
            }
            if (index >= end) continue;
            if (node.nextLetter != null) {
                node = node.nextLetter;
                continue;
            }
            return null;
        }
        if (ScriptSchemaPatcher.isInContext(node.type, context)) {
            return node.replace;
        }
        return null;
    }

    private String replaceTags(String content) {
        StringBuilder b = new StringBuilder();
        int lastEnd = 0;
        if (content != null && content.length() > 0) {
            Pattern compile = Pattern.compile("\\$(\\w*):(\\w+)\\$", 10);
            Matcher matcher = compile.matcher(content);
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                b.append(content.substring(lastEnd, start));
                String type = matcher.group(1);
                String label = matcher.group(2);
                boolean replaced = false;
                try {
                    String schemaName;
                    NodeFactory.TAG typeTag = null;
                    if (type.length() > 0) {
                        typeTag = NodeFactory.TAG.valueOf(type);
                    }
                    if ((schemaName = this.getReplacement(label.toCharArray(), 0, label.length(), typeTag)) != null) {
                        replaced = true;
                        b.append(schemaName);
                    }
                }
                catch (Throwable e) {
                    logger.error((Object)e);
                }
                if (!replaced) {
                    b.append(label);
                }
                lastEnd = end;
            }
            b.append(content.substring(lastEnd));
        }
        return b.toString();
    }

    private void addKeyWord(String keyword, String replace, NodeFactory.TAG type) {
        if (keyword.length() < this.shortestKey) {
            this.shortestKey = keyword.length();
        }
        if (replace == null) {
            return;
        }
        char[] letters = keyword.toCharArray();
        if (this.tree.letter == '\u0000') {
            this.tree.letter = (char)(letters[0] | 0x20);
        }
        SearchNode prev = null;
        SearchNode node = this.tree;
        boolean wasNextEntry = true;
        for (int i = 0; i < letters.length; ++i) {
            char c = (char)(letters[i] | 0x20);
            while (node != null && node.letter != c) {
                prev = node;
                node = node.nextEntry;
                wasNextEntry = true;
            }
            if (node == null) {
                node = new SearchNode();
                node.letter = c;
                if (wasNextEntry) {
                    prev.nextEntry = node;
                } else {
                    prev.nextLetter = node;
                }
                wasNextEntry = false;
                prev = node;
                node = null;
                continue;
            }
            prev = node;
            node = node.nextLetter;
            wasNextEntry = false;
        }
        prev.replace = replace;
        prev.type = type;
    }

    @Override
    public void clean() {
        this.tree = new SearchNode();
        this.shortestKey = Integer.MAX_VALUE;
    }

    static {
        ScriptSchemaPatcher.addContext(NodeFactory.TAG.view, NodeFactory.TAG.table);
        ScriptSchemaPatcher.addContext(NodeFactory.TAG.function, NodeFactory.TAG.table);
        ScriptSchemaPatcher.addContext(NodeFactory.TAG.procedure, NodeFactory.TAG.table);
        ScriptSchemaPatcher.addContext(NodeFactory.TAG.trigger, NodeFactory.TAG.table);
        ScriptSchemaPatcher.addContext(NodeFactory.TAG.condition, NodeFactory.TAG.table, NodeFactory.TAG.view, NodeFactory.TAG.trigger);
    }

    private static class SQLIterator
    extends BreakIterator {
        private CharacterIterator it;
        private static final char[] BREAK_CHARS = new char[]{'\n', '\r', '\t', '.', '`', '\"', '\'', ' ', '(', ')', ','};
        private boolean wasBreak = false;

        private SQLIterator() {
        }

        private boolean isBreak(char c) {
            boolean isBreak = Arrays.binarySearch(BREAK_CHARS, c) >= 0;
            boolean result = isBreak && !this.wasBreak || !isBreak && this.wasBreak;
            this.wasBreak = isBreak;
            return result;
        }

        @Override
        public int current() {
            return this.it.getIndex();
        }

        @Override
        public int first() {
            this.it.setIndex(this.it.getBeginIndex());
            return this.current();
        }

        @Override
        public int following(int offset) {
            this.it.setIndex(offset);
            return this.next();
        }

        @Override
        public CharacterIterator getText() {
            return this.it;
        }

        @Override
        public int last() {
            this.it.setIndex(this.it.getEndIndex());
            return this.current();
        }

        @Override
        public int next() {
            char c;
            while ((c = this.it.next()) != '\uffff' && !this.isBreak(c)) {
            }
            return c == '\uffff' ? -1 : this.it.getIndex();
        }

        @Override
        public int next(int n) {
            boolean forward = n >= 0;
            for (int i = 0; i < Math.abs(n); ++i) {
                if (forward) {
                    this.next();
                    continue;
                }
                this.previous();
            }
            return this.current();
        }

        @Override
        public int previous() {
            char c;
            while ((c = this.it.previous()) != '\uffff' && !this.isBreak(c)) {
            }
            return this.it.getIndex();
        }

        @Override
        public void setText(CharacterIterator newText) {
            this.it = newText;
        }

        static {
            Arrays.sort(BREAK_CHARS);
        }
    }

    private static class SearchNode {
        private String replace;
        private char letter;
        private NodeFactory.TAG type;
        private SearchNode nextLetter;
        private SearchNode nextEntry;

        private SearchNode() {
        }
    }
}

