/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.model;

import com.inet.dbupdater.model.IModelWriter;
import com.inet.dbupdater.model.Node;
import java.io.StringWriter;
import java.util.Stack;

public class ModelWriterString
implements IModelWriter {
    private StringWriter out = new StringWriter();
    private Node model;
    private Stack<String> elementStack;
    private boolean isMonolithic;
    private boolean wasClosed = true;

    public ModelWriterString(Node model) {
        this.model = model;
    }

    public String run() {
        this.elementStack = new Stack();
        this.model.write(this);
        return this.out.toString();
    }

    @Override
    public void closeNode() {
        this.checkClose();
        String name = this.elementStack.pop();
        if (this.isMonolithic) {
            this.out.write("/>\n");
        } else {
            this.out.write("</" + name + ">\n");
        }
        this.isMonolithic = false;
    }

    @Override
    public void openNode(String name, boolean isMonolithic) {
        this.checkClose();
        this.elementStack.push(name);
        this.out.write("<" + name);
        this.wasClosed = isMonolithic;
        this.isMonolithic = isMonolithic;
    }

    @Override
    public void writeContent(String content) {
        if (content != null) {
            this.checkClose();
            this.out.write(content);
        }
    }

    private void checkClose() {
        if (!this.wasClosed) {
            this.out.write(">\n");
            this.wasClosed = true;
        }
    }

    @Override
    public void writeParameter(String name, String value) {
        this.out.write(" ");
        this.out.write(name);
        if (value != null) {
            this.out.write("=\"");
            this.out.write(value);
            this.out.write("\"");
        }
    }
}

