/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.model;

import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;

public class Constructor {
    private NodeFactory factory;
    private Node currentNode = null;
    private Node root = null;

    public Constructor(NodeFactory factory) {
        this.factory = factory;
    }

    public void startElement(String elementName) {
        if (this.currentNode == null) {
            this.currentNode = this.factory.createNode(elementName);
            if (this.root == null && this.currentNode != null) {
                this.root = this.currentNode;
            }
        } else {
            Node newNode = this.factory.createNode(elementName);
            if (newNode != null) {
                this.currentNode.addChild(newNode);
                this.currentNode = newNode;
            }
        }
    }

    public void setParameterToCurrentElement(Object name, String value) {
        if (this.currentNode == null) {
            throw new IllegalStateException("Cannot set parameters. No current node is set.");
        }
        if (name instanceof String) {
            this.currentNode.readParameter((String)name, value);
        } else {
            this.currentNode.readParameter(name != null ? name.toString() : null, value);
        }
    }

    public void addText(String string) {
        if (this.currentNode == null) {
            throw new IllegalStateException("Cannot set parameters. No current node is set.");
        }
        this.currentNode.readString(string);
    }

    public void endCurrentElement(String elementName) {
        if (this.currentNode != null) {
            if (elementName != null && !this.currentNode.getName().toString().equalsIgnoreCase(elementName)) {
                throw new IllegalStateException("Closing tag '" + elementName + "' does not match the current element of type '" + this.currentNode.getName() + "'");
            }
            this.currentNode = this.currentNode.getParent();
        }
    }

    public void closeUpToLevel(NodeFactory.TAG targetlevel) {
        if (this.currentNode == null) {
            return;
        }
        for (Node slider = this.currentNode; slider != null; slider = slider.getParent()) {
            if (slider.getName() != targetlevel) continue;
            this.currentNode = slider;
            break;
        }
    }

    public Node getRoot() {
        return this.root;
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }
}

