/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.jobrunner;

import com.inet.dbupdater.IEventDispatchable;
import com.inet.dbupdater.UpdaterEvent;
import com.inet.dbupdater.UpdaterEventDispatcher;
import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.i18n.DbUpdaterLocalizedParameter;
import com.inet.dbupdater.jobrunner.JobStructure;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class JobRunner {
    private static Logger logger = LogManager.getLogger((String)"DB Updater");
    private List<IDatabaseCommand.TIME> retryPoints = new ArrayList<IDatabaseCommand.TIME>();
    private IDatabaseCommand.TIME stopAt = null;
    private UpdaterEventDispatcher dispatcher;
    private List<Exception> catchedExceptions = new ArrayList<Exception>();
    private final DatabaseInfos dbToUpdate;

    public JobRunner(DatabaseInfos dbToUpdate) {
        this.dbToUpdate = dbToUpdate;
        this.retryPoints.add(IDatabaseCommand.TIME.createdata);
        this.retryPoints.add(IDatabaseCommand.TIME.copydata);
        this.retryPoints.add(IDatabaseCommand.TIME.createroutines);
        this.retryPoints.add(IDatabaseCommand.TIME.finalize);
    }

    public boolean runJobs(JobStructure jobs) {
        this.stopAt = null;
        return this.runJobs(jobs, false) == 0;
    }

    public boolean runJobs(JobStructure jobs, IDatabaseCommand.TIME stopAt, UpdaterEventDispatcher dispatcher) {
        this.stopAt = stopAt;
        this.dispatcher = dispatcher;
        return this.runJobs(jobs, false) == 0;
    }

    private int runJobs(JobStructure jobs, boolean isRetry) {
        int successTotal = 0;
        int failTotal = 0;
        int retrysPassed = 0;
        if (!isRetry && this.dispatcher != null) {
            this.dispatcher.setJobCount(this.dispatcher.getJobCount() + jobs.totalSize(this.stopAt));
        }
        JobStructure retry = new JobStructure();
        for (IDatabaseCommand.TIME executionTime : IDatabaseCommand.TIME.values()) {
            boolean isRetryPoint = false;
            if (this.retryPoints.contains((Object)executionTime)) {
                ++retrysPassed;
                isRetryPoint = true;
                if (!isRetry && retry.totalSize(this.stopAt) > 0) {
                    logger.info((Object)"Retrying failed jobs");
                    int failed = this.runJobs(retry, true);
                    failTotal += failed;
                    successTotal += retry.totalSize(this.stopAt) - failed;
                    retry = new JobStructure();
                }
            }
            if (executionTime == this.stopAt) break;
            if (executionTime == IDatabaseCommand.TIME.alterstructure) {
                try {
                    this.dbToUpdate.prepareAlter();
                }
                catch (SQLException e) {
                    logger.warn((Object)("Prepare alter failed: " + e.getMessage()));
                }
            }
            boolean printErrors = retrysPassed > this.retryPoints.size() || isRetry || isRetryPoint;
            List<IComposedCommand> jobGroup = jobs.get(executionTime);
            if (jobGroup != null) {
                jobGroup = jobGroup.stream().filter(j -> !j.isFutile()).collect(Collectors.toList());
            }
            int jobCount = jobGroup != null ? jobGroup.size() : 0;
            logger.info((Object)("Running " + jobCount + " job" + (jobCount != 1 ? "s" : "") + " for execution time " + executionTime));
            if (jobGroup == null || jobCount <= 0) continue;
            int success = 0;
            int fail = 0;
            for (IComposedCommand job : jobGroup) {
                try {
                    if (this.dispatcher != null) {
                        this.dispatcher.notifyListeners(new UpdaterEvent(this.dispatcher.getCurrentJob() + 1, "runningJob", new DbUpdaterLocalizedParameter("executionTime." + executionTime)));
                    }
                    if (job instanceof IEventDispatchable) {
                        ((IEventDispatchable)((Object)job)).setDispatcher(this.dispatcher);
                    }
                    if (job.execute() < 0) {
                        if (printErrors || IDatabaseCommand.TIME.init.equals((Object)job.getEvaluationTime()) || IDatabaseCommand.TIME.addstructure.equals((Object)job.getEvaluationTime())) {
                            logger.error((Object)("Execution of command '" + job + "' failed."));
                            ++failTotal;
                        }
                        ++fail;
                        if (!(isRetry || isRetryPoint || IDatabaseCommand.TIME.init.equals((Object)job.getEvaluationTime()) || IDatabaseCommand.TIME.addstructure.equals((Object)job.getEvaluationTime()))) {
                            retry.add(job);
                        }
                        if (!IDatabaseCommand.TIME.init.equals((Object)job.getEvaluationTime()) && !IDatabaseCommand.TIME.addstructure.equals((Object)job.getEvaluationTime())) continue;
                        return fail + failTotal;
                    }
                    ++success;
                }
                catch (SQLException e) {
                    if (printErrors || IDatabaseCommand.TIME.init.equals((Object)job.getEvaluationTime()) || IDatabaseCommand.TIME.addstructure.equals((Object)job.getEvaluationTime())) {
                        logger.error((Object)"Runner got Exception");
                        logger.error((Object)e);
                        logger.error((Object)("Execution of command '" + job + "' failed."));
                        ++failTotal;
                    }
                    ++fail;
                    if (!(isRetry || isRetryPoint || IDatabaseCommand.TIME.init.equals((Object)job.getEvaluationTime()) || IDatabaseCommand.TIME.addstructure.equals((Object)job.getEvaluationTime()))) {
                        retry.add(job);
                    } else {
                        this.catchedExceptions.add(e);
                    }
                    if (!IDatabaseCommand.TIME.init.equals((Object)job.getEvaluationTime()) && !IDatabaseCommand.TIME.addstructure.equals((Object)job.getEvaluationTime())) continue;
                    return fail + failTotal;
                }
            }
            successTotal += success;
            logger.info((Object)("Successful " + success + ", failed " + fail));
        }
        failTotal += retry.totalSize(this.stopAt);
        if (!isRetry) {
            logger.info((Object)"Overall result of job execution: ");
            logger.info((Object)("Successful " + successTotal + ", failed " + failTotal));
        } else {
            logger.info((Object)("Retry done, summary: Successful " + successTotal + ", failed " + failTotal));
        }
        return failTotal;
    }

    public List<Exception> getCatchedExceptions() {
        return this.catchedExceptions;
    }
}

