/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.model.ISchemaNode;
import com.inet.dbupdater.model.Node;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.sql.SQLException;
import java.util.List;

public class MySQLSetInnoDBCommand
implements IComposedCommand {
    private final DatabaseInfos dbInfo2;
    private final Node tableName;

    public MySQLSetInnoDBCommand(DatabaseInfos dbInfo, Node tableName) {
        this.dbInfo2 = dbInfo;
        this.tableName = tableName;
    }

    @Override
    public int execute() throws SQLException {
        try {
            this.dbInfo2.getDBConnection().executeUpdate("ALTER TABLE " + ((ISchemaNode)((Object)this.tableName)).getSourceName(this.dbInfo2) + " ENGINE = InnoDB");
            return 1;
        }
        catch (SQLException e) {
            Logger logger = LogManager.getLogger((String)"DB Updater");
            logger.error((Object)("Set Engine to INNODB for " + this.tableName + "."));
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public String getSqlStatement() {
        return "ALTER TABLE " + ((ISchemaNode)((Object)this.tableName)).getSourceName(this.dbInfo2) + " ENGINE = InnoDB";
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.addstructure;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        return null;
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        return false;
    }
}

