/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.DefaultCommandSyntax;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.databases.commands.ITableCommand;
import com.inet.dbupdater.model.ISchemaNode;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.sql.SQLException;
import java.util.List;

public class DefaultAlterIndexCommand
implements ITableCommand {
    private DatabaseInfos dbInfo;
    private final Node name;
    private String statement;
    private final DefaultCommandSyntax syntax;

    public DefaultAlterIndexCommand(DatabaseInfos dbInfo, DefaultCommandSyntax syntax, Node tableName) {
        this.syntax = syntax;
        this.name = tableName;
        this.dbInfo = dbInfo;
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.alterstructure;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        String refName = IDatabaseInfos.INDEX_PARAM.index_name.toString();
        this.statement = "";
        if (this.syntax.useTableNameOnDropIndex()) {
            this.statement = "ALTER TABLE " + ((ISchemaNode)((Object)this.name)).getSourceName(this.dbInfo);
        }
        this.statement = this.statement + " DROP " + this.syntax.getDropNameOnDropIndex() + " " + this.dbInfo.getQuote(element.getParameter(refName));
        IComposedCommand command = this.dbInfo.getCommandFactory().getCommand(action, NodeFactory.TAG.index, IDatabaseCommand.TIME.addreferences, this.name, refName);
        return IComposedCommand.createCommandList(command, element, action);
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        return action == ICommandFactory.COMMAND_TYPE.alter && element != null && element.getName() == NodeFactory.TAG.index && "true".equals(element.getParameter(IDatabaseInfos.INDEX_PARAM.isprimarykey.toString()));
    }

    @Override
    public int execute() throws SQLException {
        return this.dbInfo.getDBConnection().executeUpdate(this.getSqlStatement());
    }

    @Override
    public String getSqlStatement() {
        return this.statement;
    }
}

