/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.data;

import com.inet.dbupdater.DBScanner;
import com.inet.dbupdater.UpdaterEventDispatcher;
import com.inet.dbupdater.databases.DatabaseInfoFactory;
import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.dbconnection.DBConnection;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.Parser;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.xml.sax.SAXException;

public class StateDescription {
    private Node model;
    private DBConnection connection;
    private DatabaseInfos connectionInfo;
    private File sourceFile;
    private File targetFile;
    private String tableList;
    private boolean initialized;
    private boolean sourceIsFile = true;
    private String targetDBMS;
    private static final Logger logger = LogManager.getLogger((String)"DB Updater");
    private UpdaterEventDispatcher dispatcher;

    public StateDescription(File sourceFile, String targetDBMS) {
        this.sourceFile = sourceFile;
        this.targetDBMS = targetDBMS;
    }

    public StateDescription(String databaseName, String driver, String user, String password, String connectionURL) {
        this.createConnection(databaseName, driver, user, password, connectionURL, null, null);
        this.sourceIsFile = false;
    }

    public StateDescription(DatabaseInfos dbInfo) {
        this.connectionInfo = dbInfo;
        this.connection = dbInfo.getDBConnection();
        this.sourceIsFile = false;
    }

    public StateDescription(DatabaseInfos dbInfo, File modelFile) {
        this.connectionInfo = dbInfo;
        this.connection = dbInfo.getDBConnection();
        this.sourceFile = modelFile;
        this.sourceIsFile = true;
    }

    public StateDescription(String databaseName, String driver, String jdbcUser, String jdbcPassword, String connectionURL, File sourceFile, String targetDBMS, String accountUser, String accountPassword) {
        this.createConnection(databaseName, driver, jdbcUser, jdbcPassword, connectionURL, accountUser, accountPassword);
        this.sourceFile = sourceFile;
        this.targetDBMS = targetDBMS;
        this.sourceIsFile = sourceFile != null;
    }

    private void createConnection(String databaseName, String driver, String jdbcUser, String jdbcPassword, String connectionURL, String accountUser, String accountPassword) {
        if (connectionURL != null) {
            this.connection = new DBConnection();
            this.connection.setJdbcDriverClass(driver);
            this.connection.setJdbcUrl(connectionURL);
            this.connection.setJdbcUser(jdbcUser);
            this.connection.setJdbcPassword(jdbcPassword);
            this.connection.setDatabaseName(databaseName);
            this.connection.setAccountUser(accountUser);
            this.connection.setAccountPassword(accountPassword);
        }
    }

    public void initialize() throws SAXException, IOException, SQLException {
        this.model = null;
        if (this.connection != null || this.connectionInfo != null) {
            if (this.connection.getConnection() == null) {
                this.connection.openConnection(this.connectionInfo);
            }
            try {
                this.connectionInfo = DatabaseInfoFactory.getDatabaseInfos(DatabaseInfoFactory.getDatabaseType(this.connection.getConnection()), this.connection);
            }
            catch (SQLException e) {
                logger.error((Object)e);
                this.connectionInfo = new DatabaseInfos(this.connection);
            }
        }
        if (this.sourceIsFile) {
            Parser parser = new Parser(this.targetDBMS);
            this.model = parser.parse(this.sourceFile);
        } else {
            DBScanner scanner = new DBScanner(this.dispatcher);
            this.model = scanner.scanStructur(this.connection);
            if (this.tableList != null) {
                for (String tbl : this.tableList.split(",\\s*")) {
                    Node data = scanner.scanDatasets(this.connection, tbl);
                    this.model.addChild(data);
                }
            }
        }
        this.initialized = true;
    }

    public Node getModel() {
        if (!this.initialized) {
            throw new IllegalStateException("The model has to be initialized before retrieving it!");
        }
        return this.model;
    }

    public void setModel(Node model) {
        this.initialized = true;
        this.model = model;
    }

    public DBConnection getConnection() {
        return this.connection;
    }

    public DatabaseInfos getConnectionInfo() {
        return this.connectionInfo;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public void setTargetFile(File targetFile) {
        this.targetFile = targetFile;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void logSettings(Logger logger) {
        if (this.connection != null) {
            logger.debug((Object)("DB URL   : " + this.connection.getJdbcUrl()));
            if (this.connection.getJdbcUser() != null) {
                logger.debug((Object)("DB User  : " + this.connection.getJdbcUser()));
            }
            if (this.connection.getJdbcDriverClass() != null) {
                logger.debug((Object)("DB Driver: " + this.connection.getJdbcDriverClass()));
            }
        }
        if (this.sourceFile != null) {
            logger.debug((Object)("SRC XML  : " + this.sourceFile));
        }
        if (this.targetFile != null) {
            logger.debug((Object)("TargetXML: " + this.connection.getJdbcUser()));
        }
    }

    public String getTargetDBMS() {
        return this.targetDBMS;
    }

    public void setTableList(String tableList) {
        this.tableList = tableList;
    }

    public void setEventDispatcher(UpdaterEventDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }
}

