/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jj.srv;

import com.inet.jj.srv.PoolConnection;
import com.inet.jj.srv.PoolEntry;
import com.inet.jj.srv.Timeout;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

class PoolManager {
    private Method isValid;
    private Vector poolDS = new Vector();
    Vector poolEntryList = new Vector();
    private Hashtable poolDrivers = new Hashtable();
    long poolTimeout = 600000L;
    private int maxConCount = 0;
    private long loginTimeout = 10000L;
    final Object waitForFreeCon = new Object();
    private Timeout thread = new Timeout(this);
    int conCount;
    static /* synthetic */ Class class$java$sql$Connection;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$sql$Driver;

    PoolManager() {
        try {
            this.isValid = (class$java$sql$Connection != null ? class$java$sql$Connection : (class$java$sql$Connection = PoolManager.class$("java.sql.Connection"))).getMethod("isValid", Integer.TYPE);
        }
        catch (Throwable throwable) {}
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    void close(String string) {
        PoolManager poolManager = this;
        synchronized (poolManager) {
            int n = 0;
            while (n < this.poolDS.size()) {
                if (this.poolDS.elementAt(n).equals(string)) {
                    Vector vector = (Vector)this.poolEntryList.elementAt(n);
                    this.poolDS.remove(n);
                    this.poolEntryList.remove(n);
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        PoolEntry poolEntry = (PoolEntry)vector.elementAt(n2);
                        poolEntry.close();
                        ++n2;
                    }
                    break;
                }
                ++n;
            }
        }
    }

    Connection getConnection(String string, String string2, Properties properties, String string3, ClassLoader classLoader) throws SQLException {
        Object object;
        Object object2;
        Vector vector;
        block34: {
            vector = null;
            try {
                if (string == null) {
                    object2 = null;
                    if (classLoader != null) {
                        object = Class.forName("java.util.ServiceLoader");
                        Method method = ((Class)object).getMethod("load", class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = PoolManager.class$("java.lang.Class")), class$java$lang$ClassLoader != null ? class$java$lang$ClassLoader : (class$java$lang$ClassLoader = PoolManager.class$("java.lang.ClassLoader")));
                        Object object3 = method.invoke(null, class$java$sql$Driver != null ? class$java$sql$Driver : (class$java$sql$Driver = PoolManager.class$("java.sql.Driver")), classLoader);
                        Iterator iterator = (Iterator)((Class)object).getMethod("iterator", null).invoke(object3, null);
                        while (iterator.hasNext()) {
                            try {
                                Driver driver = (Driver)iterator.next();
                                if (!driver.acceptsURL(string2)) continue;
                                object2 = driver;
                                break;
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    if (object2 == null) {
                        object2 = DriverManager.getDriver(string2);
                    }
                    string = object2.getClass().getName();
                    this.poolDrivers.put(string, object2);
                    ((Hashtable)properties).put("driver", string);
                    break block34;
                }
                object = this;
                synchronized (object) {
                    object2 = (Driver)this.poolDrivers.get(string);
                    if (object2 == null) {
                        object2 = (Driver)Class.forName(string).newInstance();
                        this.poolDrivers.put(string, object2);
                    }
                }
            }
            catch (Exception exception) {
                throw new SQLException("[JJServer] Can't load driver: " + string + " for this URL: " + string2 + " - " + exception, "08001");
            }
        }
        object = this;
        synchronized (object) {
            int n = 0;
            while (n < this.poolDS.size()) {
                if (this.poolDS.elementAt(n).equals(string3)) {
                    vector = (Vector)this.poolEntryList.elementAt(n);
                    break;
                }
                ++n;
            }
            if (vector == null) {
                vector = new Vector();
                this.poolDS.addElement(string3);
                this.poolEntryList.addElement(vector);
            }
        }
        Connection connection = this.searchForFreeCon(vector);
        if (connection != null) {
            return connection;
        }
        object = new PoolEntry(this);
        if (this.maxConCount != 0) {
            int n;
            Vector vector2 = vector;
            synchronized (vector2) {
                n = vector.size();
            }
            if (this.maxConCount <= n) {
                long l = System.currentTimeMillis();
                long l2 = 0L;
                Object object4 = this.waitForFreeCon;
                synchronized (object4) {
                    while ((l2 < this.loginTimeout || this.loginTimeout == 0L) && this.maxConCount != 0 && this.maxConCount <= vector.size()) {
                        try {
                            this.waitForFreeCon.wait(this.loginTimeout == 0L ? 0L : this.loginTimeout - l2);
                        }
                        catch (InterruptedException interruptedException) {}
                        connection = this.searchForFreeCon(vector);
                        if (connection != null) {
                            Connection connection2 = connection;
                            Object var17_23 = null;
                            return connection2;
                        }
                        l2 = System.currentTimeMillis() - l;
                    }
                }
            }
            if (this.maxConCount != 0 && this.maxConCount <= vector.size()) {
                throw new SQLException("[JJServer] All connections(" + this.maxConCount + ") in use. Login timeout " + this.loginTimeout / 1000L + " s.", "08002");
            }
        }
        try {
            vector.addElement(object);
            return ((PoolEntry)object).init((Driver)object2, string2, properties);
        }
        catch (SQLException sQLException) {
            vector.removeElement(object);
            throw sQLException;
        }
    }

    int getFreeConCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.poolEntryList.size()) {
            Vector vector = (Vector)this.poolEntryList.elementAt(n2);
            int n3 = 0;
            while (n3 < vector.size()) {
                if (!((PoolEntry)vector.elementAt((int)n3)).isUsing) {
                    ++n;
                }
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    int getLoginTimeout() {
        return (int)(this.loginTimeout / 1000L);
    }

    int getMaxConnectionCount() {
        return this.maxConCount;
    }

    int getPoolTimeout() {
        return (int)(this.poolTimeout / 1000L);
    }

    private Connection searchForFreeCon(Vector vector) throws SQLException {
        Connection connection = null;
        int n = 0;
        while (n < vector.size()) {
            block20: {
                PoolEntry poolEntry;
                Boolean bl;
                Object object = vector;
                synchronized (object) {
                    if (n >= vector.size()) {
                        bl = null;
                        break;
                    }
                    poolEntry = (PoolEntry)vector.elementAt(n);
                }
                if (!poolEntry.isUsing) {
                    object = this;
                    synchronized (object) {
                        if (poolEntry.isUsing) {
                            bl = null;
                            break block20;
                        }
                        poolEntry.isUsing = true;
                        poolEntry.lastUse = System.currentTimeMillis();
                    }
                    if (poolEntry.c == null) {
                        vector.removeElement(poolEntry);
                        --n;
                    } else {
                        connection = poolEntry.c;
                        boolean bl2 = true;
                        try {
                            try {
                                bl = (Boolean)this.isValid.invoke((Object)connection, new Integer(5));
                                bl2 = bl ^ true;
                            }
                            catch (Exception exception) {
                                bl2 = connection.isClosed();
                            }
                        }
                        catch (Throwable throwable) {}
                        if (bl2) {
                            try {
                                poolEntry.close();
                            }
                            catch (Throwable throwable) {}
                            vector.removeElement(poolEntry);
                            connection = null;
                        } else {
                            return new PoolConnection(connection, poolEntry);
                        }
                    }
                }
            }
            ++n;
        }
        return null;
    }

    void setLoginTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative login timeout value " + n);
        }
        this.loginTimeout = (long)n * 1000L;
    }

    void setMaxConnectionCount(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative maximum connection count value " + n);
        }
        this.maxConCount = n;
    }

    synchronized void setPoolTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative timeout value " + n);
        }
        long l = this.poolTimeout;
        this.poolTimeout = (long)n * 1000L;
        if (l == 0L && n != 0) {
            this.thread = new Timeout(this);
        }
    }
}

