/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jj.srv;

import com.inet.jj.srv.PoolEntry;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;

public class PoolConnection
implements Connection {
    private Connection con;
    private PoolEntry pe;

    PoolConnection(Connection connection, PoolEntry poolEntry) {
        this.con = connection;
        this.pe = poolEntry;
    }

    public void clearWarnings() throws SQLException {
        this.t();
        this.con.clearWarnings();
    }

    public void close() throws SQLException {
        if (this.con != null) {
            if (!this.con.getAutoCommit()) {
                this.con = null;
                this.pe.close();
                this.pe = null;
                new SQLException("Not completed transaction. Rollback occur.").printStackTrace();
            } else {
                this.con = null;
                this.pe.connectionClosed();
                this.pe = null;
            }
        }
    }

    public void commit() throws SQLException {
        this.t();
        this.con.commit();
    }

    public Statement createStatement() throws SQLException {
        this.t();
        return this.con.createStatement();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.t();
        return this.con.createStatement(n, n2);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public boolean getAutoCommit() throws SQLException {
        this.t();
        return this.con.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        this.t();
        return this.con.getCatalog();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.t();
        return this.con.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        this.t();
        return this.con.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        this.t();
        return this.con.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.t();
        return this.con.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        Connection connection = this.con;
        if (connection == null) {
            return true;
        }
        boolean bl = connection.isClosed();
        if (bl) {
            this.close();
        }
        return bl;
    }

    public boolean isReadOnly() throws SQLException {
        this.t();
        return this.con.isReadOnly();
    }

    public String nativeSQL(String string) throws SQLException {
        this.t();
        return this.con.nativeSQL(string);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.t();
        return this.con.prepareCall(string);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.t();
        return this.con.prepareCall(string, n, n2);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.t();
        return this.con.prepareStatement(string);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.t();
        return this.con.prepareStatement(string, n, n2);
    }

    public void rollback() throws SQLException {
        this.t();
        this.con.rollback();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.t();
        this.con.setAutoCommit(bl);
    }

    public void setCatalog(String string) throws SQLException {
        this.t();
        this.con.setCatalog(string);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.t();
        this.con.setReadOnly(bl);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.t();
        this.con.setTransactionIsolation(n);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.t();
        this.con.setTypeMap(map);
    }

    void t() throws SQLException {
        if (this.con == null) {
            throw new SQLException("Connection has already been closed.", "08S01");
        }
    }
}

