/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jj.srv;

import com.inet.jj.srv.ClientObserver;
import com.inet.jj.srv.JJHashtable;
import com.inet.jj.srv.JavaCommandFactory;
import com.inet.jj.srv.PoolManager;
import com.inet.jj.srv.QueryTracker;
import com.inet.jj.srv.QueryTrackerImpl;
import com.inet.jj.srv.Response;
import com.inet.jj.srv.Session;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class JJServer
implements Runnable {
    private static final String LICENSE = "Application license.";
    private static final Date licDate = null;
    private static final String licMsg = null;
    static final int MAX_CON = 0;
    public static final int LOG_FATAL = 0;
    public static final int LOG_WARNING = 1;
    public static final int LOG_INFO = 2;
    public static final int LOG_DEBUG = 3;
    static final JJHashtable session_table = new JJHashtable();
    private final int port;
    private final ClassLoader loader;
    private ServerSocket ss;
    private boolean isClosed;
    int timeout = 900000;
    private PrintStream debug_writer = System.out;
    private int logLevel = 1;
    private Hashtable uds;
    PoolManager pm = new PoolManager();
    private Hashtable commands;
    Hashtable prepared_commands;
    private boolean onlyCmd;
    private boolean lobToStream;
    private static final String APP_NAME = "i-net KONNEKTER(server) 2.24";
    static int conCounter;
    private ClientObserver observer;
    private QueryTracker queryTracker = new QueryTracker();

    public JJServer() {
        this(9876, null);
    }

    public JJServer(int n) {
        this(n, null);
    }

    public JJServer(int n, ClassLoader classLoader) {
        this.port = n;
        this.loader = classLoader;
    }

    public Object addCommand(String string, JavaCommandFactory javaCommandFactory) {
        if (this.commands == null) {
            this.commands = new Hashtable();
            this.prepared_commands = new Hashtable();
        }
        return this.commands.put(string.toLowerCase(), javaCommandFactory);
    }

    public Object addCommand(String string, String string2) {
        if (this.commands == null) {
            this.commands = new Hashtable();
            this.prepared_commands = new Hashtable();
        }
        return this.commands.put(string.toLowerCase(), string2);
    }

    public Properties addUDS(String string, String string2, String string3) {
        return this.addUDS(string, string2, string3, null);
    }

    public Properties addUDS(String string, String string2, String string3, String string4, String string5) {
        Properties properties = new Properties();
        ((Hashtable)properties).put("user", string4);
        ((Hashtable)properties).put("password", string5);
        return this.addUDS(string, string2, string3, properties);
    }

    public Properties addUDS(String string, String string2, String string3, Properties properties) {
        if (this.uds == null) {
            this.uds = new Hashtable();
        }
        if (properties == null) {
            properties = new Properties();
        }
        if (string2 != null) {
            ((Hashtable)properties).put("driver", string2);
        }
        ((Hashtable)properties).put("url", string3);
        this.pm.close(string);
        return this.uds.put(string.toLowerCase(), properties);
    }

    static synchronized void conCount(boolean bl) {
        conCounter = bl ? ++conCounter : --conCounter;
    }

    final void debug(Object object) {
        if (this.isDebug()) {
            this.writeLog(object);
        }
    }

    String errorToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        stringWriter.flush();
        return stringWriter.toString();
    }

    final void fatal(Object object) {
        if (this.debug_writer == null) {
            this.writeLog(object, System.out);
        } else {
            this.writeLog(object, this.debug_writer);
        }
    }

    public Object getCommand(String string) {
        if (this.commands != null) {
            return this.commands.get(string.toLowerCase());
        }
        return null;
    }

    public int getConnectedClientCount() {
        return session_table.size();
    }

    public Vector getConnectedHostNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = session_table.elements();
        while (enumeration.hasMoreElements()) {
            Session session = (Session)enumeration.nextElement();
            if (session.getClientHostName() == null || vector.indexOf(session.getClientHostName(), 0) != -1) continue;
            vector.add(session.getClientHostName());
        }
        return vector;
    }

    public Vector getConnectedHostNames(String string) {
        Vector<String> vector = new Vector<String>();
        string = string.toLowerCase();
        Enumeration enumeration = session_table.elements();
        while (enumeration.hasMoreElements()) {
            Session session = (Session)enumeration.nextElement();
            if (session.clientUrl == null || !session.clientUrl.equals(string) || vector.indexOf(session.getClientHostName(), 0) != -1) continue;
            vector.add(session.getClientHostName());
        }
        return vector;
    }

    public Connection getConnection(String string) throws SQLException {
        Properties properties = this.getUDS(string);
        if (properties == null) {
            throw new SQLException("[JJServer] User data source '" + string + "' not found.", "IM002");
        }
        return this.pm.getConnection(properties.getProperty("driver"), properties.getProperty("url"), properties, string, this.loader);
    }

    public Vector getCurrentExecutingCommands() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = session_table.elements();
        while (enumeration.hasMoreElements()) {
            String string = ((Session)enumeration.nextElement()).current_cmd;
            if (string == null) continue;
            vector.add(string);
        }
        return vector;
    }

    public Vector getCurrentExecutingCommands(String string) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = session_table.elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            Session session = (Session)enumeration.nextElement();
            if (!string.equals(session.getClientHostName()) || (string2 = session.current_cmd) == null) continue;
            vector.add(string2);
        }
        return vector;
    }

    public int getDBConnectionCount() {
        return this.pm.conCount;
    }

    public int getDBConnectionCount(String string) {
        int n = 0;
        Enumeration enumeration = session_table.elements();
        while (enumeration.hasMoreElements()) {
            if (!string.equalsIgnoreCase(((Session)enumeration.nextElement()).getClientHostName())) continue;
            ++n;
        }
        return n;
    }

    public int getDBFreeConnectionCount() {
        return this.pm.getFreeConCount();
    }

    public int getInactiveTimeout() {
        return this.timeout / 1000;
    }

    public long getInitialTime(String string) {
        Enumeration enumeration = session_table.elements();
        while (enumeration.hasMoreElements()) {
            Session session = (Session)enumeration.nextElement();
            if (!string.equals(session.getClientHostName())) continue;
            return session.iniTime;
        }
        return 0L;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public PrintStream getLogStream() {
        return this.debug_writer;
    }

    public int getMaxConnectionCount() {
        return this.pm.getMaxConnectionCount();
    }

    public boolean getOnlyCommandMode() {
        return this.onlyCmd;
    }

    public int getOpenCallableStatementCount() {
        int n = 0;
        Enumeration enumeration = session_table.elements();
        while (enumeration.hasMoreElements()) {
            n += ((Session)enumeration.nextElement()).cstCount;
        }
        return n;
    }

    public int getOpenCallableStatementCount(String string) {
        int n = 0;
        Enumeration enumeration = session_table.elements();
        while (enumeration.hasMoreElements()) {
            Session session = (Session)enumeration.nextElement();
            if (!string.equals(session.getClientHostName())) continue;
            n += session.cstCount;
        }
        return n;
    }

    public int getOpenJavaCommandCount() {
        int n = 0;
        Enumeration enumeration = session_table.elements();
        while (enumeration.hasMoreElements()) {
            n += ((Session)enumeration.nextElement()).jcCount;
        }
        return n;
    }

    public int getOpenJavaCommandCount(String string) {
        int n = 0;
        Enumeration enumeration = session_table.elements();
        while (enumeration.hasMoreElements()) {
            Session session = (Session)enumeration.nextElement();
            if (!string.equals(session.getClientHostName())) continue;
            n += session.jcCount;
        }
        return n;
    }

    public int getOpenPreparedStatementCount() {
        int n = 0;
        Enumeration enumeration = session_table.elements();
        while (enumeration.hasMoreElements()) {
            n += ((Session)enumeration.nextElement()).pstCount;
        }
        return n;
    }

    public int getOpenPreparedStatementCount(String string) {
        int n = 0;
        Enumeration enumeration = session_table.elements();
        while (enumeration.hasMoreElements()) {
            Session session = (Session)enumeration.nextElement();
            if (!string.equals(session.getClientHostName())) continue;
            n += session.pstCount;
        }
        return n;
    }

    public int getOpenResultSetCount() {
        int n = 0;
        Enumeration enumeration = session_table.elements();
        while (enumeration.hasMoreElements()) {
            n += ((Session)enumeration.nextElement()).rsCount;
        }
        return n;
    }

    public int getOpenResultSetCount(String string) {
        int n = 0;
        Enumeration enumeration = session_table.elements();
        while (enumeration.hasMoreElements()) {
            Session session = (Session)enumeration.nextElement();
            if (!string.equals(session.getClientHostName())) continue;
            n += session.rsCount;
        }
        return n;
    }

    public int getOpenStatementCount() {
        int n = 0;
        Enumeration enumeration = session_table.elements();
        while (enumeration.hasMoreElements()) {
            n += ((Session)enumeration.nextElement()).stCount;
        }
        return n;
    }

    public int getOpenStatementCount(String string) {
        int n = 0;
        Enumeration enumeration = session_table.elements();
        while (enumeration.hasMoreElements()) {
            Session session = (Session)enumeration.nextElement();
            if (!string.equals(session.getClientHostName())) continue;
            n += session.stCount;
        }
        return n;
    }

    public Vector getOpenedCommands() {
        Vector vector = new Vector();
        Enumeration enumeration = session_table.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = ((Session)enumeration.nextElement()).openedCommands;
            if (hashtable == null) continue;
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                vector.add(enumeration2.nextElement());
            }
        }
        return vector;
    }

    public Vector getOpenedCommands(String string) {
        Vector vector = new Vector();
        Enumeration enumeration = session_table.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable;
            Session session = (Session)enumeration.nextElement();
            if (!string.equals(session.getClientHostName()) || (hashtable = session.openedCommands) == null) continue;
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                vector.add(enumeration2.nextElement());
            }
        }
        return vector;
    }

    public int getPoolLoginTimeout() {
        return this.pm.getLoginTimeout();
    }

    public int getPoolTimeout() {
        return this.pm.getPoolTimeout();
    }

    public Map getQueryStatistics() {
        return this.queryTracker.getStatistics();
    }

    QueryTracker getQueryTracker() {
        return this.queryTracker;
    }

    public Properties getUDS(String string) {
        if (this.uds != null) {
            return (Properties)this.uds.get(string.toLowerCase());
        }
        return null;
    }

    final void info(Object object) {
        if (this.isWarning()) {
            this.writeLog(object);
        }
    }

    final boolean isDebug() {
        return this.debug_writer != null && this.logLevel >= 3;
    }

    final boolean isInfo() {
        return this.debug_writer != null && this.logLevel >= 2;
    }

    public boolean isLobToStream() {
        return this.lobToStream;
    }

    final boolean isWarning() {
        return this.debug_writer != null && this.logLevel >= 1;
    }

    String prepareCommand(String string, String string2) {
        if (this.prepared_commands.get(string = string.toLowerCase()) != null) {
            return string2;
        }
        char[] cArray = string2.toCharArray();
        int n = cArray.length;
        char c = '\u0000';
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            char c2 = cArray[n4];
            if (c == '\u0000' || c2 == c) {
                if (c2 == '\"' || c2 == '\'') {
                    c = c == '\u0000' ? c2 : (char)'\u0000';
                } else if (c2 == '%') {
                    if (n2 == 0) {
                        n2 = n4;
                    } else {
                        if (n4 > n2 + 1) {
                            stringBuffer.append(cArray, n3, n2 - n3);
                            stringBuffer.append('?');
                            vector.addElement(new String(cArray, n2 + 1, n4 - n2 - 1));
                            n3 = n4 + 1;
                        }
                        n2 = 0;
                    }
                }
            }
            ++n4;
        }
        if (vector.size() != 0) {
            stringBuffer.append(cArray, n3, n - n3);
            this.prepared_commands.put(string, vector.toArray());
            string2 = stringBuffer.toString();
            this.commands.put(string, string2);
        }
        return string2;
    }

    public void removeAllCommands() {
        if (this.commands != null) {
            this.commands.clear();
            this.commands = null;
            this.prepared_commands.clear();
            this.prepared_commands = null;
        }
    }

    public void removeAllUDS() {
        if (this.uds != null) {
            this.uds.clear();
            this.uds = null;
        }
    }

    public Object removeCommand(String string) {
        if (this.commands == null) {
            return null;
        }
        string = string.toLowerCase();
        this.prepared_commands.remove(string);
        return this.commands.remove(string);
    }

    public Properties removeUDS(String string) {
        if (this.uds == null) {
            return null;
        }
        this.pm.close(string);
        return (Properties)this.uds.remove(string.toLowerCase());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                if (this.isClosed) {
                    return;
                }
                Socket socket = this.ss.accept();
                try {
                    Response response = new Response(socket, this);
                    if (!this.isDebug()) continue;
                    this.debug("Socket to '" + response.getClientHostNameDebug() + "' accepted.");
                }
                catch (Throwable throwable) {
                    this.fatal(throwable);
                }
            }
        }
        catch (Throwable throwable) {
            if (this.isClosed) return;
            this.fatal(throwable);
            this.stop();
        }
    }

    public void setEnableQueryStatistics(boolean bl) {
        if (bl) {
            try {
                this.queryTracker = new QueryTrackerImpl();
            }
            catch (Throwable throwable) {}
        } else {
            this.queryTracker = new QueryTracker();
        }
    }

    public void setInactiveTimeout(int n) {
        this.timeout = n * 1000;
    }

    public void setLobToStream(boolean bl) {
        this.lobToStream = bl;
    }

    public void setLogLevel(int n) {
        this.logLevel = n;
    }

    public void setLogStream(PrintStream printStream) {
        this.debug_writer = printStream;
    }

    public void setMaxConnectionCount(int n) {
        this.pm.setMaxConnectionCount(n);
    }

    public void setOnlyCommandMode(boolean bl) {
        this.onlyCmd = bl;
    }

    public void setPoolLoginTimeout(int n) {
        this.pm.setLoginTimeout(n);
    }

    public void setPoolTimeout(int n) {
        this.pm.setPoolTimeout(n);
    }

    public void start() throws Exception {
        block7: {
            try {
                if (null != null && new Date().after(null)) {
                    throw new RuntimeException(APP_NAME + null);
                }
                this.ss = new ServerSocket(this.port);
                this.isClosed = false;
                Thread thread = new Thread((Runnable)this, "Konnekter server");
                thread.setPriority(5);
                thread.start();
                this.fatal("i-net KONNEKTER(server) 2.24 started... ");
                if (!this.isInfo()) break block7;
                try {
                    this.info(LICENSE);
                    this.info(new Date());
                    try {
                        this.info("java.vendor = " + System.getProperty("java.vendor"));
                    }
                    catch (Exception exception) {}
                    this.info("java.version = " + System.getProperty("java.version"));
                    this.info("os.name = " + System.getProperty("os.name"));
                    this.info("os.arch = " + System.getProperty("os.arch"));
                    this.info("os.version = " + System.getProperty("os.version"));
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                this.warning(exception);
                throw exception;
            }
        }
        this.observer = new ClientObserver(this);
    }

    public void stop() {
        this.isClosed = true;
        Enumeration enumeration = session_table.elements();
        while (enumeration.hasMoreElements()) {
            ((Session)enumeration.nextElement()).close("Shutdown");
        }
        session_table.clear();
        try {
            this.ss.close();
        }
        catch (Throwable throwable) {}
        this.observer.stop();
        this.fatal("i-net KONNEKTER(server) 2.24 stopped. " + new Date());
    }

    final void warning(Object object) {
        if (this.isWarning()) {
            this.writeLog(object);
        }
    }

    private final void writeLog(Object object) {
        this.writeLog(object, this.debug_writer);
    }

    private final void writeLog(Object object, PrintStream printStream) {
        if (printStream == null) {
            return;
        }
        try {
            printStream.print(new Timestamp(System.currentTimeMillis()));
            printStream.print(' ');
            if (object instanceof Throwable) {
                ((Throwable)object).printStackTrace(printStream);
            } else {
                printStream.println(object);
            }
            printStream.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

