/*
 * Decompiled with CFR 0.152.
 */
package srv.orderlistcache;

import com.inet.cache.MemoryStoreMap;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.HelpDeskServerException;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.utils.DatabaseTransactionUtils;
import com.inet.helpdesk.shared.rpc.QueryParameter;
import com.inet.jj.srv.JavaCommand;
import com.inet.jj.srv.JavaCommandFactory;
import com.inet.logging.LogManager;
import com.inet.plugin.ServerPluginManager;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.SuppressFBWarnings;
import srv.ServerUtilities;
import srv.controller.ticket.Auftrag;
import srv.orderlistcache.CachedResultSet;
import srv.orderlistcache.CachedResultSetMetaData;
import srv.orderlistcache.OrderListCommand;
import srv.orderlistcache.cache.QueryCache;
import srv.orderlistcache.cache.QueryCacheKey;

public class OrderListCommandFactory
extends JavaCommandFactory {
    private static String query;
    private String commandName;
    private QueryCache cache;
    private MemoryStoreMap<QueryCacheKey, CachedResultSet> storeMap;

    public OrderListCommandFactory(String name, String sql) {
        this.commandName = name;
        this.initCache(sql);
    }

    private void initCache(String query) {
        this.storeMap = new MemoryStoreMap();
        this.storeMap.setTimeout(30, false);
        this.cache = new QueryCache((Map<QueryCacheKey, CachedResultSet>)this.storeMap, new OrderLoader(query));
    }

    public void resetQuery(String sql) {
        if (!sql.equals(query)) {
            this.initCache(sql);
        }
    }

    public JavaCommand prepareCommand(Connection con) throws SQLException {
        return new OrderListCommand(this.cache, this.commandName);
    }

    public JavaCommand prepareCommand(Connection con, int rsType, int rsConcur) throws SQLException {
        return new OrderListCommand(this.cache, this.commandName);
    }

    public void wipeCacheFor(Auftrag auftrag) {
        Iterator keys = this.storeMap.keySet().iterator();
        block0: while (keys.hasNext()) {
            QueryCacheKey key = (QueryCacheKey)keys.next();
            QueryCacheKey.Parameter[] params = key.getParameters();
            if (params == null || params.length == 0) {
                keys.remove();
                continue;
            }
            for (QueryCacheKey.Parameter p : params) {
                FieldVO attribute;
                if (p.getValues() == null || p.getValues().length == 0) continue;
                Auftrag.Field field = p.getKeyField();
                String column = field.getKeyColumn();
                if (column != null && (column.startsWith("BunFeld") || column.equals("UsrID") || column.equals("Status"))) {
                    field = Auftrag.Field.FREI;
                }
                if ((attribute = auftrag.getAttribut(field)) == null) continue block0;
                Object value = p.isNumeric() ? Integer.valueOf(attribute.getId()) : attribute.getDisplayValue();
                boolean anyMatch = false;
                for (Serializable pValue : p.getConvertedValues()) {
                    if (!OrderListCommandFactory.equalValues(value, pValue)) continue;
                    anyMatch = true;
                    break;
                }
                if (!anyMatch) continue block0;
            }
            keys.remove();
        }
    }

    private static boolean equalValues(Object valA, Object valB) {
        if (valA instanceof String && valB instanceof String) {
            return ((String)valA).equalsIgnoreCase((String)valB);
        }
        return valA.equals(valB);
    }

    public static class OrderLoader {
        private AtomicInteger columnCount = new AtomicInteger(-1);
        private String sqlPreToken;
        private String sqlPostToken = "";
        private CachedResultSetMetaData meta;

        private OrderLoader(String sql) {
            int tokenStart = sql.indexOf(37);
            int tokenEnd = sql.lastIndexOf(37);
            if (tokenStart > 0 && tokenStart != tokenEnd) {
                this.sqlPreToken = sql.substring(0, tokenStart);
                if (tokenEnd < sql.length() - 1) {
                    this.sqlPostToken = sql.substring(tokenEnd + 1);
                }
            } else {
                this.sqlPreToken = sql;
            }
        }

        @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Internal API, Query is fixed")
        public CachedResultSet createEntry(QueryCacheKey key) throws SQLException {
            List result;
            if (key == null) {
                throw new IllegalArgumentException("OrderLoader cannot be used for a null key");
            }
            String paramString = QueryParameter.convertToWherePart(ServerUtilities.sqlUtilities, key.getParameters());
            String query = this.sqlPreToken + paramString + this.sqlPostToken;
            long start = System.currentTimeMillis();
            try {
                result = DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> {
                    ArrayList<Object[]> data = null;
                    ResultSet rs = null;
                    Statement st = null;
                    Connection con = null;
                    try {
                        con = ((ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class)).getConnection();
                        st = con.createStatement();
                        st.setQueryTimeout(25);
                        rs = st.executeQuery(query);
                        if (this.meta == null) {
                            this.createMetaData(rs);
                        }
                        if (this.columnCount.get() < 0) {
                            this.columnCount.set(rs.getMetaData().getColumnCount());
                        }
                        int colCount = this.columnCount.get();
                        data = new ArrayList<Object[]>();
                        while (rs.next()) {
                            Object[] row = new Object[colCount];
                            for (int i = 1; i <= colCount; ++i) {
                                row[i - 1] = this.meta.getColumnType(i) == 93 ? rs.getTimestamp(i) : rs.getObject(i);
                            }
                            data.add(row);
                        }
                        ArrayList<Object[]> arrayList = data;
                        return arrayList;
                    }
                    catch (SQLException ex) {
                        LogManager.logDiagnostics(con);
                        throw ex;
                    }
                    finally {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {}
                        try {
                            st.close();
                        }
                        catch (Throwable throwable) {}
                        try {
                            con.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }, 5, 50);
            }
            catch (SQLException sqex) {
                HDLogger.debug(query);
                HDLogger.error(new HelpDeskServerException("Ticket query failed", (Throwable)sqex, HelpDeskErrorCodes.SQL_EXECUTION_ERROR));
                throw sqex;
            }
            if (System.currentTimeMillis() - start > 1000L) {
                StringBuilder buf = new StringBuilder("Execution: ");
                buf.append("OrderLoader duration: ").append(System.currentTimeMillis() - start).append("ms");
                if (paramString.length() > 0) {
                    buf.append("\n   ").append(paramString);
                }
                HDLogger.warn(buf.toString());
            }
            return new CachedResultSet(this.meta, result);
        }

        private synchronized void createMetaData(ResultSet rs) throws SQLException {
            if (this.meta != null) {
                return;
            }
            this.meta = new CachedResultSetMetaData(rs.getMetaData());
        }
    }
}

