/*
 * Decompiled with CFR 0.152.
 */
package srv.orderlistcache;

import com.inet.helpdesk.core.swing.AbstractResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import srv.orderlistcache.CachedResultSetMetaData;

public class CachedResultSet
extends AbstractResultSet {
    private List<Object[]> rows;
    private CachedResultSetMetaData meta;
    private Object[] currentRow;
    private int row = -1;
    private int maxRows = Integer.MAX_VALUE;

    public CachedResultSet(CachedResultSetMetaData meta, List<Object[]> rows) {
        this.meta = meta;
        this.rows = rows;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.row < this.rows.size() - 1 && (this.maxRows <= 0 || this.row < this.maxRows)) {
            this.currentRow = this.rows.get(++this.row);
            return true;
        }
        this.currentRow = null;
        return false;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        if (this.currentRow == null) {
            throw new SQLException("There is no current row");
        }
        if (columnIndex < 1 || columnIndex > this.currentRow.length) {
            throw new SQLException("Invalid column index: " + columnIndex);
        }
        return this.currentRow[columnIndex - 1];
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        ResultSetMetaData metaData = this.getMetaData();
        int count = metaData.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            if (!columnName.equalsIgnoreCase(metaData.getColumnName(i))) continue;
            return ((Number)this.getObject(i)).intValue();
        }
        return super.getInt(columnName);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        ResultSetMetaData metaData = this.getMetaData();
        int count = metaData.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            if (!columnName.equalsIgnoreCase(metaData.getColumnName(i))) continue;
            return (String)this.getObject(i);
        }
        return super.getString(columnName);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        ResultSetMetaData metaData = this.getMetaData();
        int count = metaData.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            if (!columnName.equalsIgnoreCase(metaData.getColumnName(i))) continue;
            return this.getObject(i);
        }
        return super.getObject(columnName);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)this.currentRow[columnIndex - 1];
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.meta;
    }

    public CachedResultSet createCopy() {
        CachedResultSet copy = new CachedResultSet(this.meta, this.rows);
        copy.maxRows = this.maxRows;
        return copy;
    }

    public int getRowCount() {
        return this.rows != null ? this.rows.size() : 0;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }
}

