/*
 * Decompiled with CFR 0.152.
 */
package srv.controller.ticket.timeline;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;
import com.inet.helpdesk.core.ticketmanager.timeline.PeriodOfTime;
import com.inet.helpdesk.core.ticketmanager.timeline.TimelineDataHandler;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldWorkingHours;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import srv.controller.ticket.timeline.ResultCalculator;
import srv.controller.ticket.timeline.SpecificThresholdValues;
import srv.controller.ticket.timeline.TimelineUtilities;
import srv.controller.ticket.timeline.WorkingHourTimeline;

public class ResourceTimelineManager {
    private static ResourceTimelineManager instance = new ResourceTimelineManager();
    private List<WorkingHourTimeline> timeLines = new ArrayList<WorkingHourTimeline>();
    private List<PeriodOfTime> nonWorkingDays;
    private static TimelineDataHandler timelineDataHandler;

    public static ResourceTimelineManager getInstance() {
        timelineDataHandler = (TimelineDataHandler)ServerPluginManager.getInstance().getSingleInstance(TimelineDataHandler.class);
        return instance;
    }

    public SpecificThresholdValues calculateEscalation(Integer resourceId, Integer priorityId, Date begin) {
        WorkingHourTimeline rct;
        Date escalationTime;
        double escalationPeriod = timelineDataHandler.getPriorityEscalationTime(priorityId);
        if (escalationPeriod > 0.0 && (escalationTime = (rct = this.getTimelineForResource(resourceId, escalationPeriod)).calculatePeriodUp(begin, escalationPeriod)) != null) {
            double yellowThreshold = TimelineUtilities.getThresholdPeriodFor(TimelineUtilities.ExecutionType.ESCALATION_WARNING_YELLOW);
            double redThreshold = TimelineUtilities.getThresholdPeriodFor(TimelineUtilities.ExecutionType.ESCALATION_WARNING_RED);
            return rct.calculateThresholdValues(escalationTime, new double[]{redThreshold, yellowThreshold});
        }
        return null;
    }

    public SpecificThresholdValues calculateDeadlineThresholdValues(Integer resourceId, Date deadline) {
        double yellowThreshold = TimelineUtilities.getThresholdPeriodFor(TimelineUtilities.ExecutionType.DEADLINE_WARNING_YELLOW);
        double redThreshold = TimelineUtilities.getThresholdPeriodFor(TimelineUtilities.ExecutionType.DEADLINE_WARNING_RED);
        WorkingHourTimeline rct = this.getTimelineForResource(resourceId, 0.0);
        return rct.calculateThresholdValues(deadline, new double[]{redThreshold, yellowThreshold});
    }

    public void calculateWorkingTime(Integer resourceId, Timestamp startOfPeriod, Timestamp endOfPeriod, ResultCalculator result) {
        if (startOfPeriod == null || endOfPeriod == null || endOfPeriod.before(startOfPeriod)) {
            return;
        }
        List<PeriodOfTime> holidays = TimelineUtilities.readFeiertage();
        UserGroupInfo resource = HDUsersAndGroups.getResource(resourceId);
        ResourceFieldWorkingHours.WorkingHours wh = resource != null ? (ResourceFieldWorkingHours.WorkingHours)resource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_WORKING_HOURS) : ResourceFieldWorkingHours.DEFAULT_WORKING_HOURS;
        LocalDateTime ldtStart = startOfPeriod.toLocalDateTime();
        LocalDateTime ldtEnd = endOfPeriod.toLocalDateTime();
        LocalDate ldEnd = ldtEnd.toLocalDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startOfPeriod);
        int dw = ResourceTimelineManager.convert(calendar.get(7));
        ResourceFieldWorkingHours.HourRange dayRange = wh.getHourRange(DayOfWeek.of(dw));
        if (dayRange != null && TimelineUtilities.findDatePosition(holidays, startOfPeriod, false) == -1) {
            result.addDayPart(dayRange, ldtStart, ldtEnd);
        }
        while (true) {
            calendar.add(6, 1);
            LocalDate test = new Timestamp(calendar.getTimeInMillis()).toLocalDateTime().toLocalDate();
            if (ldEnd.isBefore(test)) break;
            dw = ResourceTimelineManager.convert(calendar.get(7));
            dayRange = wh.getHourRange(DayOfWeek.of(dw));
            if (dayRange == null || TimelineUtilities.findDatePosition(holidays, calendar.getTime(), false) != -1) continue;
            if (ldEnd.equals(test)) {
                result.addDayPart(dayRange, null, ldtEnd);
                continue;
            }
            result.addDay(dayRange);
        }
    }

    private static int convert(int in) {
        if (in == 1) {
            return 7;
        }
        return in - 1;
    }

    public Date calcDeadline(Integer resourceId, Integer priorityId) {
        return this.calcTargetTime(resourceId, priorityId, new Timestamp(System.currentTimeMillis()));
    }

    public boolean isResourceAccessibleNow(Integer resourceId) {
        WorkingHourTimeline rct = this.getTimelineForResource(resourceId, 0.0);
        return rct.isAccessibleNow();
    }

    public Date calcTargetTime(Integer resourceId, Integer priorityId, Date begin) {
        if (resourceId != null) {
            double deadlinePeriod;
            PriorityVO priorityVO = (PriorityVO)PriorityManager.getInstance().get(priorityId);
            double d = deadlinePeriod = priorityVO.isDeleted() ? 0.0 : priorityVO.getDeadline();
            if (deadlinePeriod > 0.0) {
                WorkingHourTimeline rct = this.getTimelineForResource(resourceId, deadlinePeriod);
                return rct.calculatePeriodUp(begin, deadlinePeriod);
            }
        }
        return null;
    }

    private synchronized WorkingHourTimeline getTimelineForResource(Integer resourceId, double neededHours) {
        List<PeriodOfTime> hollidays = TimelineUtilities.readFeiertage();
        if (!TimelineUtilities.compareWorkingHours(this.nonWorkingDays, hollidays)) {
            HDLogger.info("New list of non working days.");
            this.nonWorkingDays = hollidays;
            if (this.timeLines.size() > 0) {
                this.timeLines = new ArrayList<WorkingHourTimeline>();
                new Thread("Revalidate time line calculations"){

                    @Override
                    public void run() {
                        TimelineUtilities.baseSettingsChanged(true, true);
                    }
                }.start();
            }
        }
        ArrayList<PeriodOfTime> attendanceTimes = timelineDataHandler.getResourceAttendanceTimes(resourceId);
        for (int i = this.timeLines.size() - 1; i >= 0; --i) {
            WorkingHourTimeline rct = this.timeLines.get(i);
            if (rct.canHandle(attendanceTimes, neededHours)) {
                return rct;
            }
            if (rct.isValid()) continue;
            this.timeLines.remove(rct);
        }
        WorkingHourTimeline newTimline = new WorkingHourTimeline(attendanceTimes, this.nonWorkingDays);
        this.timeLines.add(newTimline);
        HDLogger.info("Now " + this.timeLines.size() + " time lines available.");
        return newTimline;
    }
}

