/*
 * Decompiled with CFR 0.152.
 */
package srv.controller;

import java.util.Arrays;

public class IntObjectHashMap<T> {
    private transient Entry<T>[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    private IntObjectHashMap(int initialCapacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
        this.count = 0;
    }

    public IntObjectHashMap(int size) {
        this(size, 0.75f);
    }

    public IntObjectHashMap() {
        this(8, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public synchronized void remove(int key) {
        Entry<T> prev;
        int i = IntObjectHashMap.indexFor(key, this.table.length);
        Entry<T> e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (key == e.key) {
                --this.count;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return;
            }
            prev = e;
            e = next;
        }
    }

    public T get(String strKey) {
        int key = strKey.hashCode();
        Entry<T>[] tab = this.table;
        int index = IntObjectHashMap.indexFor(key, tab.length);
        Entry<T> e = tab[index];
        while (e != null) {
            if (key == e.key && strKey.equals(e.stringKey)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public T get(int key) {
        Entry<T>[] tab = this.table;
        int index = IntObjectHashMap.indexFor(key, tab.length);
        Entry<T> e = tab[index];
        while (e != null) {
            if (key == e.key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public synchronized void put(String strKey, T value) {
        int key = strKey.hashCode();
        int index = IntObjectHashMap.indexFor(key, this.table.length);
        Entry<T> e = this.table[index];
        while (e != null) {
            if (key == e.key && strKey.equals(e.stringKey)) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        Entry<T> ent = new Entry<T>(key, value, this.table[index]);
        ent.stringKey = strKey;
        this.table[index] = ent;
        if (this.count++ >= this.threshold) {
            this.rehash();
        }
    }

    public synchronized void put(int key, T value) {
        int index = IntObjectHashMap.indexFor(key, this.table.length);
        Entry<T> e = this.table[index];
        while (e != null) {
            if (key == e.key) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.table[index] = new Entry<T>(key, value, this.table[index]);
        if (this.count++ >= this.threshold) {
            this.rehash();
        }
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry<T>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry<T> old = oldMap[i];
            while (old != null) {
                Entry<T> e = old;
                old = old.next;
                int index = IntObjectHashMap.indexFor(e.key, newCapacity);
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public int[] getSortetKeys() {
        int[] keys = this.getAllKeys();
        Arrays.sort(keys);
        return keys;
    }

    public int[] getAllKeys() {
        int[] allKeys = new int[this.count];
        if (this.count == 0) {
            return allKeys;
        }
        int writePos = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry<T> e = this.table[i];
            while (e != null) {
                allKeys[writePos++] = e.key;
                e = e.next;
            }
        }
        return allKeys;
    }

    public int capacity() {
        return this.table.length;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    private static class Entry<T> {
        int key;
        String stringKey;
        T value;
        Entry<T> next;

        Entry(int key, T value, Entry<T> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

