/*
 * Decompiled with CFR 0.152.
 */
package srv.controller;

import com.inet.helpdesk.core.swing.ListResultSet;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.GenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.fields.resource.ResourceVO;
import com.inet.helpdesk.data.ActionDataProvider;
import com.inet.helpdesk.shared.util.TypespecificIntMap;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import srv.ServerUtilities;
import srv.controller.OpenOrderController;
import srv.controller.WorkFlow;
import srv.controller.ticket.Auftrag;
import srv.controller.ticket.attributes.LastEditorVO;
import srv.controller.ticket.attributes.UserDefinedVO;

public class Fetcher
implements Iterator<Object[]> {
    private static final int[] COLUMN_DATA_TYPS_TREE = new int[]{12, 12, 4, 4, 4, 4, 4, 4};
    private static final String[] COLUMN_NAMES_TREE = new String[]{"p", "s", "pID", "sID", "anzahl", "unseen", "version", "highlight"};
    private Row firstRow = new Row(null, null, 0, 0, 0, false);
    private Row currentRow;

    public Fetcher(OpenOrderController ctrl, TypespecificIntMap<WorkFlow> workflows, int[] resourcen, Auftrag.Field primaerTyp, Auftrag.Field sekundaerTyp) {
        int[] unseen = ActionDataProvider.getUnseenStates();
        for (Auftrag auf : this.getOrders(ctrl)) {
            if (auf == null || !ServerUtilities.getOpenOrderController().orderAvailable(resourcen, auf)) continue;
            FieldVO primary = auf.getAttribut(primaerTyp);
            FieldVO secondary = sekundaerTyp != null ? auf.getAttribut(sekundaerTyp) : null;
            boolean unread = Fetcher.isUnseenState(auf.getStatus(), unseen);
            boolean high = unread && auf.getPriority().getId() > 99;
            this.appendOrderDataToRows(primary, secondary, unread, high, auf.getVersion());
        }
        if (workflows != null) {
            int[] workFlowIDs;
            Row lastRow = this.firstRow;
            while (lastRow.next != null) {
                lastRow = lastRow.next;
            }
            for (int workFlowID : workFlowIDs = workflows.getSortetKeys()) {
                WorkFlow workflow = workflows.get(workFlowID);
                if (!workflow.canGet(resourcen)) continue;
                lastRow = lastRow.next = new Row(workflow.getData(), primaerTyp, sekundaerTyp);
            }
        }
        this.currentRow = this.firstRow;
    }

    public Fetcher(Auftrag.Field type, GenericFieldsManager<? extends FieldVO> manager) {
        manager.getAll(false).forEach(f -> this.appendOrderDataToRows((FieldVO)f, null, false, false, type == Auftrag.Field.RESOURCE ? ServerUtilities.getOpenOrderController().getResource(f.getId()).getVersion() : 0));
        this.currentRow = this.firstRow;
    }

    protected List<Auftrag> getOrders(OpenOrderController ctrl) {
        List<Integer> result = OpenOrderController.getAllOpenOrderIDs();
        return result.stream().map(id -> ctrl.getAuftrag((int)id)).collect(Collectors.toList());
    }

    protected void appendOrderDataToRows(FieldVO primary, FieldVO secondary, boolean unread, boolean highlight, int version) {
        if (this.firstRow.next == null) {
            Row aRow;
            this.firstRow.next = aRow = new Row(primary, secondary, version, unread ? 1 : 0, 1, highlight);
        } else {
            Row aRow = this.firstRow;
            while (aRow.next != null) {
                int result = this.checkVals(aRow.next, primary, secondary);
                if (result == 0) {
                    aRow = aRow.next;
                    ++aRow.datacount;
                    aRow.highlight |= highlight;
                    if (aRow.version < version) {
                        aRow.version = version;
                    }
                    if (!unread) break;
                    ++aRow.unread;
                    break;
                }
                if (result > 0) {
                    if (aRow.next.next != null) {
                        aRow = aRow.next;
                        continue;
                    }
                    aRow.next.next = new Row(primary, secondary, version, unread ? 1 : 0, 1, highlight);
                    aRow = aRow.next.next;
                    break;
                }
                Row newRow = new Row(primary, secondary, version, unread ? 1 : 0, 1, highlight);
                newRow.next = aRow.next;
                aRow.next = newRow;
                aRow = newRow;
                break;
            }
        }
    }

    private int checkVals(Row row, FieldVO primary, FieldVO secondary) {
        int compare = this.compareTo(primary, row.primary);
        if (compare == 0) {
            if (row.secondary == secondary) {
                return 0;
            }
            return secondary != null ? this.compareTo(secondary, row.secondary) : (row.secondary == null ? 0 : 1);
        }
        return compare;
    }

    private int compareTo(FieldVO f1, FieldVO f2) {
        if (f1.getClass() != f2.getClass()) {
            return Long.compare(f1.getId(), f2.getId());
        }
        if (f1.getClass() == ResourceVO.class) {
            int otherPrimID;
            ResourceVO r1 = (ResourceVO)f1;
            ResourceVO r2 = (ResourceVO)f2;
            int thisPrimID = r1.getParentID() > 0 ? r1.getParentID() : r1.getId();
            int n = otherPrimID = r2.getParentID() > 0 ? r2.getParentID() : r2.getId();
            if (thisPrimID != otherPrimID) {
                return thisPrimID > otherPrimID ? 1 : -1;
            }
            return Integer.compare(r1.getId(), r2.getId());
        }
        if (f1.getClass() == ItilVO.class) {
            ItilVO i1 = (ItilVO)f1;
            ItilVO i2 = (ItilVO)f2;
            int master = Boolean.compare(i1.isMasterType(), i2.isMasterType());
            if (master != 0) {
                return -master;
            }
            return f1.getDisplayValue().toLowerCase().compareTo(f2.getDisplayValue().toLowerCase());
        }
        if (f1.getClass() == LastEditorVO.class || f1.getClass() == UserDefinedVO.class) {
            return f1.getDisplayValue().toLowerCase().compareTo(f2.getDisplayValue().toLowerCase());
        }
        return Long.compare(f1.getId(), f2.getId());
    }

    public ResultSet getResultSet() {
        ListResultSet theRS = new ListResultSet();
        theRS.setColumns(COLUMN_NAMES_TREE);
        theRS.setColumnTypes(COLUMN_DATA_TYPS_TREE);
        theRS.setValues(this);
        return theRS;
    }

    @Override
    public boolean hasNext() {
        return this.currentRow.next != null;
    }

    @Override
    public Object[] next() {
        if (this.currentRow.next == null) {
            return null;
        }
        this.currentRow = this.currentRow.next;
        return this.currentRow.getData();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("The method 'remove' is not support by " + this.getClass());
    }

    public Row getNextRow() {
        if (this.currentRow != null) {
            this.currentRow = this.currentRow.next;
            return this.currentRow;
        }
        return null;
    }

    private static String getWholeName(FieldVO attr) {
        if (attr != null) {
            if (attr instanceof CategoryVO && ((CategoryVO)attr).getPath() != null) {
                return ((CategoryVO)attr).getPath();
            }
            return attr.getDisplayValue();
        }
        return null;
    }

    private static boolean isUnseenState(int state, int[] unseen) {
        for (int compare : unseen) {
            if (state != compare) continue;
            return true;
        }
        return false;
    }

    private static class WorkflowVO
    extends FieldVO {
        private String name;

        public WorkflowVO(int id, String name) {
            super(id);
            this.name = name;
        }

        @Override
        public String getDisplayValue() {
            return this.name;
        }
    }

    public class Row {
        private Row next;
        private Object[] data;
        private FieldVO primary;
        private FieldVO secondary;
        private int datacount;
        private int unread;
        private int version;
        private boolean highlight;

        private Row(FieldVO primary, FieldVO secondary, int version, int unread, int datacount, boolean highlight) {
            this.primary = primary;
            this.secondary = secondary;
            this.version = version;
            this.unread = unread;
            this.datacount = datacount;
            this.highlight = highlight;
        }

        private Row(Object[] data, Auftrag.Field primaerTyp, Auftrag.Field sekundaerTyp) {
            this.primary = data[2] != null && data[0] != null ? new WorkflowVO(Integer.valueOf(data[2].toString()), data[0].toString()) : null;
            this.secondary = data[3] != null && data[1] != null ? new WorkflowVO(Integer.valueOf(data[3].toString()), data[1].toString()) : null;
            this.datacount = data[4] != null ? Integer.valueOf(data[4].toString()) : 0;
            this.unread = data[5] != null ? Integer.valueOf(data[5].toString()) : 0;
            int n = this.version = data[6] != null ? Integer.valueOf(data[6].toString()) : 0;
            this.highlight = data[7] != null ? Integer.valueOf(data[7].toString()) == 1 : false;
        }

        public FieldVO getPrimaryAttribute() {
            return this.primary;
        }

        public FieldVO getSecondaryAttribute() {
            return this.secondary;
        }

        public int getOrderCount() {
            return this.datacount;
        }

        public int getUnreadCount() {
            return this.unread;
        }

        public int getVersion() {
            return this.version;
        }

        public Object[] getData() {
            if (this.data == null) {
                this.data = new Object[8];
                this.data[0] = Fetcher.getWholeName(this.primary);
                this.data[1] = Fetcher.getWholeName(this.secondary);
                this.data[2] = new Integer(this.primary.getId());
                this.data[3] = this.secondary != null ? new Integer(this.secondary.getId()) : Integer.valueOf(-1);
                this.data[4] = new Integer(this.datacount);
                this.data[5] = new Integer(this.unread);
                this.data[6] = new Integer(this.version);
                this.data[7] = new Integer(this.highlight ? 1 : 0);
            }
            return this.data;
        }
    }
}

