/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic.deviceimport;

import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DeviceImportConfigInfo;
import com.inet.helpdesk.core.data.DataImportJob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.SuppressFBWarnings;
import srv.automatic.GeraeteImporter;
import srv.automatic.UserImporter;
import srv.automatic.deviceimport.AbstractDeviceImporter;
import srv.automatic.deviceimport.DeviceImportingException;
import srv.automatic.deviceimport.MappingHandler;

public class DbDeviceImporter
extends AbstractDeviceImporter {
    private Connection fremdC = null;
    private Map<Integer, Integer> userGebs;

    public DbDeviceImporter(DatabaseConfigInfo dbConn) throws SQLException {
        this.fremdC = UserImporter.getConnection(dbConn);
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Argument strings are quoted")
    public HashMap<String, Integer> replaceOwnKey(HashMap<String, Integer> userHm, String table, String keySpalte, String userIdSpalte, String filter) throws DeviceImportingException {
        HashMap<String, Integer> hashMap;
        block11: {
            Statement st = this.fremdC.createStatement();
            try {
                String qS = this.fremdC.getMetaData().getIdentifierQuoteString();
                HashMap<String, Integer> newHm = new HashMap<String, Integer>();
                String statement = "Select " + qS + keySpalte + qS + ", " + qS + userIdSpalte + qS + " From " + qS + table + qS;
                this.logger.debug((Object)("STATEMENT: " + statement));
                ResultSet rs = st.executeQuery(statement);
                while (rs.next()) {
                    String key = rs.getString(keySpalte);
                    String userName = rs.getString(userIdSpalte);
                    this.logger.debug((Object)("KEY: " + key + " USERNAME: " + userName));
                    if (key == null || userName == null || userName.trim().isEmpty()) continue;
                    key = key.trim();
                    Integer userid = userHm.get(GeraeteImporter.normalizeName(userName));
                    if (userid == null) continue;
                    this.putKontrolle(newHm, key, userid);
                }
                try {
                    rs.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                hashMap = newHm;
                if (st == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException exc) {
                    this.logger.error((Object)exc);
                    throw new DeviceImportingException(exc);
                }
            }
            st.close();
        }
        return hashMap;
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="input strings are quoted")
    public List<Map<String, String>> doImport(DataImportJob dataImportJob, Map<Integer, Integer> userGebs, HashMap<String, Integer> userHm, Connection conHD, DeviceImportConfigInfo importConfig, String name, String filter, int newVersID, int gerTyp, MappingHandler mappingHandler, String nameRef, boolean indirekt, AbstractDeviceImporter.RowAddedListener rowAddedListener) throws Exception {
        ResultSet rs = null;
        try (Statement st = this.fremdC.createStatement();){
            String qS = this.fremdC.getMetaData().getIdentifierQuoteString();
            this.userGebs = userGebs;
            String importTabelle = importConfig.getImportSource();
            String identString = importConfig.getUniqueIdent() == null ? "" : importConfig.getUniqueIdent().trim();
            boolean uniqueIdentAvailable = identString.length() > 0;
            ArrayList<String> additinalNames = new ArrayList<String>();
            additinalNames.add(nameRef);
            if (uniqueIdentAvailable) {
                additinalNames.add(identString);
            }
            this.prepareAllStatements(conHD, name, newVersID, gerTyp, mappingHandler);
            ArrayList<MappingHandler.MappedColumn> requiredDataColumns = mappingHandler.getListOfColumnsToSelect(new String[0]);
            List<String> selectionColumns = DbDeviceImporter.getSelectionColumns(mappingHandler, additinalNames.toArray(new String[additinalNames.size()]));
            String selectString = DbDeviceImporter.createSelectString(filter, importTabelle, qS, selectionColumns);
            this.logger.debug((Object)("SELECTSTRING: " + selectString));
            rs = st.executeQuery(selectString);
            ArrayList<SourceData> data = new ArrayList<SourceData>();
            HashMap<String, String> buffer = new HashMap<String, String>();
            while (rs.next()) {
                String[] rowData = this.getRowData(rs, requiredDataColumns, selectionColumns, buffer);
                ++this.available;
                int emptyColumns = 0;
                for (String value : rowData) {
                    if (value.length() != 0) continue;
                    ++emptyColumns;
                }
                if (emptyColumns == rowData.length) {
                    this.logger.debug((Object)"row contains only null values");
                    --this.available;
                    continue;
                }
                dataImportJob.incrementDataCount();
                SourceData sd = new SourceData();
                sd.deviceData = rowData;
                String uname = buffer.get(nameRef);
                if (uname == null || uname.trim().isEmpty()) {
                    this.logger.debug((Object)"row has empty user name");
                    --this.available;
                    continue;
                }
                sd.userid = userHm.get(GeraeteImporter.normalizeName(uname));
                if (uniqueIdentAvailable) {
                    sd.uniqueKey = buffer.get(identString);
                }
                if (this.checkDbData(dataImportJob, this.available, userHm, sd, indirekt, uniqueIdentAvailable)) {
                    data.add(sd);
                }
                if (rowAddedListener != null) {
                    if (!rowAddedListener.finishedWithRowCount(data.size())) continue;
                    break;
                }
                if (data.size() != 50) continue;
                this.putInDB(dataImportJob, conHD, name, data, importConfig.getGerTyp(), uniqueIdentAvailable);
                data.clear();
            }
            if (rowAddedListener != null) {
                ArrayList<String[]> exampleBuffer = new ArrayList<String[]>();
                for (SourceData sd : data) {
                    exampleBuffer.add(sd.deviceData);
                }
                List<Map<String, String>> list = this.createEntrys(exampleBuffer, requiredDataColumns);
                return list;
            }
            this.putInDB(dataImportJob, conHD, name, data, importConfig.getGerTyp(), uniqueIdentAvailable);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            throw e;
        }
        finally {
            this.closeAllStatements();
            try {
                rs.close();
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internally created statement")
    private void putInDB(DataImportJob dataImportJob, Connection conHD, String name, ArrayList<SourceData> data, int gerType, boolean vergleichen) throws Exception {
        if (data.size() == 0) {
            return;
        }
        ResultSet rs = null;
        if (vergleichen) {
            StringBuffer buf = new StringBuffer(this.baseSelectString + " IN (?");
            for (int i = 1; i < data.size(); ++i) {
                buf.append(",?");
            }
            buf.append(')');
            try (PreparedStatement pst = conHD.prepareStatement(buf.toString());){
                pst.setString(1, name);
                for (int i = 0; i < data.size(); ++i) {
                    pst.setString(i + 2, data.get((int)i).uniqueKey);
                }
                rs = pst.executeQuery();
                block18: while (rs.next()) {
                    AbstractDeviceImporter.DeviceData devDat = this.getDataFromResultSet(rs);
                    for (int i = data.size() - 1; i >= 0; --i) {
                        if (!devDat.getForeignKey().equals(data.get((int)i).uniqueKey)) continue;
                        SourceData device = data.remove(i);
                        if (!this.compareData(devDat.getData(), device.deviceData) || devDat.gerTyp != gerType) {
                            boolean move;
                            boolean bl = move = !devDat.getUserId().equals(device.userid);
                            if (move && this.logger.isDebug()) {
                                this.logger.debug((Object)("Move " + devDat.getId() + " Userid " + devDat.getUserId() + " -> " + device.userid));
                            }
                            this.setDBUpdateData(device, devDat.getId(), move);
                            dataImportJob.incrementUpdatedCount();
                            continue block18;
                        }
                        this.updateVersion(devDat.getId());
                        continue block18;
                    }
                }
            }
            catch (SQLException sqlex) {
                this.logger.error((Object)sqlex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
        }
        this.inserten(dataImportJob, data);
    }

    private void inserten(DataImportJob dataImportJob, ArrayList<SourceData> data) throws Exception {
        for (int i = data.size() - 1; i >= 0; --i) {
            SourceData sd = data.get(i);
            this.pstInsert.setString(1, sd.uniqueKey);
            this.pstInsert.setInt(2, sd.userid);
            int gebID = this.userGebs.get(sd.userid);
            this.pstInsert.setInt(3, gebID);
            this.setUpdateData(this.pstInsert, null, sd.deviceData, 4);
            this.pstInsert.execute();
            data.remove(i);
            dataImportJob.incrementAddedCount();
            ++this.newImports;
        }
    }

    private String[] getRowData(ResultSet rs, ArrayList<MappingHandler.MappedColumn> requiredDataColumns, List<String> selectionColumns, HashMap<String, String> buffer) throws SQLException {
        for (String column : selectionColumns) {
            String testString = rs.getString(column);
            testString = testString != null ? testString.trim() : "";
            buffer.put(column, testString);
        }
        String[] rowData = new String[requiredDataColumns.size()];
        for (int i = 0; i < rowData.length; ++i) {
            String value = buffer.get(requiredDataColumns.get(i).getSourceColumnName());
            if (value.length() > requiredDataColumns.get(i).getMaxValueLength()) {
                value = value.substring(0, requiredDataColumns.get(i).getMaxValueLength());
            }
            rowData[i] = value;
        }
        return rowData;
    }

    private static List<String> getSelectionColumns(MappingHandler mappingHandler, String[] addNames) {
        ArrayList<MappingHandler.MappedColumn> toSelect = mappingHandler.getListOfColumnsToSelect(addNames);
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < toSelect.size(); ++i) {
            String colName = ((MappingHandler.MappedColumn)toSelect.get(i)).getSourceColumnName();
            if (names.contains(colName)) continue;
            names.add(colName);
        }
        return names;
    }

    private static String createSelectString(String filter, String importTabelle, String qS, List<String> toSelect) {
        String selectString = "Select " + qS + toSelect.get(0) + qS;
        for (int i = 1; i < toSelect.size(); ++i) {
            selectString = selectString + ", " + qS + toSelect.get(i) + qS;
        }
        selectString = selectString + " From " + qS + importTabelle + qS;
        if (filter.length() > 0) {
            selectString = selectString + " Where " + filter;
        }
        return selectString;
    }

    @Override
    public void cleanup() {
        try {
            this.fremdC.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.fremdC = null;
    }

    private void setDBUpdateData(SourceData data, int gerID, boolean verschieben) throws SQLException {
        ++this.updates;
        if (verschieben) {
            this.pstVerschieben.setInt(1, data.userid);
            this.pstVerschieben.setInt(2, gerID);
            this.pstVerschieben.execute();
        }
        this.setUpdateData(this.pstSimpleUpdate, null, data.deviceData, 1);
        this.pstSimpleUpdate.setInt(data.deviceData.length + 1, gerID);
        this.pstSimpleUpdate.execute();
    }

    private boolean checkDbData(DataImportJob dataImportJob, int debugCounter, HashMap<String, Integer> userHm, SourceData sd, boolean indirekt, boolean uniqueTest) {
        Integer userid = sd.userid;
        if (userid == null) {
            this.logger.warn((Object)("Row " + debugCounter + " no Userid!"));
            return false;
        }
        if (uniqueTest && (sd.uniqueKey == null || sd.uniqueKey.length() == 0)) {
            this.logger.warn((Object)("Row " + debugCounter + " no reference: " + sd.uniqueKey));
            dataImportJob.incrementDuplicatesCount();
            return false;
        }
        if (sd.deviceData[0] == null || sd.deviceData[0].length() == 0) {
            this.logger.error((Object)("Row " + debugCounter + " no Name"));
            dataImportJob.incrementErrorsCount();
            return false;
        }
        this.logger.debug((Object)("Row " + debugCounter + "  UserId " + sd.userid + "  Key: " + sd.uniqueKey + "  Name: " + sd.deviceData[0]));
        return true;
    }

    private class SourceData {
        private Integer userid;
        private String uniqueKey;
        private String[] deviceData;

        private SourceData() {
        }
    }
}

