/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic;

import com.inet.config.ConfigValue;
import com.inet.error.ErrorCode;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.HelpDeskServerException;
import com.inet.helpdesk.core.ticketmanager.timeline.TimelineDataHandler;
import com.inet.helpdesk.mail.reader.EmailReader_Main;
import com.inet.plugin.ServerPluginManager;
import com.inet.thread.ThreadUtils;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.sql.Connection;
import java.sql.SQLException;
import srv.ServerUtilities;
import srv.automatic.AutoProcess;
import srv.automatic.AutoProcessErrorHandler;

public class Timer
extends Thread {
    private boolean listener = false;
    private EmailReader_Main emailReader = new EmailReader_Main();
    private AutoProcess autoProc = null;
    private boolean stop = false;
    private static int minutes;
    private int counter = 0;
    private static final int AUTO_PROCESS_HEARTBEAT = 60;
    private static final ConfigValue<Integer> MAIL_TIMER;

    public Timer() {
        try {
            this.setPriority(1);
        }
        catch (Exception e) {
            ServerUtilities.systemOut("Timer", new HelpDeskServerException((Throwable)e, (ErrorCode)HelpDeskErrorCodes.TIMER_THREAD_ERROR), "Could not set the priority of this thread");
        }
        try {
            this.setName("Timer");
        }
        catch (Exception e) {
            ServerUtilities.systemOut("Timer", new HelpDeskServerException((Throwable)e, (ErrorCode)HelpDeskErrorCodes.TIMER_THREAD_ERROR), "Could not set the name of this thread");
        }
        minutes = (Integer)MAIL_TIMER.get();
        HDLogger.info("Mail polling " + minutes + " min intervall");
        this.start();
        int loopCount = 0;
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                HDLogger.error(new HelpDeskServerException((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.TIMER_THREAD_ERROR));
            }
        } while (this.counter == 0 && ++loopCount < 60);
    }

    public void stopTimer() {
        this.stop = true;
        try {
            this.join(10000L);
            ThreadUtils.stopThread((Thread)this);
        }
        catch (InterruptedException e) {
            HDLogger.error(new HelpDeskServerException((Throwable)e, (ErrorCode)HelpDeskErrorCodes.TIMER_THREAD_ERROR));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ConnectionFactory factory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        this.counter = 0;
        try (UserAccountScope privileged = UserAccountScope.createPrivileged();){
            while (!this.stop) {
                try {
                    Connection con = null;
                    ServerUtilities.setLoopCount(this.counter);
                    new TimerControlStruktur(this.counter);
                    try {
                        if (!this.listener) {
                            this.listener = true;
                        }
                        con = factory.getConnection();
                        try {
                            if (minutes != (Integer)MAIL_TIMER.get()) {
                                minutes = (Integer)MAIL_TIMER.get();
                                HDLogger.info("Mail polling " + minutes + " min intervall");
                            }
                            if (this.counter % 10 == 0) {
                                ServerUtilities.conti.checkOpenOrders(true, con);
                                this.autoProc = new AutoProcess(this.counter / 10, con);
                                this.autoProc.work();
                                TimelineDataHandler tdh = (TimelineDataHandler)ServerPluginManager.getInstance().getSingleInstance(TimelineDataHandler.class);
                                tdh.validateNonWorkingPeriods();
                                tdh.checkDeadlineDataForExecutions(con);
                                tdh.checkEscalationDataForExecutions(con);
                            } else if (this.counter % 15 == 14) {
                                ServerUtilities.getOpenOrderController().checkAllOrders(con);
                            } else {
                                ServerUtilities.conti.checkOpenOrders(false, con);
                            }
                            if (this.listener && this.counter % minutes == 0) {
                                this.emailReader.readMails();
                            }
                            if (ServerUtilities.jtapiObs != null) {
                                ServerUtilities.jtapiObs.checkCallHolders();
                            }
                        }
                        catch (Exception er) {
                            if (!this.stop) {
                                HDLogger.error(new HelpDeskServerException((Throwable)er, (ErrorCode)HelpDeskErrorCodes.TIMER_EXECUTION_ERROR));
                            }
                        }
                    }
                    catch (SQLException sqle) {
                        if (!this.stop) {
                            ServerUtilities.systemOut("Timer", sqle, "unable to start Processes");
                        }
                    }
                    finally {
                        try {
                            con.close();
                        }
                        catch (Throwable sqle) {}
                    }
                    int sleepTimeCounter = 5;
                    if (factory.isHelpDeskDatabaseConnectionValid()) {
                        ++this.counter;
                        sleepTimeCounter = 60;
                    }
                    for (int t = 0; t < sleepTimeCounter; ++t) {
                        if (this.stop) continue;
                        Timer.sleep(1000L);
                    }
                }
                catch (Throwable e) {
                    if (!this.stop) {
                        ServerUtilities.systemOut("Timer bei Sleep unterbrochen", e, "");
                    }
                    this.stop = true;
                }
            }
        }
    }

    static {
        MAIL_TIMER = new ConfigValue<Integer>(HDConfigKeys.MAIL_TIMER){

            protected Integer convert(String strValue) throws IllegalArgumentException {
                Integer normalValue = (Integer)super.convert(strValue);
                if (normalValue < 0 || normalValue > 60) {
                    normalValue = 10;
                }
                return normalValue;
            }
        };
    }

    private class TimerControlStruktur
    implements Runnable {
        private int currentCountValue;
        private AutoProcessErrorHandler errorHandler;

        private TimerControlStruktur(int currentCountValue) {
            this.currentCountValue = currentCountValue;
            try {
                new Thread((Runnable)this, "TimerControl").start();
            }
            catch (Exception er) {
                HDLogger.error(new HelpDeskServerException((Throwable)er, (ErrorCode)HelpDeskErrorCodes.TIMER_THREAD_ERROR));
            }
        }

        @Override
        public void run() {
            while (this.currentCountValue == Timer.this.counter) {
                try {
                    Thread.sleep(60000L);
                }
                catch (Exception er) {
                    HDLogger.error(new HelpDeskServerException((Throwable)er, (ErrorCode)HelpDeskErrorCodes.TIMER_THREAD_ERROR));
                }
                if (this.currentCountValue != Timer.this.counter) continue;
                if (this.errorHandler == null) {
                    this.errorHandler = new AutoProcessErrorHandler();
                }
                this.errorHandler.checkConnectedUsers(ServerUtilities.conti.getCurrentConnectedSessions());
            }
            if (this.errorHandler != null) {
                this.errorHandler.blockadeReversed();
            }
        }
    }
}

