/*
 * Decompiled with CFR 0.152.
 */
package srv;

import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.usersandgroups.api.user.UserAccount;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import srv.ResultSetDelegate;
import srv.controller.ticket.attributes.UserCacheReplacement;

public class UserNameMappingResultSet
extends ResultSetDelegate {
    private final String userIdColumn;

    public UserNameMappingResultSet(ResultSet rs, String userIdColumn) {
        super(rs);
        this.userIdColumn = userIdColumn;
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        if ("Username".equalsIgnoreCase(columnLabel)) {
            Object userIdObj = this.getObject(this.userIdColumn);
            if (userIdObj == null) {
                return null;
            }
            int userId = ((Number)userIdObj).intValue();
            UserAccount userAccount = HDUsersAndGroups.getUserAccount(userId);
            if (userAccount == null) {
                return null;
            }
            String result = UserCacheReplacement.getUserName(userAccount);
            return result;
        }
        return super.getString(columnLabel);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        if ("Username".equalsIgnoreCase(this.getMetaData().getColumnName(columnIndex))) {
            return this.getString("Username");
        }
        return super.getObject(columnIndex);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        if ("Username".equalsIgnoreCase(this.getMetaData().getColumnName(columnIndex))) {
            return this.getString("Username");
        }
        return super.getString(columnIndex);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        if ("Username".equalsIgnoreCase(columnLabel)) {
            return super.findColumn(this.userIdColumn);
        }
        return super.findColumn(columnLabel);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSetMetaData metaData = super.getMetaData();
        return new UserNameMappingResultSetMetaData(metaData);
    }

    private class UserNameMappingResultSetMetaData
    implements ResultSetMetaData {
        private ResultSetMetaData meta;

        private UserNameMappingResultSetMetaData(ResultSetMetaData meta) {
            this.meta = meta;
        }

        @Override
        public int getColumnCount() throws SQLException {
            return this.meta.getColumnCount();
        }

        @Override
        public boolean isAutoIncrement(int column) throws SQLException {
            return this.meta.isAutoIncrement(column);
        }

        @Override
        public boolean isCaseSensitive(int column) throws SQLException {
            return this.meta.isCaseSensitive(column);
        }

        @Override
        public boolean isSearchable(int column) throws SQLException {
            return this.meta.isSearchable(column);
        }

        @Override
        public boolean isCurrency(int column) throws SQLException {
            return this.meta.isCurrency(column);
        }

        @Override
        public int isNullable(int column) throws SQLException {
            return this.meta.isNullable(column);
        }

        @Override
        public boolean isSigned(int column) throws SQLException {
            return this.meta.isSigned(column);
        }

        @Override
        public int getColumnDisplaySize(int column) throws SQLException {
            return this.meta.getColumnDisplaySize(column);
        }

        @Override
        public String getColumnLabel(int column) throws SQLException {
            String label = this.meta.getColumnLabel(column);
            if (UserNameMappingResultSet.this.userIdColumn.equalsIgnoreCase(label)) {
                return "Username";
            }
            return label;
        }

        @Override
        public String getColumnName(int column) throws SQLException {
            String label = this.meta.getColumnLabel(column);
            if (UserNameMappingResultSet.this.userIdColumn.equalsIgnoreCase(label)) {
                return "Username";
            }
            return label;
        }

        @Override
        public String getSchemaName(int column) throws SQLException {
            return this.meta.getSchemaName(column);
        }

        @Override
        public int getPrecision(int column) throws SQLException {
            return this.meta.getPrecision(column);
        }

        @Override
        public int getScale(int column) throws SQLException {
            return this.meta.getScale(column);
        }

        @Override
        public String getTableName(int column) throws SQLException {
            return this.meta.getTableName(column);
        }

        @Override
        public String getCatalogName(int column) throws SQLException {
            return this.meta.getCatalogName(column);
        }

        @Override
        public int getColumnType(int column) throws SQLException {
            return this.meta.getColumnType(column);
        }

        @Override
        public String getColumnTypeName(int column) throws SQLException {
            return this.meta.getColumnTypeName(column);
        }

        @Override
        public boolean isReadOnly(int column) throws SQLException {
            return this.meta.isReadOnly(column);
        }

        @Override
        public boolean isWritable(int column) throws SQLException {
            return this.meta.isWritable(column);
        }

        @Override
        public boolean isDefinitelyWritable(int column) throws SQLException {
            return this.meta.isDefinitelyWritable(column);
        }

        @Override
        public String getColumnClassName(int column) throws SQLException {
            return this.meta.getColumnClassName(column);
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.meta.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.meta.isWrapperFor(iface);
        }
    }
}

