/*
 * Decompiled with CFR 0.152.
 */
package srv;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.Searcher;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketManipulatorBackdoor;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.utils.DatabaseTransactionUtils;
import com.inet.helpdesk.search.SearcherImpl;
import com.inet.helpdesk.shared.util.TypespecificIntMap;
import com.inet.helpdesk.ticketmanager.adapt.NoUpdateResultSet;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.jj.srv.JavaCommand;
import com.inet.search.SearchResult;
import com.inet.search.command.SearchID;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.SuppressFBWarnings;
import srv.ServerUtilities;
import srv.UserNameMappingResultSet;
import srv.controller.OpenOrderController;
import srv.controller.ticket.Auftrag;
import srv.controller.ticket.AuftragWithReferences;
import srv.controller.ticket.AuftragsReferenz;
import srv.mail.AutoMailSender;

public class SpecialSqlCommand
extends JavaCommand {
    private static final int CLIENT_TIMEOUT = 25000;
    private static String[] sortOrderOra = new String[]{"NVL(tblRessourcen.ResBezeichnung,' ')", "tblPrioritaeten.PriID DESC", "NVL(tblKlasse.KlassenName,' ')", "tblAuftraege.BetID", "NVL(tblGebaeude.GebBezeichnung,' ')", "NVL(tblBenutzerGruppe.GroupName,' ')", "tblItil.masterTyp, NVL(tblItil.ItilBezeichnung,' ')", ""};
    private static String[] sortOrderMS = new String[]{"tblRessourcen.ResBezeichnung", "tblPrioritaeten.PriID DESC", "tblKlasse.KlassenName", "tblAuftraege.BetID", "tblGebaeude.GebBezeichnung", "tblBenutzerGruppe.GroupName", "tblItil.masterTyp, tblItil.ItilBezeichnung", ""};
    private static String[] sortOrderMysql = new String[]{"tblRessourcen.ResBezeichnung", "tblPrioritaeten.PriID DESC", "tblKlasse.KlassenName", "tblAuftraege.BetID", "tblGebaeude.GebBezeichnung", "tblBenutzerGruppe.GroupName", "tblItil.masterTyp, tblItil.ItilBezeichnung", ""};
    private static String[] colNamesBez = new String[]{"tblRessourcen.ResBezeichnung", "tblPrioritaeten.PriBezeichnung", "tblKlasse.KlassenName", "tblAuftraege.BetID", "tblGebaeude.GebBezeichnung", "tblBenutzerGruppe.GroupName", "tblItil.ItilBezeichnung", ""};
    private static final String[] SORT_ORDER_ID = new String[]{", tblRessourcen.ResID", "", ", tblKlasse.KlaID", "", ", tblGebaeude.GebID", ", tblBenutzerGruppe.BgrID", ", tblItil.ItiID", ""};
    private static final String[] COL_NAMES_ID = new String[]{"tblRessourcen.ResID", "tblPrioritaeten.PriID", "tblKlasse.KlaID", "tblAuftraege.BetID", "tblGebaeude.GebID", "tblBenutzerGruppe.BgrID", "tblItil.ItiID", "0"};
    private static final String[] COL_NAMES_ID_GROUP = new String[]{", tblRessourcen.ResID", ", tblPrioritaeten.PriID", ", tblKlasse.KlaID", "", ", tblGebaeude.GebID", ", tblBenutzerGruppe.BgrID", ", tblItil.masterTyp, tblItil.ItiID", ""};
    private static final String PREFIX = "SELECT DISTINCT ";
    private static final String PRIM_BEZEICHNUNG = " as p, ";
    private static final String SEQU_BEZEICHNUNG = " as s, ";
    private static final String PRIM_ID = " as pID, ";
    private static final String MITTE_ITIL = " as sID, count(*) as anzahl, tblItil.masterTyp FROM tblBuendel, tblSearchresult";
    private static final String MITTE_OHNE_ITIL = " as sID, count(*) as anzahl FROM tblBuendel, tblSearchresult";
    private static final String START_WHERE = " WHERE tblSearchresult.SearchID = ? AND tblBuendel.BunID = tblSearchresult.BunID AND  tblBuendel.BunID = tblAuftraege.BunID AND tblAuftraege.Master <> 0";
    private static final int SET_STATUS_PROCESS_FLAG_POSITION = 0;
    private static final int SET_STATUS_STATUS_POSITION = 1;
    private static final int SET_STATUS_BUNID_POSITION = 2;
    private static final int SET_STATUS_MAILING_FLAG_POSITION = 3;
    private static final int SET_STATUS_PROCESSOR_USRID_POSITION = 4;
    private static final int SET_CURRENT_USRID_POSITION = 5;
    private final boolean pseudoUsername;
    private Statement st = null;
    private PreparedStatement pst = null;
    private Connection con;
    private int rsTyp;
    private int rsConc;
    private int maxRows = 0;
    private String sqlQuery;
    private String name;
    private boolean isSearchCmd;
    private ArrayList<String> parName = null;
    private ArrayList<Object> parValue;
    private int[] intParams = null;
    private String param;
    private boolean notifiedByController;
    private static TypespecificIntMap<Searcher> searches = new TypespecificIntMap();
    private static LockController controller = new LockController();

    public SpecialSqlCommand(Connection con, String commandName, String query, int rsType, int rsConcur, boolean isSearch, int intParamCount, boolean pseudoUsername) {
        this.pseudoUsername = pseudoUsername;
        this.con = con;
        this.sqlQuery = query;
        this.rsTyp = rsType;
        this.rsConc = rsConcur;
        this.isSearchCmd = isSearch;
        this.name = commandName;
        if (intParamCount > 0) {
            this.intParams = new int[intParamCount];
        } else {
            this.parName = new ArrayList();
            this.parValue = new ArrayList();
        }
    }

    public SpecialSqlCommand(Connection con, String commandName, String query, boolean isSearch, int intParamCount) {
        this(con, commandName, query, -1, 0, isSearch, intParamCount, false);
    }

    public SpecialSqlCommand(Connection con, String commandName, String query, boolean isSearch, int intParamCount, boolean pseudoUsername) {
        this(con, commandName, query, -1, 0, isSearch, intParamCount, pseudoUsername);
    }

    public void setInt(int intIndex, int x) {
        this.intParams[intIndex - 1] = x;
    }

    public void setString(int objectIndex, String value) throws SQLException {
        this.param = value;
    }

    public void setObject(String paramName, Object value) throws SQLException {
        int searchInt = this.parName.indexOf(paramName.toUpperCase());
        if (searchInt > -1) {
            this.parValue.set(searchInt, value);
        } else {
            this.parName.add(paramName.toUpperCase());
            this.parValue.add(value);
        }
    }

    public void setMaxRows(int maxRs) {
        this.maxRows = maxRs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internally created statement")
    public ResultSet executeQuery() throws SQLException {
        long start;
        ResultSet rs;
        block25: {
            rs = null;
            start = System.currentTimeMillis();
            if (this.isSearchCmd) {
                try {
                    SpecialSqlCommand specialSqlCommand = this;
                    synchronized (specialSqlCommand) {
                        if (controller.mustLock(this)) {
                            try {
                                HDLogger.warn("Searcher busy, max concurrent searchers: " + LockController.MAX_THREADS + ", search requests active: " + SpecialSqlCommand.controller.locks.size() + " (increase max memory for server to allow more concurrent search requests) ");
                                ((Object)((Object)this)).wait(25000L);
                                if (!this.notifiedByController) {
                                    HDLogger.warn("Searcher request interrupted, server is busy");
                                    throw new SQLException("Searcher is busy, please try again later.");
                                }
                            }
                            catch (InterruptedException e) {
                                throw new SQLException(e);
                            }
                        }
                    }
                    int searchID = this.performSearchAndStoreResult();
                    if (this.sqlQuery.equals("MetaTreeSearch")) {
                        this.sqlQuery = this.buildTreeQuery((Integer)this.parValue.get(this.parName.indexOf("TYP")));
                    }
                    this.pst = this.rsTyp != -1 ? this.con.prepareStatement(this.sqlQuery, this.rsTyp, this.rsConc) : this.con.prepareStatement(this.sqlQuery);
                    this.pst.setQueryTimeout(this.getQueryTimeout());
                    if (this.maxRows > 0) {
                        this.pst.setMaxRows(this.maxRows);
                    }
                    this.pst.setInt(1, searchID);
                    try {
                        rs = DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> this.pst.executeQuery());
                        break block25;
                    }
                    catch (SQLException sqex) {
                        HDLogger.warn(sqex);
                        throw sqex;
                    }
                }
                finally {
                    controller.searchEnded(this);
                }
            }
            try {
                this.st = this.rsTyp != -1 ? this.con.createStatement(this.rsTyp, this.rsConc) : this.con.createStatement();
                this.st.setQueryTimeout(this.getQueryTimeout());
                if (this.name.equals("UserFilter")) {
                    int searchCount = this.intParams[0];
                    boolean isLastSearch = true;
                    if (searchCount < 0) {
                        isLastSearch = false;
                        searchCount *= -1;
                    }
                    this.sqlQuery = isLastSearch ? "SELECT UsrID FROM tblUser WHERE geloescht = 0 AND UsrID > 1 ORDER BY UsrID DESC" : "SELECT UsrID FROM((SELECT tblUser.UsrID, 0 AS Expr FROM tblUser WHERE tblUser.geloescht = 0 AND tblUser.UsrID NOT IN (SELECT UsrID FROM tblAuftraege))UNION ALL (SELECT tblUser.UsrID, MIN(tblAuftraege.AufID) AS Expr FROM tblAuftraege INNER JOIN tblUser ON tblAuftraege.UsrID = tblUser.UsrID WHERE tblUser.geloescht = 0 GROUP BY tblUser.UsrID))tbl WHERE tbl.UsrID NOT IN ((SELECT tblAuftraege.UsrID FROM tblAuftraege INNER JOIN tblBuendel ON tblAuftraege.BunID = tblBuendel.BunID WHERE tblBuendel.Status > - 1 AND tblBuendel.Status < 300) UNION ALL (SELECT tblUser.UsrID FROM tblUser INNER JOIN tblRessourcenUser ON tblUser.UsrID = tblRessourcenUser.UsrID INNER JOIN tblRessourcen ON tblRessourcenUser.ResID = tblRessourcen.ResID WHERE tblRessourcen.geloescht = 0)) GROUP BY tbl.UsrID ORDER BY MIN(tbl.Expr)";
                    this.st.setMaxRows(searchCount);
                    rs = DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> this.st.executeQuery(this.sqlQuery));
                } else {
                    if (this.maxRows > 0) {
                        this.st.setMaxRows(this.maxRows);
                    }
                    this.sqlQuery = this.getQuery();
                    rs = DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> this.st.executeQuery(this.sqlQuery));
                }
                HDLogger.debug(this.sqlQuery);
            }
            catch (SQLException sqex) {
                HDLogger.warn(sqex);
                throw sqex;
            }
        }
        if (System.currentTimeMillis() - start > 1000L) {
            StringBuilder buf = new StringBuilder("Execution: ");
            buf.append(this.name).append(" duration: ").append(System.currentTimeMillis() - start).append("ms");
            if (this.parName != null) {
                for (int i = 0; i < this.parName.size(); ++i) {
                    buf.append("\n   ").append(this.parName.get(i)).append("-").append(this.parValue.get(i));
                }
            }
            HDLogger.warn(buf.toString());
        }
        if (this.sqlQuery != null && this.sqlQuery.contains(" as UserID") || this.pseudoUsername) {
            return new NoUpdateResultSet(new UserNameMappingResultSet(rs, "UserID"));
        }
        return new NoUpdateResultSet(rs);
    }

    private int performSearchAndStoreResult() throws SQLException {
        int searchID;
        SearcherImpl searcher = this.getSearcher();
        String where = (String)this.parValue.get(this.parName.indexOf("WHERE"));
        String idString = (String)this.parValue.get(this.parName.indexOf("PARAM1"));
        String searchIn = null;
        int columnIndex = this.parName.indexOf("SEARCHIN");
        if (columnIndex >= 0) {
            searchIn = (String)this.parValue.get(columnIndex);
        }
        int position = idString.indexOf(59);
        if (where == null || where.length() == 0) {
            throw new SQLException("Empty Parameter");
        }
        if (where.startsWith("YYY")) {
            searchID = Integer.parseInt(idString.substring(0, position));
            this.registerSearch(searchID, searcher);
            String masterID = idString.substring(position + 1);
            searchID = searcher.prepareItilProblemSearch(this.con, searchID, masterID, where.substring(3));
        } else {
            int wo = -1;
            String searchQuery = null;
            if (position == -1) {
                searchID = Integer.parseInt(idString);
            } else {
                searchID = Integer.parseInt(idString.substring(0, position));
                if (searchIn != null) {
                    wo = Integer.parseInt(searchIn);
                    searchQuery = idString.substring(position + 1, idString.length());
                } else {
                    wo = Integer.parseInt(idString.substring(idString.length() - 1));
                    searchQuery = idString.substring(position + 1, idString.length() - 1);
                }
            }
            this.registerSearch(searchID, searcher);
            searchID = searcher.prepareSearch(this.con, searchID, wo, searchQuery, where);
        }
        return searchID;
    }

    protected SearcherImpl getSearcher() {
        return new SearcherImpl();
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internally created statement")
    public int executeUpdate() throws SQLException {
        if (this.name.equals("SetBuendelStatus")) {
            GUID id = this.intParams[5] <= 0 ? null : HDUsersAndGroups.getUserAccount(this.intParams[5]).getID();
            try (UserAccountScope scope = id == null ? UserAccountScope.createPrivileged() : UserAccountScope.create((GUID)id);){
                int mailType = this.intParams[3];
                boolean sendAutoMailsForSlaveTickets = mailType == 4 || mailType == 16;
                ArrayList slaveTicketIDs = new ArrayList();
                if (this.intParams[0] > -1) {
                    TicketVO t = TicketManager.getReaderForSystem().getTicket(this.intParams[2]);
                    int resultStatus = this.intParams[1];
                    int oldStatusID = t.getStatusID();
                    boolean onlyReadUnreadChange = (oldStatusID == 100 || oldStatusID == 101) && resultStatus == 103 || resultStatus == 100 && oldStatusID == 103;
                    TicketManipulatorBackdoor.getBackdoor().updateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(this.intParams[2], () -> {
                        ArrayList<AuftragsReferenz> subOrderRefs;
                        Auftrag ticket;
                        if (TicketManager.getReaderForSystem().getTicket(this.intParams[2]).isInquiry() && resultStatus >= 100 && resultStatus < 300) {
                            PreparedStatement autorisierenReaIdPreparer = this.con.prepareStatement("UPDATE tblAuftraege SET AutorisierenReaID = -1 WHERE BunID = ?");
                            autorisierenReaIdPreparer.setInt(1, this.intParams[2]);
                            autorisierenReaIdPreparer.execute();
                        }
                        this.pst = this.con.prepareStatement(this.sqlQuery);
                        this.pst.setQueryTimeout(this.getQueryTimeout());
                        this.pst.setInt(1, this.intParams[1]);
                        this.pst.setInt(2, this.intParams[2]);
                        DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> {
                            this.pst.execute();
                            return null;
                        });
                        if (this.intParams[1] >= 300 && (ticket = ServerUtilities.getOpenOrderController().getAuftrag(this.intParams[2])) instanceof AuftragWithReferences && (subOrderRefs = ((AuftragWithReferences)ticket).getSubOrderReferences()) != null) {
                            try {
                                this.pst.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            this.pst = this.con.prepareStatement("UPDATE tblBuendel SET Status = ? WHERE BunID = ?");
                            for (AuftragsReferenz subOrderRef : subOrderRefs) {
                                TicketVO slave;
                                this.pst.setInt(1, this.intParams[1]);
                                this.pst.setInt(2, subOrderRef.getReferencedTicketId());
                                DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> {
                                    this.pst.execute();
                                    return null;
                                });
                                if (!sendAutoMailsForSlaveTickets || (slave = TicketManager.getReaderForSystem().getTicket(subOrderRef.getReferencedTicketId())) == null || slave.isSubTicketInWorkflow()) continue;
                                slaveTicketIDs.add(slave.getID());
                            }
                        }
                        return null;
                    }, onlyReadUnreadChange);
                }
                int ticketID = this.intParams[2];
                int processorID = this.intParams[4];
                int version = OpenOrderController.getCurrentVersion();
                AutoMailSender.sendIfNeeded(ticketID, mailType, this.param);
                ServerUtilities.getOpenOrderController().notifyResourceIfNeeded(ticketID, mailType, processorID);
                Iterator iterator = slaveTicketIDs.iterator();
                while (iterator.hasNext()) {
                    int slaveID = (Integer)iterator.next();
                    AutoMailSender.sendIfNeeded(slaveID, mailType, this.param);
                }
                int n = version;
                return n;
            }
        }
        this.st = this.rsTyp != -1 ? this.con.createStatement(this.rsTyp, this.rsConc) : this.con.createStatement();
        this.st.setQueryTimeout(this.getQueryTimeout());
        String query = this.getQuery();
        if (query.toLowerCase().contains("update tblauftraege") || query.toLowerCase().contains("update tblbuendel")) {
            throw new UnsupportedOperationException("Must add the ticketID to notify Ticketmanager");
        }
        return DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> this.st.executeUpdate(query));
    }

    public boolean execute() throws SQLException {
        boolean success = false;
        if (this.name.equals("cancelSearchExecution")) {
            HDLogger.debug("try to cancel search " + new Date());
            this.registerSearch(this.intParams[0], null);
        }
        return success;
    }

    private String getQuery() throws SQLException {
        StringBuffer finalSQL = new StringBuffer();
        int lastIndex = 0;
        int nextIndex = this.sqlQuery.indexOf(37);
        while (nextIndex >= 0) {
            finalSQL.append(this.sqlQuery.substring(lastIndex, nextIndex));
            lastIndex = nextIndex;
            if ((nextIndex = this.sqlQuery.indexOf(37, lastIndex + 1)) < 0) continue;
            String teilstring = this.sqlQuery.substring(lastIndex + 1, nextIndex).toUpperCase();
            if (this.parName.indexOf(teilstring) < 0) {
                throw new SQLException("Parameter " + teilstring + " not found in Query\n" + this.sqlQuery);
            }
            Object wert = this.parValue.get(this.parName.indexOf(teilstring));
            if (wert instanceof String) {
                String USERNAME_LIKE = "username like '";
                int usernameIndex = ((String)wert).toLowerCase().indexOf("username like '");
                int percentIndex = ((String)wert).lastIndexOf("%'");
                if (percentIndex > usernameIndex && usernameIndex > -1) {
                    String likeString = ((String)wert).substring(usernameIndex + "username like '".length(), percentIndex);
                    SearchResult searchResult = UserManager.getInstance().search(likeString, new ArrayList(), new ArrayList(), 10, new SearchID((Object)((Object)((Object)this)).hashCode()));
                    if (searchResult.getEntries().size() > 0) {
                        String result = searchResult.getEntries().stream().map(sre -> "" + sre.getId()).collect(Collectors.joining(","));
                        wert = "UserUUID in (" + result + ")";
                    } else {
                        wert = "1 = 0";
                    }
                }
                finalSQL.append(wert);
            } else if (wert != null) {
                finalSQL.append(wert.toString());
            }
            lastIndex = nextIndex + 1;
            nextIndex = this.sqlQuery.indexOf(37, lastIndex);
        }
        if (lastIndex < this.sqlQuery.length()) {
            finalSQL.append(this.sqlQuery.substring(lastIndex));
        }
        return finalSQL.toString();
    }

    private void registerSearch(int searchID, Searcher searcher) {
        Searcher oldSearcher = searches.get(searchID);
        if (oldSearcher != null && !oldSearcher.isFinished()) {
            oldSearcher.cancelSearch();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            HDLogger.debug(searchID + " search canceled " + new Date());
        }
        if (searcher != null) {
            searches.put(searchID, searcher);
        } else {
            searches.remove(searchID);
        }
    }

    public void close() throws SQLException {
        int[] ids;
        controller.searchEnded(this);
        if (this.pst != null) {
            try {
                this.pst.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.st != null) {
            try {
                this.st.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        for (int id : ids = searches.getAllKeys()) {
            Searcher searcher = searches.get(id);
            if (searcher == null || !searcher.isFinished()) continue;
            searches.remove(id);
        }
    }

    private String buildTreeQuery(int typ) {
        if (colNamesBez[7].length() == 0) {
            if (ServerUtilities.HD_db_Typ == 2) {
                SpecialSqlCommand.sortOrderMS[7] = SpecialSqlCommand.colNamesBez[7] = "ISNULL(" + ServerUtilities.getOpenOrderController().getUserViewField() + ", '')";
            } else if (ServerUtilities.HD_db_Typ == 4) {
                SpecialSqlCommand.sortOrderMysql[7] = SpecialSqlCommand.colNamesBez[7] = "COALESCE(" + ServerUtilities.getOpenOrderController().getUserViewField() + ", '')";
            } else {
                SpecialSqlCommand.colNamesBez[7] = ServerUtilities.getOpenOrderController().getUserViewField();
                SpecialSqlCommand.sortOrderOra[7] = "NVL(" + ServerUtilities.getOpenOrderController().getUserViewField() + ",' ')";
            }
        }
        int primTyp = typ / 10;
        int sequTyp = typ % 10;
        StringBuffer finalSQL = new StringBuffer(PREFIX);
        finalSQL.append(colNamesBez[primTyp - 1]).append(PRIM_BEZEICHNUNG).append(colNamesBez[sequTyp - 1]).append(SEQU_BEZEICHNUNG).append(COL_NAMES_ID[primTyp - 1]).append(PRIM_ID).append(COL_NAMES_ID[sequTyp - 1]).append(primTyp == 7 || sequTyp == 7 ? MITTE_ITIL : MITTE_OHNE_ITIL);
        if (primTyp == 1 || sequTyp == 1) {
            finalSQL.append(", tblRessourcen");
        }
        if (primTyp == 2 || sequTyp == 2) {
            finalSQL.append(", tblPrioritaeten");
        }
        if (primTyp == 3 || sequTyp == 3) {
            finalSQL.append(", tblKlasse");
        }
        if (primTyp == 7 || sequTyp == 7) {
            finalSQL.append(", tblItil");
        }
        boolean needJoinToUser = false;
        boolean needJoinToGebaeude = false;
        boolean needJoinToBenutzerGruppe = false;
        if (primTyp == 5 || primTyp == 6 || sequTyp == 5 || sequTyp == 6) {
            needJoinToUser = true;
            if (primTyp == 5 || sequTyp == 5) {
                needJoinToGebaeude = true;
            }
            if (primTyp == 6 || sequTyp == 6) {
                needJoinToBenutzerGruppe = true;
            }
        } else if ((primTyp == 8 || sequTyp == 8) && ServerUtilities.getOpenOrderController().isUserViewField()) {
            needJoinToUser = true;
        }
        finalSQL.append(", tblAuftraege");
        if (needJoinToUser) {
            finalSQL.append(" LEFT OUTER JOIN tblUser tblUser ON tblAuftraege.UsrID = tblUser.UsrID ");
        }
        if (needJoinToGebaeude) {
            finalSQL.append(" LEFT OUTER JOIN tblGebaeude tblGebaeude ON tblUser.GebID = tblGebaeude.GebID ");
        }
        if (needJoinToBenutzerGruppe) {
            finalSQL.append(" LEFT OUTER JOIN tblBenutzerGruppe tblBenutzerGruppe ON tblUser.BgrID = tblBenutzerGruppe.BgrID ");
        }
        finalSQL.append(START_WHERE);
        if (primTyp == 1 || sequTyp == 1) {
            finalSQL.append(" AND tblAuftraege.ResID = tblRessourcen.ResID");
        }
        if (primTyp == 2 || sequTyp == 2) {
            finalSQL.append(" AND tblAuftraege.PriID = tblPrioritaeten.PriID");
        }
        if (primTyp == 3 || sequTyp == 3) {
            finalSQL.append(" AND tblAuftraege.KlaID = tblKlasse.KlaID");
        }
        if (primTyp == 7 || sequTyp == 7) {
            finalSQL.append(" AND tblAuftraege.ItiID = tblItil.ItiID");
        }
        String[] sortArray = ServerUtilities.HD_db_Typ == 3 ? sortOrderOra : (ServerUtilities.HD_db_Typ == 4 ? sortOrderMysql : sortOrderMS);
        String strOrder = sortArray[primTyp - 1] + SORT_ORDER_ID[primTyp - 1] + ", " + sortArray[sequTyp - 1] + SORT_ORDER_ID[sequTyp - 1];
        String strGroup = colNamesBez[primTyp - 1] + COL_NAMES_ID_GROUP[primTyp - 1] + ", " + colNamesBez[sequTyp - 1] + COL_NAMES_ID_GROUP[sequTyp - 1];
        finalSQL.append(" GROUP BY ").append(strGroup).append(" ORDER BY ").append(strOrder);
        return finalSQL.toString();
    }

    private static class LockController {
        private List<SpecialSqlCommand> locks = new ArrayList<SpecialSqlCommand>();
        private static final int MAX_THREADS = (int)Math.min(20L, Math.max(1L, Math.round((double)Runtime.getRuntime().maxMemory() / 6.291456E7)));

        private LockController() {
        }

        public synchronized boolean mustLock(SpecialSqlCommand threadLock) {
            try {
                boolean bl = this.locks.size() >= MAX_THREADS;
                return bl;
            }
            finally {
                this.locks.add(threadLock);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void searchEnded(SpecialSqlCommand monitor) {
            this.locks.remove((Object)monitor);
            if (this.locks.size() >= MAX_THREADS) {
                SpecialSqlCommand specialSqlCommand = monitor = this.locks.get(MAX_THREADS - 1);
                synchronized (specialSqlCommand) {
                    monitor.notifiedByController = true;
                    ((Object)((Object)monitor)).notify();
                }
            }
        }
    }
}

