/*
 * Decompiled with CFR 0.152.
 */
package srv;

import com.inet.cache.internal.HardDiskExternalDataWriterFactory;
import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigValue;
import com.inet.config.ConfigurationManager;
import com.inet.error.ErrorCode;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionCreationListener;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ServerInitializerStatus;
import com.inet.helpdesk.core.data.ServerSQLCommandFactory;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.HelpDeskServerException;
import com.inet.helpdesk.core.utils.ClientScriptsWriter;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.helpdesk.ticketmanager.adapt.UpdateTicketCommandFactory;
import com.inet.jj.srv.JJServer;
import com.inet.jj.srv.JavaCommandFactory;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ServerPluginManagerListener;
import com.inet.plugin.veto.VetoManager;
import com.inet.plugin.veto.VetoPower;
import com.inet.plugin.veto.VetoSemaphore;
import com.inet.plugin.veto.VetoStatus;
import com.inet.plugin.veto.VetoType;
import com.inet.search.veto.SearchIndexVetoPower;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import srv.AktualisierungCommandFactory;
import srv.AutoTextCommandFactory;
import srv.ChangeReaTimeCommandFactory;
import srv.DatabaseCommandFactory;
import srv.HdLicenseObserver;
import srv.ItilCommandFactory;
import srv.JavaCommandFactoryDelegator;
import srv.KonnektorPort;
import srv.MailFactory;
import srv.MailSendCommandFactory;
import srv.NewOrderCommandFactory;
import srv.NewTicketModificationCommandFactory;
import srv.PseudoUsernameCommandFactory;
import srv.ResultSetCommandFactory;
import srv.ServerConnectsFactory;
import srv.ServerUtilities;
import srv.SpecialSqlCommandFactory;
import srv.TicketStateCommandFactory;
import srv.UserSearchCommandFactory;
import srv.UserSearchFetchCommandFactory;
import srv.WorkflowAddOrderCommandFactory;
import srv.commands.BGAddUserCommand;
import srv.commands.BgDeleteCommand;
import srv.commands.SimpleJavaCommandFactory;
import srv.controller.OpenOrderController;

public class ServerInitializer
implements ServerInitializerStatus,
ServerPluginManagerListener,
VetoPower {
    private final VetoSemaphore dbConnectionVeto;
    private static Vector<String> specialCommands;
    protected static ServerInitializer instance;
    private static final ConfigValue<DatabaseConfigInfoList> DB_LIST;
    protected boolean serverInterrupted;
    private I18nMessages msg = new I18nMessages(ServerUtilities.hdsLangRess.getBaseBundleName(), (Object)this);
    private boolean isConnectionInitted;

    protected ServerInitializer() {
        this.dbConnectionVeto = new VetoSemaphore(this.msg);
        this.dbConnectionVeto.setStatusMessage("NoConnYet", new String[0]);
        this.dbConnectionVeto.setStatusPercentage(10);
    }

    public static ServerInitializer getInstance() {
        if (instance == null) {
            instance = new ServerInitializer();
        }
        return instance;
    }

    @Override
    public VetoStatus getCurrentVeto() {
        if (this.serverInterrupted) {
            return new VetoStatus(this.msg.getMsg("ServerStopped", new Object[0]), 0);
        }
        VetoManager vetoManager = VetoManager.getInstance();
        if (!vetoManager.isCurrentlyVetoed()) {
            return null;
        }
        return vetoManager.getCurrentVeto();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interruptExecution() {
        Class<JJServer> clazz = JJServer.class;
        synchronized (JJServer.class) {
            this.serverInterrupted = true;
            if (ServerUtilities.jjserverStart > 0L) {
                ServerUtilities.jjserverStart = 0L;
                ServerUtilities.getJJServer().stop();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void start() {
        try {
            if (this.serverInterrupted) {
                return;
            }
            this.setPortNo();
            ServerUtilities.getJJServer();
        }
        catch (Throwable e) {
            HDLogger.error(e);
        }
        if (this.serverInterrupted) {
            return;
        }
        HDLogger.info("TCP/IP port: " + ServerUtilities.GUI_PORT.get() + "\n");
        this.dbConnectionVeto.setStatusPercentage(30);
        try {
            long freeSpace = HardDiskExternalDataWriterFactory.freeSpace((File)HardDiskExternalDataWriterFactory.getDefaultDir());
            if (freeSpace > 0L && freeSpace < 0x40000000L) {
                throw new IllegalStateException("Not enough free disk space. 1GB is minimum for hard disk cache. Current free space is: " + freeSpace + " Location: " + HardDiskExternalDataWriterFactory.getDefaultDir());
            }
        }
        catch (Throwable e) {
            HDLogger.error(e);
            ServerUtilities.serverInterface.errorExit(616, "Server start failed");
        }
    }

    public void vetoFinished(VetoType type) {
        if (type == null) {
            this.startAdditionalParts();
        } else if (type == SearchIndexVetoPower.TYPE) {
            HdLicenseObserver.addLicenseData(new Properties(), null);
        }
    }

    protected void startAdditionalParts() {
        ForkJoinPool.commonPool().execute(() -> {
            try (Connection con2 = ServerUtilities.getJJServer().getConnection("HDS");){
                OpenOrderController ticketController = ServerUtilities.getOpenOrderController();
                ticketController.checkAllOrders(con2);
            }
            catch (SQLException e) {
                HDLogger.error(e);
            }
        });
    }

    private void notifyConnectionListeners() {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        try {
            ConnectionFactory conFactory = (ConnectionFactory)spm.getSingleInstance(ConnectionFactory.class);
            try (Connection con = conFactory.getConnection();){
                HDLogger.debug("initialized connection factory with valid connection");
            }
        }
        catch (SQLException e) {
            HDLogger.error(e);
        }
        List listeners = spm.get(ConnectionCreationListener.class);
        for (ConnectionCreationListener l : listeners) {
            l.connectionCreated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean init() {
        int counter = 0;
        Connection con = null;
        boolean started = false;
        while (true) {
            try {
                ServerUtilities.systemOut(counter + 1 + ". Versuch eine Verbindung zur Datenbank aufzubauen.", null, "");
                DatabaseConfigInfoList dbList = (DatabaseConfigInfoList)DB_LIST.get();
                Collections.sort(dbList, new Comparator<DatabaseConfigInfo>(){

                    @Override
                    public int compare(DatabaseConfigInfo o1, DatabaseConfigInfo o2) {
                        return o1.getDbName().compareTo(o2.getDbName());
                    }
                });
                for (DatabaseConfigInfo db : dbList) {
                    ServerUtilities.addAsUserDataSource(db.getDbName());
                }
                con = ServerUtilities.getJJServer().getConnection("HDS");
                DatabaseConfigInfo hds = ((DatabaseConfigInfoList)DB_LIST.get()).get("HDS");
                if (hds == null) {
                    throw new IllegalStateException("ListeningServerSocket: No HDS datasource!");
                }
                DatabaseMetaData dbmd = con.getMetaData();
                String dbName = dbmd.getDatabaseProductName().toLowerCase();
                if (dbName.equals("mysql")) {
                    ServerUtilities.setDatabaseType(4);
                } else if (dbName.startsWith("oracle")) {
                    ServerUtilities.setDatabaseType(3);
                } else {
                    ServerUtilities.setDatabaseType(2);
                }
                Statement st = null;
                ResultSet rs = null;
                try {
                    st = con.createStatement();
                    rs = st.executeQuery("SELECT * FROM tblOptionen");
                    rs.next();
                    int release = rs.getInt("Release");
                    HDLogger.debug("Release: " + release + " - " + ServerUtilities.getCurrentRelease());
                    if (release != ServerUtilities.getCurrentRelease()) {
                        HDLogger.error("Error database version is incompatible to program version!");
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            st.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            con.close();
                            throw new IllegalStateException(ServerUtilities.hdsLangRess.getString("DienstNotInitDBMsg"));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        throw new IllegalStateException(ServerUtilities.hdsLangRess.getString("DienstNotInitDBMsg"));
                    }
                    HDLogger.info("Database:         " + dbmd.getDatabaseProductName() + "  " + dbmd.getDatabaseProductVersion());
                    HDLogger.info("Driver:           " + dbmd.getDriverName() + "  " + dbmd.getDriverVersion() + "\n");
                    started = true;
                    break;
                }
                catch (SQLException e) {
                    HDLogger.error(new HelpDeskServerException((Throwable)e, (ErrorCode)HelpDeskErrorCodes.SQL_CONNECTION_INIT_ERROR));
                    throw new IllegalStateException(ServerUtilities.hdsLangRess.getString("DienstNotInitDBMsg"));
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        st.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable e) {
                try {
                    ServerUtilities.systemOut(++counter + ". Aufbauversuch gescheitert.", new HelpDeskServerException(e, (ErrorCode)HelpDeskErrorCodes.SQL_CONNECTION_INIT_ERROR), "");
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (instance == this) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        con.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        try {
            con.close();
            return started;
        }
        catch (Throwable throwable) {
            return started;
        }
    }

    private static void specialCommands() {
        specialCommands = new Vector();
        specialCommands.addElement("SetBuendelStatus");
        specialCommands.addElement("AdminEdit_IS");
        specialCommands.addElement("BuendelSelektion");
        specialCommands.addElement("ChangeUser");
        specialCommands.addElement("GeraeteDelete");
        specialCommands.addElement("GeraeteUserChange");
        specialCommands.addElement("GeraeteBestandSelect");
        specialCommands.addElement("GeraeteBestandTest");
        specialCommands.addElement("ItilAllKnownProblems");
    }

    private static List<String> updateTicket_Commands() {
        return new ArrayList<String>(){
            {
                this.add("ChangeAction");
                this.add("changeRessource");
                this.add("ChangeUsrID");
                this.add("letzterBearbeiter");
                this.add("letzterBearbeiterIndex");
                this.add("SetTerminVereinbarung");
                this.add("SetWiedervorlage");
                this.add("WeitereFelder");
                this.add("Annotation");
            }
        };
    }

    private static void initCommands(Connection con) throws Exception {
        String commandName;
        Statement st = null;
        ResultSet rs = null;
        st = con.createStatement();
        rs = st.executeQuery("SELECT AbfrageID, Abfrage FROM tblQueries");
        List<String> updateTicket_Commands = ServerInitializer.updateTicket_Commands();
        while (rs.next()) {
            commandName = rs.getString(1);
            String query = rs.getString(2);
            if (commandName.equals("AdminEdit_Daten1")) {
                ServerUtilities.getJJServer().addCommand(commandName, (JavaCommandFactory)new PseudoUsernameCommandFactory(query));
                continue;
            }
            if (commandName.equals("BGBuendel")) {
                ServerUtilities.getJJServer().addCommand(commandName, (JavaCommandFactory)new PseudoUsernameCommandFactory(query));
                continue;
            }
            if (commandName.equals("DispatcherData")) {
                ServerUtilities.getJJServer().addCommand(commandName, (JavaCommandFactory)new PseudoUsernameCommandFactory(query));
                continue;
            }
            if (commandName.equals("User_ID")) {
                ServerUtilities.getJJServer().addCommand(commandName, (JavaCommandFactory)new PseudoUsernameCommandFactory(query));
                continue;
            }
            if (commandName.equals("UserBuendel")) {
                ServerUtilities.getJJServer().addCommand(commandName, (JavaCommandFactory)new PseudoUsernameCommandFactory(query));
                continue;
            }
            if (commandName.equals("UsersSelect")) {
                ServerUtilities.getJJServer().addCommand(commandName, (JavaCommandFactory)new PseudoUsernameCommandFactory(query));
                continue;
            }
            if (specialCommands.indexOf(commandName) > -1) {
                if (commandName.equals("SetBuendelStatus")) {
                    ServerUtilities.getJJServer().addCommand(commandName, (JavaCommandFactory)new SpecialSqlCommandFactory(commandName, query, false, 6));
                    ServerUtilities.getJJServer().addCommand("SetSlaveStatus", (JavaCommandFactory)new UpdateTicketCommandFactory(query));
                    continue;
                }
                if (commandName.equals("GeraeteBestandTest")) {
                    ServerUtilities.getJJServer().addCommand(commandName, (JavaCommandFactory)new SpecialSqlCommandFactory(commandName, query, false, 0, true));
                    continue;
                }
                if (commandName.equals("BuendelSelektion")) {
                    ServerUtilities.getJJServer().addCommand(commandName, (JavaCommandFactory)new SpecialSqlCommandFactory(commandName, query, false, 0, true));
                    continue;
                }
                if (commandName.equals("AdminEdit_IS")) {
                    ServerUtilities.getJJServer().addCommand(commandName, (JavaCommandFactory)new SpecialSqlCommandFactory(commandName, query, false, 0, true));
                    continue;
                }
                ServerUtilities.getJJServer().addCommand(commandName, (JavaCommandFactory)new SpecialSqlCommandFactory(commandName, query, commandName.startsWith("AdminEdit_S"), 0));
                continue;
            }
            if (updateTicket_Commands.contains(commandName)) {
                ServerUtilities.getJJServer().addCommand(commandName, (JavaCommandFactory)new UpdateTicketCommandFactory(query));
                continue;
            }
            if (commandName.equals("QuickTicket") || commandName.equals("QuickSelect")) {
                ServerUtilities.getJJServer().addCommand(commandName, (JavaCommandFactory)new ResultSetCommandFactory(commandName));
                continue;
            }
            if (commandName.equals("AdminEdit_IO")) continue;
            ServerUtilities.getJJServer().addCommand(commandName, query);
        }
        try {
            rs.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            st.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ServerUtilities.getJJServer().addCommand("UserSearch", (JavaCommandFactory)new SpecialSqlCommandFactory("UserSearch", "SELECT UsrID, UsrID as UserID, Nachname, Vorname, Email, Telefon, Abteilung, Zimmer, Kostenstelle, Computername, Frei1, Frei2, Frei3, Frei4, Frei5, Frei6, GebID, BgrID, SprID, geloescht FROM tblUser WHERE %where%", false, 0, true));
        ServerUtilities.getJJServer().addCommand("Jtapi_Termial_Count", (JavaCommandFactory)new ResultSetCommandFactory("Jtapi_Termial_Count"));
        ServerUtilities.getJJServer().addCommand("DeleteSubCategories", (JavaCommandFactory)new SpecialSqlCommandFactory("DeleteSubCategories", "UPDATE tblBetreffs SET geloescht = 1 WHERE BetID IN (%BetIDs%)", false, 0));
        ServerUtilities.getJJServer().addCommand("cancelSearchExecution", (JavaCommandFactory)new SpecialSqlCommandFactory("cancelSearchExecution", null, false, 1));
        ServerUtilities.getJJServer().addCommand("StatusBuendel", (JavaCommandFactory)new TicketStateCommandFactory());
        ServerUtilities.getJJServer().addCommand("New_Order", (JavaCommandFactory)new NewOrderCommandFactory());
        ServerUtilities.getJJServer().addCommand("ResMembership", "SELECT tblRessourcenUser.* FROM tblRessourcenUser, tblUser, tblRessourcen WHERE tblRessourcenUser.ResID = tblRessourcen.ResID AND tblRessourcenUser.UsrID = tblUser.UsrID AND tblUser.geloescht = 0");
        ServerUtilities.getJJServer().addCommand("ReaTextPrev", "SELECT ReaID, OrgBunID, AktID, was, ishtml, DisplayName, EndZeit, AttAufID, Description From tblRealisierung Where (OrgBunID = ? OR (BunID = ? AND bundleVisible > ?)) AND ReaID >= ? ORDER BY EndZeit DESC");
        ServerUtilities.getJJServer().addCommand("DeviceCount", "SELECT count(*) FROM tblGeraeteBestand");
        ServerUtilities.getJJServer().addCommand("HistorieUserBuendel", (JavaCommandFactory)new SpecialSqlCommandFactory("HistorieUserBuendel", "SELECT tblAuftraege.AufID, tblAuftraege.ResID, tblAuftraege.Master, tblAuftraege.DerBetreff, tblAuftraege.BetID, tblAuftraege.PriID, tblAuftraege.KlaID, tblAuftraege.ItiID, tblAuftraege.DeadlineZeit, tblAuftraege.spezFeld, tblAuftraege.AnfReaID, tblBuendel.*, tblUser.UsrID as UsrID, tblUser.UsrID as UserID, tblUser.Nachname FROM tblAuftraege, tblBuendel, tblUser WHERE tblAuftraege.UsrID = %where% AND tblBuendel.Status > 99 AND tblBuendel.Status < 400 AND tblUser.UsrID = tblAuftraege.UsrID AND tblBuendel.BunID = tblAuftraege.BunID ORDER BY tblAuftraege.AufID DESC", false, 0, true));
        ServerUtilities.getJJServer().addCommand("EMail", (JavaCommandFactory)new MailFactory());
        ServerUtilities.getJJServer().addCommand("SendMail", (JavaCommandFactory)new MailSendCommandFactory());
        ServerUtilities.getJJServer().addCommand("getDeadLine", (JavaCommandFactory)new ResultSetCommandFactory("getDeadLine"));
        ServerUtilities.getJJServer().addCommand("resetDeadline", (JavaCommandFactory)new ResultSetCommandFactory("resetDeadline"));
        ServerUtilities.getJJServer().addCommand("getFile", (JavaCommandFactory)new ResultSetCommandFactory("getFile"));
        ServerUtilities.getJJServer().addCommand("ImapAccounts", (JavaCommandFactory)new ResultSetCommandFactory("ImapAccounts"));
        ServerUtilities.getJJServer().addCommand("offene", (JavaCommandFactory)new ResultSetCommandFactory("offene"));
        ServerUtilities.getJJServer().addCommand("entbuendeln", (JavaCommandFactory)new ResultSetCommandFactory("entbuendeln"));
        ServerUtilities.getJJServer().addCommand("controller", (JavaCommandFactory)new ResultSetCommandFactory("controller"));
        ServerUtilities.getJJServer().addCommand("InstanceClose", (JavaCommandFactory)new ResultSetCommandFactory("InstanceClose"));
        ServerUtilities.getJJServer().addCommand("UserTest", (JavaCommandFactory)new ResultSetCommandFactory("UserTest"));
        ServerUtilities.getJJServer().addCommand("WorkflowAnwenden", (JavaCommandFactory)new ResultSetCommandFactory("WorkflowAnwenden"));
        ServerUtilities.getJJServer().addCommand("ITIL_EXEC", (JavaCommandFactory)new ItilCommandFactory());
        ServerUtilities.getJJServer().addCommand("TextbausteinShow", (JavaCommandFactory)new AutoTextCommandFactory());
        ServerUtilities.getJJServer().addCommand("GeraeteBestandSuchen", (JavaCommandFactory)new SpecialSqlCommandFactory("GeraeteBestandSuchen", "SELECT UserID as UsrID, UserID as UserID, tblGeraeteBestand.* FROM tblGeraeteBestand Where %Where% ORDER BY GerID", false, 0));
        ServerUtilities.getJJServer().addCommand("GeraeteBestandSuchenAttachment", (JavaCommandFactory)new SpecialSqlCommandFactory("GeraeteBestandSuchenAttachment", "SELECT tblGeraeteBestand.UserID as UsrID, tblGeraeteBestand.UserID as UserID, tblGeraeteBestand.* FROM tblGeraeteBestand INNER JOIN tblAttachments ON tblGeraeteBestand.GerID = tblAttachments.ownerId WHERE tblAttachments.type = 2 AND %Where% ORDER BY GerID", false, 0));
        ServerUtilities.getJJServer().addCommand("Telefon", (JavaCommandFactory)new SpecialSqlCommandFactory("Telefon", "SELECT Nachname, Vorname, Telefon, Email, Zimmer, Abteilung, Kostenstelle, GebID FROM tblUser WHERE geloescht = 0 %where% ORDER BY Nachname, Vorname, Telefon", false, 0));
        ServerUtilities.getJJServer().addCommand("UserFilter", (JavaCommandFactory)new SpecialSqlCommandFactory("UserFilter", "", false, 1));
        commandName = "MetaTreeSearch";
        ServerUtilities.getJJServer().addCommand(commandName, (JavaCommandFactory)new SpecialSqlCommandFactory(commandName, commandName, true, 0));
        ServerUtilities.getJJServer().addCommand("MetaUpdateCommand", (JavaCommandFactory)new DatabaseCommandFactory(1));
        ServerUtilities.getJJServer().addCommand("MetaSelectCommand", (JavaCommandFactory)new DatabaseCommandFactory(2));
        ServerUtilities.getJJServer().addCommand("MetaDeleteCommand", (JavaCommandFactory)new DatabaseCommandFactory(3));
        ServerUtilities.getJJServer().addCommand("CHECK_TICKET_ACCESS", (JavaCommandFactory)new AktualisierungCommandFactory(4));
        ServerUtilities.getJJServer().addCommand("setOffene", (JavaCommandFactory)new AktualisierungCommandFactory(1));
        ServerUtilities.getJJServer().addCommand("changePrioSettings", (JavaCommandFactory)new AktualisierungCommandFactory(2));
        ServerUtilities.getJJServer().addCommand("anfrageChanges", (JavaCommandFactory)new AktualisierungCommandFactory(7));
        ServerUtilities.getJJServer().addCommand("UserBuendelSearch", (JavaCommandFactory)new UserSearchCommandFactory(true));
        ServerUtilities.getJJServer().addCommand("BGBuendelSearch", (JavaCommandFactory)new UserSearchCommandFactory(true));
        ServerUtilities.getJJServer().addCommand("UserSearchData", (JavaCommandFactory)new UserSearchFetchCommandFactory());
        ServerUtilities.getJJServer().addCommand("WorkflowAdd", (JavaCommandFactory)new WorkflowAddOrderCommandFactory());
        ServerUtilities.getJJServer().addCommand("FetchUsers", (JavaCommandFactory)new ServerConnectsFactory());
        ServerUtilities.getJJServer().addCommand("MultiMessage", (JavaCommandFactory)new ServerConnectsFactory());
        ServerUtilities.getJJServer().addCommand("ExecuteNewTrigger", (JavaCommandFactory)new NewTicketModificationCommandFactory());
        ServerUtilities.getJJServer().addCommand("ChangeReaTime", (JavaCommandFactory)new ChangeReaTimeCommandFactory());
        if (ServerUtilities.HD_db_Typ == 3) {
            ServerUtilities.getJJServer().addCommand("NewStepAdded", "UPDATE tblBuendel SET Bearbeiter = ?, LastEditorID = ?, BearbeitungsDatum = SYSDATE, Indiziert = ?, Status = ? WHERE BunID = ?");
            ServerUtilities.getJJServer().addCommand("SetStatusAndTime", "UPDATE tblBuendel SET Status = ?, BearbeitungsDatum = SYSDATE WHERE tblBuendel.BunID = ?");
        } else if (ServerUtilities.HD_db_Typ == 4) {
            ServerUtilities.getJJServer().addCommand("NewStepAdded", "UPDATE tblBuendel SET Bearbeiter = ?, LastEditorID = ?, BearbeitungsDatum = CURRENT_TIMESTAMP(), Indiziert = ?, Status = ? WHERE BunID = ?");
            ServerUtilities.getJJServer().addCommand("SetStatusAndTime", "UPDATE tblBuendel SET Status = ?, BearbeitungsDatum = CURRENT_TIMESTAMP() WHERE tblBuendel.BunID = ?");
        } else {
            ServerUtilities.getJJServer().addCommand("NewStepAdded", "UPDATE tblBuendel SET Bearbeiter = ?, LastEditorID = ?, BearbeitungsDatum = GETDATE(), Indiziert = ?, Status = ? WHERE BunID = ?");
            ServerUtilities.getJJServer().addCommand("SetStatusAndTime", "UPDATE tblBuendel SET Status = ?, BearbeitungsDatum = GETDATE() WHERE tblBuendel.BunID = ?");
        }
        ServerUtilities.getJJServer().addCommand("BGAddUser", (JavaCommandFactory)SimpleJavaCommandFactory.of(() -> new BGAddUserCommand()));
        ServerUtilities.getJJServer().addCommand("BgDelete", (JavaCommandFactory)SimpleJavaCommandFactory.of(() -> new BgDeleteCommand()));
    }

    private void initPluginCommands() {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        List list = spm.get(ServerSQLCommandFactory.class);
        if (list != null) {
            for (ServerSQLCommandFactory factory : list) {
                ServerUtilities.getJJServer().addCommand(factory.getCommandName(), (JavaCommandFactory)new JavaCommandFactoryDelegator(factory));
            }
        }
    }

    private void setPortNo() {
        int listenerPort = (Integer)ServerUtilities.GUI_PORT.get();
        if (!ConfigurationManager.isRecoveryMode()) {
            ClientScriptsWriter.setClientPorts(String.valueOf(listenerPort));
        }
    }

    @Override
    public int getKonnektorPort() {
        return KonnektorPort.get();
    }

    public VetoSemaphore checkForVeto() {
        if (this.serverInterrupted) {
            return null;
        }
        new Thread(() -> {
            this.isConnectionInitted = this.init();
            if (this.serverInterrupted) {
                return;
            }
            if (this.isConnectionInitted) {
                this.initPluginCommands();
                this.notifyConnectionListeners();
                ServerInitializer.specialCommands();
                try {
                    Connection con = ServerUtilities.getJJServer().getConnection("HDS");
                    ServerInitializer.initCommands(con);
                    this.dbConnectionVeto.setStatusPercentage(70);
                }
                catch (Throwable e) {
                    HDLogger.error(e);
                }
                this.dbConnectionVeto.setStatusPercentage(100);
                this.dbConnectionVeto.complete(null);
            }
        }, "HelpDesk Server Initializer").start();
        return this.dbConnectionVeto;
    }

    @Nonnull
    public VetoType getType() {
        return HelpdeskServerPlugin.HD_SERVER_START;
    }

    public boolean isConnectionInitialized() {
        return this.isConnectionInitted;
    }

    static {
        DB_LIST = new ConfigValue(HDConfigKeys.DB_CONFIGS);
    }
}

