/*
 * Decompiled with CFR 0.152.
 */
package srv;

import com.inet.helpdesk.core.mail.MailSendCommandExtension;
import com.inet.helpdesk.core.mail.MailSendCommandExtensionContext;
import com.inet.helpdesk.core.mail.MailSendCommandPropertiesCreator;
import com.inet.helpdesk.core.swing.ListResultSet;
import com.inet.helpdesk.core.ticketmanager.TicketManipulatorBackdoor;
import com.inet.helpdesk.shared.util.UtilityFunctions;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.annotation.SuppressFBWarnings;
import srv.AbstractJavaCommand;
import srv.ServerUtilities;
import srv.controller.OpenOrderController;
import srv.controller.ticket.Auftrag;
import srv.controller.ticket.attributes.User;
import srv.mail.Mail;

public class MailSendCommand
extends AbstractJavaCommand {
    public static final int AKTION_EMAIL_SENDEN = -7;
    private static final int[] TYPEN_ANSWER = new int[]{4, 4, 12};
    private static final String[] COLUMNS_ANSWER = new String[]{"ReaID", "Version", "Text"};
    private int reaStepId;
    private Timestamp timeStampStart;
    private Timestamp timeStampEnd;
    private User producer;

    public MailSendCommand(Connection con) {
        super(con);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        MailSendCommandPropertiesCreator.MailSendCommandProperties properties = this.getProperties();
        this.timeStampEnd = new Timestamp(System.currentTimeMillis());
        this.timeStampStart = new Timestamp(this.timeStampEnd.getTime() - (long)(properties.getMinuten() * 60000));
        this.producer = new User(HDUsersAndGroups.getUserAccount(properties.getUser()));
        MailSendCommandExtensionContext extensionContext = this.createExtensionContext();
        int buendel = properties.getBuendel();
        int auftrag = properties.getAuftrag();
        String von = properties.getVon();
        String an = properties.getAn();
        String cc = properties.getCc();
        String bcc = properties.getBcc();
        int html = properties.getHtml();
        String subject = properties.getSubject();
        int additinalAction = properties.getAdditionalAction();
        try (UserAccountScope scope = UserAccountScope.create((GUID)this.producer.getUserUUID());){
            TicketManipulatorBackdoor.getBackdoor().updateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(auftrag, true, () -> {
                try (Statement st = this.getConnection().createStatement(1005, 1008);
                     ResultSet rs = st.executeQuery("SELECT * FROM tblRealisierung WHERE 1=0");){
                    String content = extensionContext.getContent();
                    int attAufID = extensionContext.getAttAufID();
                    this.reaStepId = ServerUtilities.addRealisierung(null, rs, buendel, auftrag, -7, this.getIntValueForKey("ResID", 0), this.timeStampStart, this.timeStampEnd, this.get("Stundensatz"), this.producer.getUsrID(), this.producer.getDisplayName(), von, an, cc, bcc, attAufID, content, html, subject, null);
                    for (MailSendCommandExtension extension : ServerPluginManager.getInstance().get(MailSendCommandExtension.class)) {
                        extension.extend(extensionContext, this.reaStepId, properties, ServerUtilities.serverLocale);
                    }
                    String updatedContent = extensionContext.getContent();
                    int updatedAttAufID = extensionContext.getAttAufID();
                    this.updateReaStepIfDataChangedByExtension(rs, content, attAufID, updatedContent, updatedAttAufID);
                    if (properties.getResultingStatus() == 293) {
                        ServerUtilities.addRealisierung(this.getConnection(), rs, buendel, auftrag, -32, this.timeStampEnd, this.producer.getUsrID(), this.producer.getDisplayName(), null, null, null, null, 0, null, 0, null);
                    } else if (additinalAction != 0) {
                        ServerUtilities.addRealisierung(this.getConnection(), rs, buendel, auftrag, additinalAction, this.timeStampEnd, this.producer.getUsrID(), this.producer.getDisplayName(), null, null, null, null, 0, null, 0, null);
                    }
                }
                return null;
            });
            ListResultSet listResultSet = this.sendMail(extensionContext, properties);
            return listResultSet;
        }
    }

    private void updateReaStepIfDataChangedByExtension(ResultSet rs, String content, int attAufID, String updatedContent, int updatedAttAufID) throws SQLException {
        boolean hasAttAufIdChanged;
        boolean hasContentChanged = !content.equals(updatedContent);
        boolean bl = hasAttAufIdChanged = attAufID != updatedAttAufID;
        if (hasContentChanged || hasAttAufIdChanged) {
            if (hasContentChanged) {
                rs.updateString("was", updatedContent);
            }
            if (hasAttAufIdChanged) {
                rs.updateInt("AttAufID", updatedAttAufID);
            }
            rs.updateRow();
        }
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Calling fixed statement")
    private ListResultSet sendMail(MailSendCommandExtensionContext extensionContext, MailSendCommandPropertiesCreator.MailSendCommandProperties properties) throws SQLException {
        int buendel = properties.getBuendel();
        int masterStatus = properties.getMasterStatus();
        boolean bundleSlave = properties.isBundleSlave();
        int resultingStatus = properties.getResultingStatus();
        int auftrag = properties.getAuftrag();
        String von = properties.getVon();
        String an = properties.getAn();
        String cc = properties.getCc();
        String bcc = properties.getBcc();
        int html = properties.getHtml();
        String subject = properties.getSubject();
        int user = properties.getUser();
        String alias = properties.getAlias();
        int minuten = properties.getMinuten();
        String producerDisplayName = this.producer.getDisplayName();
        int producerID = this.producer.getUsrID();
        String content = extensionContext.getContent();
        String contentWithReplacedImageReferences = extensionContext.getContentWithReplacedImageReferences();
        Vector<Object> attachmentPaths = new Vector<Object>(extensionContext.getAttachmentPaths());
        Vector<Object> attachmentFileNames = new Vector<Object>(extensionContext.getAttachmentFileNames());
        TicketManipulatorBackdoor.getBackdoor().updateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(auftrag, () -> {
            Statement pst = null;
            try {
                pst = this.getConnection().prepareStatement(ServerUtilities.getJJServer().getCommand("NewStepAdded").toString());
                pst.setString(1, producerDisplayName);
                pst.setInt(2, producerID);
                pst.setInt(3, 0);
                pst.setInt(4, masterStatus);
                pst.setInt(5, buendel);
                pst.execute();
                if (bundleSlave) {
                    pst.setString(1, producerDisplayName);
                    pst.setInt(2, producerID);
                    pst.setInt(3, 1);
                    pst.setInt(4, resultingStatus);
                    pst.setInt(5, auftrag);
                    pst.execute();
                }
            }
            finally {
                try {
                    pst.close();
                }
                catch (Throwable throwable) {}
            }
            return null;
        });
        Object[] result = new Object[]{new Integer(this.reaStepId), OpenOrderController.getCurrentVersion(), content};
        Mail.send(auftrag, this.reaStepId, contentWithReplacedImageReferences, html != 0, subject, an, cc != null ? cc : "", bcc != null ? bcc : "", von, alias, attachmentPaths, attachmentFileNames);
        if (minuten != 0) {
            TicketManipulatorBackdoor.getBackdoor().updateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(auftrag, () -> {
                ServerUtilities.calculateProcessingTime(this.getConnection(), auftrag);
                return null;
            });
            Auftrag ticket = ServerUtilities.getOpenOrderController().getAuftrag(auftrag);
            if (ticket != null) {
                result[1] = ticket.getVersion();
            }
        }
        ListResultSet theRS = new ListResultSet();
        ArrayList<Object[]> daten = new ArrayList<Object[]>();
        daten.add(result);
        theRS.setColumns(COLUMNS_ANSWER);
        theRS.setColumnTypes(TYPEN_ANSWER);
        theRS.setValues(daten);
        return theRS;
    }

    private MailSendCommandPropertiesCreator.MailSendCommandProperties getProperties() throws SQLException {
        MailSendCommandPropertiesCreator creator = new MailSendCommandPropertiesCreator();
        creator.setBundleSlave(false);
        int resultingStatus = this.getIntValueForKey("targetStatus", -1);
        creator.setResultingStatus(resultingStatus);
        int auftrag = this.getIntValueForKey("AufID", 0);
        creator.setAuftrag(auftrag);
        int buendel = this.getIntValueForKey("BunID", -1);
        creator.setBuendel(buendel);
        if (auftrag == 0) {
            creator.setAuftrag(buendel);
            creator.setMasterStatus(resultingStatus);
        } else {
            creator.setBundleSlave(true);
            creator.setMasterStatus(this.getIntValueForKey("masterStatus", -1));
        }
        creator.setUser(this.getIntValueForKey("UsrID", -1));
        creator.setSession(this.getIntValueForKey("hdsession", -1));
        creator.setVon((String)this.get("Absender"));
        creator.setAlias((String)this.get("AbsenderAlias"));
        creator.setAn((String)this.get("Empfaenger"));
        creator.setCc((String)this.get("CC"));
        creator.setBcc((String)this.get("BCC"));
        creator.setSubject((String)this.get("Betreff"));
        creator.setHtml(this.getIntValueForKey("HtmlMsg", 0));
        int attachmentCount = this.getIntValueForKey("Anlagen", 0);
        creator.setAttachmentCount(attachmentCount);
        creator.setMinuten(this.getIntValueForKey("Zeit", 0));
        creator.setAdditionalAction(this.getIntValueForKey("AktID", 0));
        return creator.getProperties();
    }

    private MailSendCommandExtensionContext createExtensionContext() throws SQLException {
        int attachmentCount = this.getIntValueForKey("Anlagen", 0);
        MailSendCommandExtensionContext extensionContext = new MailSendCommandExtensionContext();
        extensionContext.setContent((String)this.get("MsgText"));
        extensionContext.setContentWithReplacedImageReferences((String)this.get("MsgText"));
        ArrayList<String> attachmentPaths = new ArrayList<String>();
        ArrayList<String> attachmentFileNames = new ArrayList<String>();
        ArrayList<Date> attachmentLastmodifies = new ArrayList<Date>();
        for (int index = 0; index < attachmentCount; ++index) {
            String fileDisplayName = (String)this.get("Filename" + index);
            if (attachmentFileNames.contains(fileDisplayName)) {
                attachmentFileNames.add(UtilityFunctions.getUniqueFileName(fileDisplayName, attachmentFileNames));
            } else {
                attachmentFileNames.add(fileDisplayName);
            }
            attachmentPaths.add((String)this.get("Attachment" + index));
            attachmentLastmodifies.add(new Date((Long)this.get("AttachmentLastModified" + index)));
        }
        extensionContext.setAttachmentPaths(attachmentPaths);
        extensionContext.setAttachmentFileNames(attachmentFileNames);
        extensionContext.setAttachmentLastmodifies(attachmentLastmodifies);
        return extensionContext;
    }

    @Override
    public boolean execute() throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public int executeUpdate() throws SQLException {
        throw new SQLException("not supported");
    }
}

