/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.client;

import com.inet.annotations.JsonData;
import com.inet.lib.json.Json;
import com.inet.plugin.extensionpoint.abstracts.AbstractExtension;
import java.util.ArrayList;

@JsonData
public class ClientPlugin {
    private String id;
    private String basePackage;
    private String jarFile;
    private ArrayList<ExtensionContainer> extensions;

    private ClientPlugin() {
    }

    public ClientPlugin(String id, String basePackage, String jarFile, ArrayList<AbstractExtension> extensions) {
        this.id = id;
        this.basePackage = basePackage;
        this.jarFile = jarFile;
        this.extensions = new ArrayList();
        if (extensions != null) {
            for (AbstractExtension extension : extensions) {
                this.extensions.add(new ExtensionContainer(extension));
            }
        }
    }

    public String getID() {
        return this.id;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public String getJarFile() {
        return this.jarFile;
    }

    public ArrayList<ExtensionContainer> getExtensions() {
        ArrayList<ExtensionContainer> extensions = new ArrayList<ExtensionContainer>();
        if (this.extensions != null) {
            for (ExtensionContainer container : this.extensions) {
                extensions.add(container);
            }
        }
        return extensions;
    }

    @JsonData
    public static class ExtensionContainer {
        private String className;
        private String extensionAsJson;
        private transient AbstractExtension extension;

        private ExtensionContainer() {
        }

        public ExtensionContainer(AbstractExtension extension) {
            this.className = extension.getClass().getName();
            this.extensionAsJson = new Json().toJson((Object)extension);
        }

        public synchronized AbstractExtension getExtension() {
            if (this.extension == null) {
                try {
                    Class<?> extClass = Class.forName(this.className, true, Thread.currentThread().getContextClassLoader());
                    this.extension = (AbstractExtension)new Json().fromJson(this.extensionAsJson, extClass);
                    this.extensionAsJson = null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return this.extension;
        }
    }
}

