/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.util;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.extensions.AddAttachmentsExtensionData;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentFilePathBuilder;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.helpdesk.webapi.data.step.AttachmentResponseData;
import com.inet.http.upload.AttachmentDescription;
import com.inet.logging.LogManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.http.upload.AttachmentType;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;

public class HelpDeskWebAPIAttachmentsHelper {
    public static void addAttachmentsToExtensionArguments(ExtensionArguments extensionArgs, HttpServletRequest request, List<AttachmentDescription> attachments) {
        if (attachments == null) {
            return;
        }
        int attachmentCounter = 0;
        ArrayList<LargeContent> attachmentsWithData = new ArrayList<LargeContent>();
        for (AttachmentDescription attachment : attachments) {
            try {
                final Part part = request.getPart("attachment" + attachmentCounter++);
                if (part == null) continue;
                LargeContent lc = new LargeContent(new LargeContent.InputStreamProvider(){

                    @Override
                    public InputStream getStream() {
                        try {
                            return part.getInputStream();
                        }
                        catch (Exception e) {
                            LogManager.getApplicationLogger().error((Object)e);
                            return null;
                        }
                    }

                    @Override
                    public long getSize() {
                        return part.getSize();
                    }
                });
                lc.setContentType(AttachmentType.valueOf((String)attachment.getAttachmentType().toString()));
                lc.setLastModified(attachment.getLastModified());
                lc.setName(attachment.getName());
                attachmentsWithData.add(lc);
            }
            catch (IOException | IllegalStateException | ServletException e) {
                LogManager.getApplicationLogger().error((Object)e);
            }
        }
        if (attachmentsWithData.size() > 0) {
            extensionArgs.put(AttachmentsServerPlugin.EXTARG_ATTACHMENTS, new AddAttachmentsExtensionData(attachmentsWithData));
        }
    }

    public static List<AttachmentResponseData> getAttachmentResponseDataForTicket(int ticketId) {
        AttachmentService attachmentService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
        try {
            Map fullAttachmentDataFor = attachmentService.getFullAttachmentDataFor(AttachmentOwnerType.TicketAttachment, Arrays.asList(ticketId));
            return fullAttachmentDataFor.keySet().stream().map(e -> new AttachmentResponseData(e.getStepId(), e.getFileName(), e.getFileLength(), e.getLastModified(), AttachmentFilePathBuilder.getRestfulPathForClient((AttachmentKey)e.getAttachmentKey()), e.isEmbedded())).collect(Collectors.toList());
        }
        catch (SQLException e2) {
            LogManager.getApplicationLogger().error((Object)e2);
            return Collections.emptyList();
        }
    }
}

