/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.ticket.step;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.webapi.HelpDeskTicketWebAPIExtension;
import com.inet.helpdesk.webapi.data.step.AttachmentResponseData;
import com.inet.helpdesk.webapi.data.step.TicketStepDetailedEntryResponseData;
import com.inet.helpdesk.webapi.util.HelpDeskWebAPIAttachmentsHelper;
import com.inet.helpdesk.webapi.util.HelpDeskWebAPIHelper;
import com.inet.http.ClientMessageException;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.webapi.api.PathTokenizer;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.GenericInfoHandler;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@InternalApi
public class HelpDeskTicketStepIdHandler
extends GenericInfoHandler<Integer, ReaStepVO> {
    public static final String INLINE_REASTEP_IMAGES = "inlineImages";

    public HelpDeskTicketStepIdHandler() {
        super(new String[]{"stepId"});
    }

    public Integer typeFor(String token) {
        try {
            return Integer.valueOf(token);
        }
        catch (NumberFormatException e) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.step.idNotInteger", new Object[]{token}));
        }
    }

    public String getHelpPageKey() {
        return "webapi.ticket.id.step.id";
    }

    public ReaStepVO handle(HttpServletRequest request, HttpServletResponse response, Integer stepId, List<String> pathTokens, boolean previewModeEnabled) throws IOException {
        boolean requiresChecksum;
        List pathToTokens = PathTokenizer.convertPathToTokens((String)request.getPathInfo());
        if (pathToTokens.size() < 2) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.notATicketId", new Object[]{request.getPathInfo()}));
        }
        String ticketIdToken = (String)pathToTokens.get(1);
        int ticketID = Tickets.decodeTicketID(ticketIdToken, requiresChecksum = HelpDeskWebAPIHelper.requestRequiresEncodedTicketId());
        if (ticketID == -1) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.notATicketId", new Object[]{ticketIdToken}));
        }
        ReaStepVO reaStep = TicketManager.getReader().getReaStep(stepId);
        if (reaStep == null) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.step.notAStepId", new Object[]{stepId}));
        }
        if (reaStep.getOrgBunID() != ticketID) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.step.idNotForTicket", new Object[]{stepId, ticketIdToken}));
        }
        HelpDeskWebAPIHelper.checkReaStepReadAccessOrThrow(stepId, response);
        List<String> requestedFields = HelpDeskWebAPIHelper.getRequestedFields(request, fields -> {
            fields.addAll(reaStep.getIncludedAttributes().parallelStream().map(a -> a.getKey()).collect(Collectors.toList()));
            fields.addAll(reaStep.getIncludedFields().parallelStream().map(a -> a.getKey()).collect(Collectors.toList()));
        });
        ReaStepTextVO reaStepText = TicketManager.getReader().getReaStepText(stepId);
        List<AttachmentResponseData> attachments = null;
        if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
            attachments = HelpDeskWebAPIAttachmentsHelper.getAttachmentResponseDataForTicket(ticketID);
            attachments.removeIf(a -> a.getStepId().intValue() != reaStep.getID());
        }
        ResponseWriter.json((HttpServletResponse)response, (Object)TicketStepDetailedEntryResponseData.from(reaStep, reaStepText, request.getAttribute(INLINE_REASTEP_IMAGES) != null, requestedFields, attachments));
        return reaStep;
    }
}

