/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.user;

import com.inet.error.ErrorCode;
import com.inet.helpdesk.login.FirstUserPermissionsHandler;
import com.inet.helpdesk.search.user.tokenmatchers.EnduserFilterTokenMatcher;
import com.inet.helpdesk.search.user.tokenmatchers.GroupUFTM;
import com.inet.helpdesk.search.user.tokenmatchers.HasEmailConditionTokenMatcher;
import com.inet.helpdesk.search.user.tokenmatchers.SupporterUserConditionTokenMatcher;
import com.inet.helpdesk.search.user.tokenmatchers.TouchedTicketUFTM;
import com.inet.helpdesk.usersandgroups.HelpDeskReindexKeyGenerator;
import com.inet.helpdesk.usersandgroups.user.HelpDeskUserManager;
import com.inet.logging.LogManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.TokenMatcher;
import com.inet.search.veto.SearchIndexVeto;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserManagerFactory;
import com.inet.usersandgroups.api.user.LoggedInUsersConditionTokenMatcher;
import com.inet.usersandgroups.api.user.UserEventListener;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.api.user.search.UserSearchEngine;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

public class HelpDeskUserManagerFactory
implements UserManagerFactory {
    public UserManager createManager(final boolean useOriginalInRecoveryMode, SearchIndexVeto searchIndexVeto) {
        List<TokenMatcher> tokenMatchers = Arrays.asList(new GroupUFTM(), new SupporterUserConditionTokenMatcher(), new EnduserFilterTokenMatcher(), new TouchedTicketUFTM(), new LoggedInUsersConditionTokenMatcher(), new HasEmailConditionTokenMatcher());
        UserSearchEngine searchEngine = new UserSearchEngine(tokenMatchers, useOriginalInRecoveryMode){

            protected String createReindexKey() {
                String reindexKey = HelpDeskReindexKeyGenerator.createReindexKey(useOriginalInRecoveryMode);
                return reindexKey + ";v3";
            }
        };
        searchEngine.setSearchIndexVeto(searchIndexVeto);
        ServerPluginManager spm = ServerPluginManager.getInstance();
        UserManager userManager = this.createManager(spm, searchEngine);
        spm.get(UserEventListener.class).forEach(listener -> userManager.registerListener(listener));
        return userManager;
    }

    @Nonnull
    UserManager createManager(ServerPluginManager spm, UserSearchEngine searchEngine) {
        HelpDeskUserManager userManager = new HelpDeskUserManager(searchEngine, new FirstUserPermissionsHandler());
        List userFields = spm.get(UserField.class);
        try {
            userManager.init(userFields);
        }
        catch (Exception ex) {
            LogManager.getConfigLogger().fatal((Object)ex);
            ErrorCode.throwAny((Throwable)ex);
        }
        return userManager;
    }
}

