/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.ui.fields.user;

import com.inet.helpdesk.shared.communication.LocationDataAccess;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.SelectFieldDefinitionUtils;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.SelectFieldValue;
import com.inet.usersandgroups.api.ui.fields.SelectOption;
import com.inet.usersandgroups.api.ui.fields.SelectOptionResult;
import com.inet.usersandgroups.api.ui.fields.user.SelectUserFieldDefinition;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class LocationUserFieldDefinition
extends SelectUserFieldDefinition<Integer> {
    private final int settingId;

    public LocationUserFieldDefinition(int prio, int settingId) {
        super("user.masterdata", HDUsersAndGroups.FIELD_LOCATION_ID.getKey(), prio);
        this.settingId = settingId;
    }

    public SelectOption getValue(UserAccount userAccount) {
        Integer value = null;
        if (userAccount != null) {
            value = (Integer)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
        }
        if (value == null) {
            value = (Integer)HDUsersAndGroups.FIELD_LOCATION_ID.getDefaultValue();
        }
        if (value == null) {
            value = 0;
        }
        Map locations = HDUsersAndGroups.FIELD_LOCATION_ID.getSearchTag().getMapData();
        return new SelectOption(value.toString(), (String)locations.get(value));
    }

    public SelectOptionResult getOptions(UserAccount userAccount, String searchTerm, int currentSize, int chunkSize) {
        Map<Integer, String> locations;
        LocationDataAccess locationDataAccess = (LocationDataAccess)ServerPluginManager.getInstance().getSingleInstance(LocationDataAccess.class);
        try {
            locations = locationDataAccess.getAllDisplayNames(true);
        }
        catch (IOException e) {
            locations = new HashMap<Integer, String>();
        }
        return SelectFieldDefinitionUtils.getOptions(searchTerm, currentSize, chunkSize, locations);
    }

    public Integer convertFromString(String value) {
        if (!StringFunctions.isEmpty((String)value)) {
            SelectOption option = (SelectOption)new Json().fromJson(value, SelectOption.class);
            try {
                return Integer.valueOf(option.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public String getLabel() {
        return HDFieldDisplayNameProvider.getDisplayNameForCustomField(HDUsersAndGroups.FIELD_LOCATION_ID);
    }

    public boolean isAvailable(UserAccount userAccount) {
        if (HDUsersAndGroups.isSupporter(UserManager.getInstance().getCurrentUserAccount())) {
            return true;
        }
        return !HDUsersAndGroups.isFieldOptionSet(this.settingId, 32);
    }

    public SelectFieldValue getFieldValue(UserAccount userAccount) {
        SelectFieldValue result = super.getFieldValue(userAccount);
        if (!HDUsersAndGroups.isSupporter(UserManager.getInstance().getCurrentUserAccount()) && HDUsersAndGroups.isFieldOptionSet(this.settingId, 4)) {
            result.setEnabled(false);
        }
        return result;
    }
}

